/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class CursedBarkBlock
extends Block {
    private static final VoxelShape shape = Shapes.m_83040_();

    public CursedBarkBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_280170_().m_60978_(0.0f).m_278166_(PushReaction.DESTROY).m_278183_().m_60971_(UtilLib::never).m_60918_(SoundType.f_56760_));
        ((FireBlock)Blocks.f_50083_).m_53444_((Block)this, 5, 5);
    }

    protected void moveEntityTo(@NotNull Level level, @NotNull Entity entity, @NotNull BlockPos targetPos) {
        if (targetPos.equals((Object)entity.m_20183_())) {
            return;
        }
        Vec3 thrust = new Vec3((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_()).m_82492_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()).m_82541_().m_82490_(0.04);
        if (!entity.m_20096_()) {
            thrust = thrust.m_82490_(0.3);
        }
        entity.m_20256_(entity.m_20184_().m_82549_(thrust));
        if (!level.f_46443_) {
            if (entity instanceof Player) {
                VampirePlayer.getOpt((Player)entity).ifPresent(vampire -> {
                    if (vampire.getRemainingBarkTicks() == 0) {
                        vampire.removeBlood(0.02f);
                        vampire.increaseRemainingBarkTicks(40);
                    }
                });
            } else {
                ExtendedCreature.getSafe(entity).ifPresent(creature -> {
                    if (((ExtendedCreature)creature).getRemainingBarkTicks() == 0) {
                        creature.setBlood(creature.getBlood() - 1);
                        ((ExtendedCreature)creature).sync();
                        ((ExtendedCreature)creature).increaseRemainingBarkTicks(40);
                    }
                });
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState p_60555_, @NotNull BlockGetter p_60556_, @NotNull BlockPos p_60557_, @NotNull CollisionContext p_60558_) {
        return shape;
    }

    protected void m_142387_(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state) {
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        return true;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }
}

