/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import de.teamlapen.vampirism.blocks.CursedBarkBlock;
import de.teamlapen.vampirism.util.Helper;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectCursedBarkBlock
extends CursedBarkBlock {
    public static final EnumProperty<Type> UP_TYPE = EnumProperty.m_61587_((String)"up_type", Type.class);
    public static final EnumProperty<Type> DOWN_TYPE = EnumProperty.m_61587_((String)"down_type", Type.class);
    public static final EnumProperty<Type> NORTH_TYPE = EnumProperty.m_61587_((String)"north_type", Type.class);
    public static final EnumProperty<Type> SOUTH_TYPE = EnumProperty.m_61587_((String)"south_type", Type.class);
    public static final EnumProperty<Type> WEST_TYPE = EnumProperty.m_61587_((String)"west_type", Type.class);
    public static final EnumProperty<Type> EAST_TYPE = EnumProperty.m_61587_((String)"east_type", Type.class);
    public static final BiMap<Direction, EnumProperty<Type>> SIDE_MAP = ImmutableBiMap.builder().put((Object)Direction.UP, UP_TYPE).put((Object)Direction.DOWN, DOWN_TYPE).put((Object)Direction.EAST, EAST_TYPE).put((Object)Direction.WEST, WEST_TYPE).put((Object)Direction.NORTH, NORTH_TYPE).put((Object)Direction.SOUTH, SOUTH_TYPE).build();

    public DirectCursedBarkBlock() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(UP_TYPE, (Comparable)((Object)Type.NONE))).m_61124_(DOWN_TYPE, (Comparable)((Object)Type.NONE))).m_61124_(EAST_TYPE, (Comparable)((Object)Type.NONE))).m_61124_(WEST_TYPE, (Comparable)((Object)Type.NONE))).m_61124_(NORTH_TYPE, (Comparable)((Object)Type.NONE))).m_61124_(SOUTH_TYPE, (Comparable)((Object)Type.NONE)));
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (Helper.isVampire(entity) || entity instanceof Player && ((Player)entity).m_150110_().f_35934_) {
            return;
        }
        BlockPos targetPos = pos;
        for (Map.Entry entry : SIDE_MAP.entrySet()) {
            if (state.m_61143_((Property)entry.getValue()) == Type.NONE) continue;
            targetPos = targetPos.m_121945_((Direction)entry.getKey());
        }
        this.moveEntityTo(level, entity, targetPos);
    }

    private boolean canAttachTo(@NotNull BlockGetter blockReader, @NotNull BlockPos pos, @NotNull Direction direction) {
        BlockState blockstate = blockReader.m_8055_(pos);
        return blockstate.m_60783_(blockReader, pos, direction);
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader worldReader, @NotNull BlockPos blockPos) {
        for (Map.Entry entry : SIDE_MAP.entrySet()) {
            if (state.m_61143_((Property)entry.getValue()) == Type.NONE || !this.canAttachTo((BlockGetter)worldReader, blockPos.m_121945_((Direction)entry.getKey()), ((Direction)entry.getKey()).m_122424_())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState blockState, @NotNull Direction direction, @NotNull BlockState otherState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos otherPos) {
        EnumProperty property = (EnumProperty)SIDE_MAP.get((Object)direction);
        if (blockState.m_61143_((Property)property) != Type.NONE) {
            if (!this.canAttachTo((BlockGetter)level, otherPos, direction.m_122424_())) {
                BlockState state = (BlockState)blockState.m_61124_((Property)property, (Comparable)((Object)Type.NONE));
                if (!DirectCursedBarkBlock.anySideAvailable(state)) {
                    state = Blocks.f_50016_.m_49966_();
                }
                return state;
            }
        } else if (!DirectCursedBarkBlock.anySideAvailable(blockState)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(blockState, direction, otherState, level, pos, otherPos);
    }

    private static boolean anySideAvailable(BlockState state) {
        return SIDE_MAP.values().stream().anyMatch(property -> state.m_61143_((Property)property) != Type.NONE);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Direction direction = context.m_7820_();
        return (BlockState)this.m_49966_().m_61124_((Property)SIDE_MAP.get((Object)direction), (Comparable)((Object)Type.VERTICAL));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(SIDE_MAP.values().toArray(new Property[0]));
    }

    public static enum Type implements StringRepresentable
    {
        VERTICAL,
        HORIZONTAL,
        NONE;


        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

