/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.inventory.HunterTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterTableBlock
extends VampirismHorizontalBlock {
    public static final EnumProperty<TABLE_VARIANT> VARIANT = EnumProperty.m_61587_((String)"variant", TABLE_VARIANT.class);
    private static final VoxelShape SOUTH = HunterTableBlock.makeShape();
    private static final VoxelShape WEST = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.NINETY);
    private static final VoxelShape NORTH = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.HUNDRED_EIGHTY);
    private static final VoxelShape EAST = UtilLib.rotateShape(SOUTH, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)10.0, (double)2.0);
        VoxelShape b = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)2.0);
        VoxelShape c = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)10.0, (double)16.0);
        VoxelShape d = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape e = Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
        VoxelShape f = Block.m_49796_((double)8.5, (double)10.0, (double)3.5, (double)13.5, (double)11.0, (double)10.0);
        VoxelShape d1 = Shapes.m_83110_((VoxelShape)a, (VoxelShape)b);
        VoxelShape d2 = Shapes.m_83110_((VoxelShape)c, (VoxelShape)d);
        VoxelShape d3 = Shapes.m_83110_((VoxelShape)d1, (VoxelShape)d2);
        VoxelShape f1 = Shapes.m_83110_((VoxelShape)e, (VoxelShape)f);
        return Shapes.m_83110_((VoxelShape)d3, (VoxelShape)f1);
    }

    @NotNull
    public static TABLE_VARIANT getTierFor(boolean weapon_table, boolean potion_table, boolean cauldron) {
        return weapon_table ? (potion_table ? (cauldron ? TABLE_VARIANT.COMPLETE : TABLE_VARIANT.WEAPON_POTION) : (cauldron ? TABLE_VARIANT.WEAPON_CAULDRON : TABLE_VARIANT.WEAPON)) : (potion_table ? (cauldron ? TABLE_VARIANT.POTION_CAULDRON : TABLE_VARIANT.POTION) : (cauldron ? TABLE_VARIANT.CAULDRON : TABLE_VARIANT.SIMPLE));
    }

    public HunterTableBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(0.5f).m_278183_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(VARIANT, (Comparable)((Object)TABLE_VARIANT.SIMPLE)));
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    @Override
    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(VARIANT, (Comparable)((Object)this.determineTier((LevelReader)context.m_43725_(), context.m_8083_(), facing)));
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (fromPos.m_123342_() != pos.m_123342_()) {
            return;
        }
        TABLE_VARIANT newVariant = this.determineTier((LevelReader)worldIn, pos, (Direction)state.m_61143_((Property)FACING));
        if (newVariant != state.m_61143_(VARIANT)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)newVariant)), 2);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!worldIn.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> new HunterTableMenu(id, playerInventory, ContainerLevelAccess.m_39289_((Level)playerIn.m_9236_(), (BlockPos)pos)), (Component)Component.m_237115_((String)"container.crafting")), (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, VARIANT});
    }

    protected TABLE_VARIANT determineTier(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Direction facing) {
        Block behind = world.m_8055_(pos.m_121945_(facing)).m_60734_();
        Block left = world.m_8055_(pos.m_121945_(facing.m_122427_())).m_60734_();
        Block right = world.m_8055_(pos.m_121945_(facing.m_122428_())).m_60734_();
        Block front = world.m_8055_(pos.m_121945_(facing.m_122424_())).m_60734_();
        boolean weapon_table = left == ModBlocks.WEAPON_TABLE.get() || right == ModBlocks.WEAPON_TABLE.get() || behind == ModBlocks.WEAPON_TABLE.get() || front == ModBlocks.WEAPON_TABLE.get();
        boolean potion_table = left == ModBlocks.POTION_TABLE.get() || right == ModBlocks.POTION_TABLE.get() || behind == ModBlocks.POTION_TABLE.get() || front == ModBlocks.POTION_TABLE.get();
        boolean cauldron = left == ModBlocks.ALCHEMICAL_CAULDRON.get() || right == ModBlocks.ALCHEMICAL_CAULDRON.get() || behind == ModBlocks.ALCHEMICAL_CAULDRON.get() || front == ModBlocks.ALCHEMICAL_CAULDRON.get();
        return HunterTableBlock.getTierFor(weapon_table, potion_table, cauldron);
    }

    public static enum TABLE_VARIANT implements StringRepresentable
    {
        SIMPLE("simple", 0),
        WEAPON("weapon", 1),
        CAULDRON("cauldron", 1),
        POTION("potion", 1),
        WEAPON_CAULDRON("weapon_cauldron", 2),
        WEAPON_POTION("weapon_potion", 2),
        POTION_CAULDRON("potion_cauldron", 2),
        COMPLETE("complete", 3);

        public final String name;
        public final int tier;

        private TABLE_VARIANT(String n2, int tier) {
            this.name = n2;
            this.tier = tier;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

