/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.taskboard;

import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.client.gui.components.ContainerObjectSelectionListWithDummy;
import de.teamlapen.lib.lib.util.MultilineTooltip;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.entity.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.entity.player.tasks.reward.ItemRewardInstance;
import de.teamlapen.vampirism.inventory.TaskMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskList
extends ContainerObjectSelectionListWithDummy<ITaskInstance, TaskEntry, DummyEntry> {
    protected static final ResourceLocation TASKMASTER_GUI_TEXTURE = new ResourceLocation("vampirism", "textures/gui/taskmaster.png");
    protected final TaskMenu menu;
    protected final IFactionPlayer<?> factionPlayer;

    public TaskList(Minecraft minecraft, TaskMenu menu, IFactionPlayer<?> factionPlayer, int x, int y, int width, int height, int itemHeight, Supplier<List<ITaskInstance>> itemSupplier) {
        super(minecraft, width, height, y, y + height, itemHeight, itemSupplier);
        this.menu = menu;
        this.factionPlayer = factionPlayer;
        this.m_93507_(x);
    }

    @Override
    protected TaskEntry createItem(ITaskInstance item) {
        return new TaskEntry(item);
    }

    @Override
    protected DummyEntry createDummy(ITaskInstance item) {
        return new DummyEntry(item);
    }

    @Override
    protected boolean isEquivalent(ITaskInstance item1, ITaskInstance item2) {
        return Objects.equals(item1.getId(), item2.getId());
    }

    public class TaskEntry
    extends ContainerObjectSelectionListWithDummy.ItemEntry {
        private final Tooltip tooltip;

        public TaskEntry(ITaskInstance item) {
            super(item);
            this.tooltip = this.generateTaskToolTip();
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }

        public void renderBackground(GuiGraphics graphics, Minecraft minecraft, int pTop, int pLeft, int pWidth, int pHeight, int mouseX, int mouseY, float partialTicks) {
            if (TaskList.this.menu.isCompleted((ITaskInstance)this.getItem())) {
                graphics.m_280246_(0.4f, 0.4f, 0.4f, 1.0f);
            } else {
                boolean remainsTime;
                boolean isUnique = ((ITaskInstance)this.getItem()).isUnique();
                boolean bl = remainsTime = ((ITaskInstance)this.getItem()).getTaskTimeStamp() - minecraft.f_91073_.m_46467_() > 0L;
                if (TaskList.this.menu.canCompleteTask((ITaskInstance)this.getItem())) {
                    if (isUnique) {
                        graphics.m_280246_(1.0f, 0.8558594f, 0.0f, 1.0f);
                    } else {
                        graphics.m_280246_(0.0f, 0.9f, 0.0f, 1.0f);
                    }
                } else if (TaskList.this.menu.isTaskNotAccepted((ITaskInstance)this.getItem())) {
                    if (isUnique) {
                        graphics.m_280246_(0.64f, 0.57f, 0.5f, 1.0f);
                    } else {
                        graphics.m_280246_(0.55f, 0.55f, 0.55f, 1.0f);
                    }
                } else if (!isUnique && !remainsTime) {
                    graphics.m_280246_(1.0f, 0.33333334f, 0.33333334f, 1.0f);
                } else if (isUnique) {
                    graphics.m_280246_(1.0f, 0.9f, 0.6f, 1.0f);
                } else {
                    graphics.m_280246_(0.85f, 1.0f, 0.85f, 1.0f);
                }
            }
            graphics.m_280398_(TASKMASTER_GUI_TEXTURE, pLeft, pTop, 0, 17.0f, 187.0f, Math.min(pWidth - 1, 135), pHeight, 256, 256);
            graphics.m_280398_(TASKMASTER_GUI_TEXTURE, pLeft + pWidth - Math.min(pWidth - 1, 135), pTop, 0, (float)(17 + (135 - Math.min(pWidth - 1, 134))), 187.0f, Math.min(pWidth - 1, 135), pHeight, 256, 256);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public void m_6311_(GuiGraphics graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            Minecraft mc = Minecraft.m_91087_();
            this.renderBackground(graphics, mc, pTop, pLeft, pWidth, pHeight + 4, pMouseX, pMouseY, pPartialTick);
            Optional<FormattedCharSequence> text = Optional.ofNullable((FormattedCharSequence)mc.f_91062_.m_92923_((FormattedText)((ITaskInstance)this.getItem()).getTask().getTranslation(), 131).get(0));
            text.ifPresent(t -> graphics.m_280649_(mc.f_91062_, t, pLeft + 2, pTop + 4, 3419941, false));
            if (!TaskList.this.menu.isTaskNotAccepted((ITaskInstance)this.getItem()) && !((ITaskInstance)this.getItem()).isUnique()) {
                MutableComponent msg;
                long remainingTime = ((ITaskInstance)this.getItem()).getTaskTimeStamp() - Minecraft.m_91087_().f_91073_.m_46467_();
                if (remainingTime >= 0L) {
                    long hours = (remainingTime /= 20L) / 60L / 60L;
                    long minutes = remainingTime / 60L % 60L;
                    long seconds = remainingTime % 60L;
                    String time = hours + ":";
                    if (minutes < 10L) {
                        time = time + "0";
                    }
                    time = time + minutes + ":";
                    if (seconds < 10L) {
                        time = time + "0";
                    }
                    time = time + seconds;
                    msg = Component.m_237113_((String)time);
                } else {
                    msg = Component.m_237115_((String)"text.vampirism.task_failed");
                }
                int width = mc.f_91062_.m_92852_((FormattedText)msg);
                int color = 0xAAAAAA;
                if ((float)remainingTime < (float)((ITaskInstance)this.getItem()).getTaskDuration() / 20.0f * 0.1f) {
                    color = 0xFF5555;
                }
                graphics.m_280614_(mc.f_91062_, (Component)msg, pLeft + pWidth - width - 1, pTop + 12, color, true);
            }
            if (this.m_5953_(pMouseX, pMouseY)) {
                this.renderToolTips(mc, pMouseX, pMouseY);
            }
        }

        protected void renderToolTips(Minecraft minecraft, int mouseX, int mouseY) {
            minecraft.f_91080_.m_262791_(this.tooltip, DefaultTooltipPositioner.f_262752_, this.m_93696_());
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        private Tooltip generateTaskToolTip() {
            Task task = ((ITaskInstance)this.getItem()).getTask();
            ArrayList<Component> toolTips = new ArrayList<Component>();
            toolTips.add((Component)task.getTranslation().m_6879_().m_130938_(style -> style.m_131148_(TaskList.this.menu.getFactionColor())));
            if (task.useDescription()) {
                toolTips.add(task.getDescription());
                toolTips.add((Component)Component.m_237113_((String)" "));
            }
            if (TaskList.this.menu.isTaskNotAccepted((ITaskInstance)this.getItem())) {
                toolTips.add((Component)Component.m_237115_((String)"gui.vampirism.taskmaster.not_accepted"));
            } else {
                for (List<TaskRequirement.Requirement<?>> requirements : task.getRequirement().requirements().values()) {
                    if (requirements == null) continue;
                    TaskRequirement.Type type = requirements.get(0).getType();
                    boolean completed = TaskList.this.menu.areRequirementsCompleted((ITaskInstance)this.getItem(), type);
                    MutableComponent title = Component.m_237115_((String)type.getTranslationKey()).m_130946_(":");
                    if (completed) {
                        title.m_130940_(ChatFormatting.STRIKETHROUGH);
                    }
                    toolTips.add((Component)title);
                    for (TaskRequirement.Requirement<?> requirement : requirements) {
                        MutableComponent desc;
                        int completedAmount = TaskList.this.menu.getRequirementStatus((ITaskInstance)this.getItem(), requirement);
                        switch (type) {
                            case ITEMS: {
                                MutableComponent mutableComponent = ((Item)requirement.getStat(TaskList.this.factionPlayer)).m_41466_().m_6879_().m_130946_(" " + completedAmount + "/" + requirement.getAmount(TaskList.this.factionPlayer));
                                break;
                            }
                            case STATS: {
                                MutableComponent mutableComponent = Component.m_237115_((String)("stat." + requirement.getStat(TaskList.this.factionPlayer).toString().replace(':', '.'))).m_130946_(" " + completedAmount + "/" + requirement.getAmount(TaskList.this.factionPlayer));
                                break;
                            }
                            case ENTITY: {
                                MutableComponent mutableComponent = ((EntityType)requirement.getStat(TaskList.this.factionPlayer)).m_20676_().m_6879_().m_130946_(" " + completedAmount + "/" + requirement.getAmount(TaskList.this.factionPlayer));
                                break;
                            }
                            case ENTITY_TAG: {
                                MutableComponent mutableComponent = Component.m_237115_((String)("tasks.vampirism." + ((TagKey)requirement.getStat(TaskList.this.factionPlayer)).f_203868_())).m_130946_(" " + completedAmount + "/" + requirement.getAmount(TaskList.this.factionPlayer));
                                break;
                            }
                            default: {
                                MutableComponent mutableComponent = desc = Component.m_237115_((String)(task.getTranslationKey() + ".req." + requirement.getId().toString().replace(':', '.')));
                            }
                        }
                        if (completed || TaskList.this.menu.isRequirementCompleted((ITaskInstance)this.getItem(), requirement)) {
                            desc.m_130940_(ChatFormatting.STRIKETHROUGH);
                        }
                        toolTips.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)desc));
                    }
                }
            }
            return new MultilineTooltip(toolTips);
        }
    }

    public class DummyEntry
    extends ContainerObjectSelectionListWithDummy.DummyEntry {
        private final List<AbstractWidget> children;

        public DummyEntry(ITaskInstance item) {
            super(item);
            this.children = new ArrayList<AbstractWidget>();
            List<TaskRequirement.Requirement<?>> all = item.getTask().getRequirement().getAll();
            for (int i = 0; i < all.size(); ++i) {
                this.children.add(new RequirementWidget(6 + i * 20, 3, item, all.get(i)));
            }
            this.children.add(new RewardWidget(3 + TaskList.this.m_5759_() - 45, 3, item));
            this.children.add((AbstractWidget)new TaskActionButton(TaskList.this.m_5759_() - 25, 4));
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }

        public void m_6311_(@NotNull GuiGraphics graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            this.renderBg(graphics, pIndex, pTop, pLeft, pWidth, pHeight + 4, pMouseX, pMouseY, pIsMouseOver, pPartialTick);
            this.children.forEach(w -> ((MovableWidget)w).setOffset(pLeft, pTop));
            this.children.forEach(a -> a.m_88315_(graphics, pMouseX, pMouseY, pPartialTick));
        }

        protected void renderBg(@NotNull GuiGraphics graphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            graphics.blitWithBorder(TASKMASTER_GUI_TEXTURE, pLeft + 2, pTop, 17, 229, pWidth - 4, pHeight, 136, 21, 1, 2, 3, 2);
            graphics.blitWithBorder(TASKMASTER_GUI_TEXTURE, pLeft + pWidth - 40, pTop, 17, 229, 38, pHeight, 136, 21, 1, 2, 3, 2);
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        private class RequirementWidget
        extends ItemWidget {
            protected static final Component REQUIREMENT = Component.m_237115_((String)"gui.vampirism.taskmaster.requirement").m_130940_(ChatFormatting.UNDERLINE);
            protected static final Component REQUIREMENT_STRIKE = REQUIREMENT.m_6879_().m_130940_(ChatFormatting.STRIKETHROUGH);
            private final TaskRequirement.Requirement<?> requirement;
            private final ITaskInstance instance;
            protected static final ItemStack SKULL_ITEM = new ItemStack((ItemLike)Blocks.f_50310_);

            public RequirementWidget(int pX, int pY, @NotNull ITaskInstance instance, TaskRequirement.Requirement<?> requirement) {
                super(pX, pY, switch (requirement.getType()) {
                    case TaskRequirement.Type.ITEMS -> ((ItemRequirement)requirement).getItemStack();
                    case TaskRequirement.Type.ENTITY, TaskRequirement.Type.ENTITY_TAG -> SKULL_ITEM;
                    default -> PAPER;
                });
                this.requirement = requirement;
                this.instance = instance;
            }

            @Override
            protected List<Component> createTooltip() {
                boolean notAccepted = TaskList.this.menu.isTaskNotAccepted(this.instance);
                boolean completed = TaskList.this.menu.isRequirementCompleted(this.instance, this.requirement);
                int completedAmount = TaskList.this.menu.getRequirementStatus(this.instance, this.requirement);
                return switch (this.requirement.getType()) {
                    case TaskRequirement.Type.ITEMS -> this.renderItemTooltip(((ItemRequirement)this.requirement).getItemStack(), completed ? REQUIREMENT_STRIKE : REQUIREMENT, completed, notAccepted ? null : completedAmount + "/");
                    case TaskRequirement.Type.ENTITY -> this.renderGenericRequirementTooltip(TaskRequirement.Type.ENTITY, ((EntityType)this.requirement.getStat(TaskList.this.factionPlayer)).m_20676_().m_6879_().m_130946_((String)(notAccepted ? " " : " " + completedAmount + "/") + this.requirement.getAmount(TaskList.this.factionPlayer)), completed);
                    case TaskRequirement.Type.ENTITY_TAG -> this.renderGenericRequirementTooltip(TaskRequirement.Type.ENTITY_TAG, Component.m_237115_((String)("tasks.vampirism." + ((TagKey)this.requirement.getStat(TaskList.this.factionPlayer)).f_203868_())).m_130946_((String)(notAccepted ? " " : " " + completedAmount + "/") + this.requirement.getAmount(TaskList.this.factionPlayer)), completed);
                    case TaskRequirement.Type.STATS -> this.renderGenericRequirementTooltip(TaskRequirement.Type.STATS, Component.m_237115_((String)("stat." + this.requirement.getStat(TaskList.this.factionPlayer).toString().replace(':', '.'))).m_130946_((String)(notAccepted ? " " : " " + completedAmount + "/") + this.requirement.getAmount(TaskList.this.factionPlayer)), completed);
                    default -> this.renderDefaultRequirementToolTip(this.instance, this.requirement, completed);
                };
            }

            private List<Component> renderDefaultRequirementToolTip(@NotNull ITaskInstance task, @NotNull TaskRequirement.Requirement<?> requirement, boolean strikeThrough) {
                ArrayList tooltips = Lists.newArrayList();
                tooltips.add(strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT);
                MutableComponent text = Component.m_237115_((String)(task.getTask().getTranslationKey() + ".req." + requirement.getId().toString().replace(':', '.')));
                if (strikeThrough) {
                    text.m_130940_(ChatFormatting.STRIKETHROUGH);
                }
                tooltips.add(text);
                return tooltips;
            }

            private List<Component> renderGenericRequirementTooltip(@NotNull TaskRequirement.Type type, @NotNull MutableComponent text, boolean strikeThrough) {
                ArrayList tooltips = Lists.newArrayList();
                MutableComponent title = Component.m_237115_((String)type.getTranslationKey()).m_130946_(":");
                if (strikeThrough) {
                    text.m_130940_(ChatFormatting.STRIKETHROUGH);
                    title.m_130940_(ChatFormatting.STRIKETHROUGH);
                }
                tooltips.add(strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT);
                tooltips.add(title.m_130940_(ChatFormatting.ITALIC));
                tooltips.add(Component.m_237113_((String)"  ").m_7220_((Component)text));
                return tooltips;
            }
        }

        private class RewardWidget
        extends ItemWidget {
            protected static final Component REWARD = Component.m_237115_((String)"gui.vampirism.taskmaster.reward").m_130940_(ChatFormatting.UNDERLINE);
            private final ITaskInstance rewardInstance;

            public RewardWidget(int pX, @NotNull int pY, ITaskInstance rewardInstance) {
                ItemStack itemStack;
                ITaskRewardInstance iTaskRewardInstance = rewardInstance.getReward();
                if (iTaskRewardInstance instanceof ItemRewardInstance) {
                    ItemRewardInstance items = (ItemRewardInstance)iTaskRewardInstance;
                    itemStack = items.getReward();
                } else {
                    itemStack = PAPER;
                }
                super(pX, pY, itemStack);
                this.rewardInstance = rewardInstance;
            }

            @Override
            protected List<Component> createTooltip() {
                ITaskRewardInstance iTaskRewardInstance = this.rewardInstance.getReward();
                if (iTaskRewardInstance instanceof ItemRewardInstance) {
                    ItemRewardInstance item = (ItemRewardInstance)iTaskRewardInstance;
                    return this.renderItemTooltip(item.getReward(), REWARD, false, null);
                }
                return this.renderItemTooltip(this.rewardInstance.getTask());
            }

            private List<Component> renderItemTooltip(@NotNull Task task) {
                ArrayList tooltips = Lists.newArrayList((Object[])new Component[]{REWARD});
                tooltips.add(Component.m_237115_((String)(task.getTranslationKey() + ".reward")));
                return tooltips;
            }
        }

        private class TaskActionButton
        extends ImageButton
        implements MovableWidget {
            private int xOffset;
            private int yOffset;

            public TaskActionButton(int xPos, int yPos) {
                super(xPos, yPos, 14, 13, 0, 0, 0, TASKMASTER_GUI_TEXTURE, 0, 0, a -> de$teamlapen$vampirism$client$gui$screens$taskboard$TaskList$this.menu.pressButton((ITaskInstance)DummyEntry.this.getItem()), (Component)Component.m_237113_((String)""));
            }

            @Override
            public void setOffset(int x, int y) {
                this.xOffset = x;
                this.yOffset = y;
            }

            public int m_252754_() {
                return super.m_252754_() + this.xOffset;
            }

            public int m_252907_() {
                return super.m_252907_() + this.yOffset;
            }

            public void m_5716_(double mouseX, double mouseY) {
                if (mouseX > (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY > (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_)) {
                    super.m_5716_(mouseX, mouseY);
                }
            }

            public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float p_renderButton_3_) {
                TaskMenu.TaskAction action = TaskList.this.menu.buttonAction((ITaskInstance)DummyEntry.this.getItem());
                int j = switch (action) {
                    case TaskMenu.TaskAction.ACCEPT -> 190;
                    case TaskMenu.TaskAction.COMPLETE -> 176;
                    default -> 204;
                };
                graphics.m_280163_(TASKMASTER_GUI_TEXTURE, this.m_252754_(), this.m_252907_(), (float)j, (float)(this.f_93622_ ? 13 : 0), this.f_93618_, this.f_93619_, 256, 256);
                if (this.f_93622_) {
                    this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)action.getTranslationKey())));
                }
            }
        }

        private static interface MovableWidget {
            public void setOffset(int var1, int var2);
        }

        private abstract class ItemWidget
        extends AbstractWidget
        implements MovableWidget {
            protected static final ItemStack PAPER = new ItemStack((ItemLike)Items.f_42516_);
            private final ItemStack stack;
            private int xOffset;
            private int yOffset;

            public ItemWidget(int pX, int pY, ItemStack stack) {
                super(pX, pY, 16, 16, (Component)Component.m_237119_());
                this.stack = stack;
            }

            @Override
            public void setOffset(int x, int y) {
                this.xOffset = x;
                this.yOffset = y;
            }

            public int m_252754_() {
                return super.m_252754_() + this.xOffset;
            }

            public int m_252907_() {
                return super.m_252907_() + this.yOffset;
            }

            public void m_87963_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
                graphics.m_280203_(this.stack, this.m_252754_(), this.m_252907_());
                if (this.f_93622_) {
                    this.m_257544_(new MultilineTooltip(this.createTooltip()));
                }
            }

            public void m_252865_(int p_254495_) {
                super.m_252865_(p_254495_);
            }

            protected void m_168797_(@NotNull NarrationElementOutput output) {
            }

            protected abstract List<Component> createTooltip();

            protected List<Component> renderItemTooltip(@NotNull ItemStack stack, Component text, boolean strikeThrough, @Nullable String bonus) {
                List<Component> tooltips = this.getTooltipFromItem2(stack, strikeThrough, bonus);
                tooltips.add(0, text);
                return tooltips;
            }

            @NotNull
            protected List<Component> getTooltipFromItem2(@NotNull ItemStack itemStack, boolean strikeThough, @Nullable String bonus) {
                List list = itemStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
                ArrayList list1 = Lists.newArrayList();
                for (int i = 0; i < list.size(); ++i) {
                    if (i == 0) {
                        MutableComponent t = ((Component)list.get(0)).m_6881_().m_130946_(" " + (bonus != null ? bonus : "") + itemStack.m_41613_());
                        if (strikeThough) {
                            t.m_130940_(ChatFormatting.STRIKETHROUGH);
                        }
                        list1.add(t);
                        continue;
                    }
                    list1.add(strikeThough ? ((Component)list.get(i)).m_6881_().m_130940_(ChatFormatting.STRIKETHROUGH) : (Component)list.get(i));
                }
                return list1;
            }
        }
    }
}

