/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public abstract class DualBipedRenderer<T extends Mob, M extends HumanoidModel<T>>
extends HumanoidMobRenderer<T, M> {
    @NotNull
    private final M modelA;
    private final M modelB;
    private ResourceLocation currentTexture;

    public DualBipedRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context, @NotNull M modelBipedInA, M modelBipedInB, float shadowSize) {
        super(context, modelBipedInA, shadowSize);
        this.modelA = modelBipedInA;
        this.modelB = modelBipedInB;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return this.currentTexture != null ? this.currentTexture : DefaultPlayerSkin.m_118626_();
    }

    public final void m_7392_(@NotNull T entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        Pair<ResourceLocation, Boolean> b = this.determineTextureAndModel(entityIn);
        this.currentTexture = (ResourceLocation)b.getLeft();
        this.f_115290_ = (Boolean)b.getRight() != false ? this.modelB : this.modelA;
        this.renderSelected(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected abstract Pair<ResourceLocation, Boolean> determineTextureAndModel(T var1);

    protected void renderSelected(@NotNull T entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected Pair<ResourceLocation, Boolean> @NotNull [] separateSlimTextures(@NotNull Stream<ResourceLocation> set) {
        return (Pair[])set.map(r -> {
            boolean b = r.m_135815_().endsWith("slim.png");
            return Pair.of((Object)r, (Object)b);
        }).toArray(Pair[]::new);
    }

    protected Pair<ResourceLocation, Boolean> @NotNull [] gatherTextures(@NotNull String dirPath, boolean required) {
        ArrayList hunterTextures = new ArrayList(Minecraft.m_91087_().m_91098_().m_214159_(dirPath, s -> s.m_135815_().endsWith(".png")).keySet());
        Pair<ResourceLocation, Boolean>[] textures = this.separateSlimTextures(hunterTextures.stream().filter(r -> "vampirism".equals(r.m_135827_())));
        if (textures.length == 0 && required) {
            throw new IllegalStateException("Must have at least one hunter texture: vampirism:" + dirPath + "/texture.png");
        }
        return textures;
    }
}

