/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.entity.converted.DefaultConvertingHandler;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertedSheepEntity
extends ConvertedCreatureEntity<Sheep>
implements IForgeShearable {
    private static final EntityDataAccessor<Byte> COAT = SynchedEntityData.m_135353_(ConvertedSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Nullable
    private Boolean lastSheared = null;

    public ConvertedSheepEntity(EntityType<? extends ConvertedSheepEntity> type, Level world) {
        super((EntityType<? extends ConvertedCreatureEntity>)type, world);
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        boolean t = this.getSheared();
        if (!(this.nil() || this.lastSheared != null && this.lastSheared == t)) {
            this.lastSheared = t;
            ((Sheep)this.getOldCreature()).m_29878_(this.lastSheared.booleanValue());
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Sheared", this.getSheared());
    }

    @NotNull
    public DyeColor getFleeceColor() {
        return this.nil() ? DyeColor.WHITE : ((Sheep)this.getOldCreature()).m_29874_();
    }

    public boolean getSheared() {
        return ((Byte)this.f_19804_.m_135370_(COAT) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.f_19804_.m_135370_(COAT);
        if (sheared) {
            this.f_19804_.m_135381_(COAT, (Object)((byte)(b0 | 0x10)));
        } else {
            this.f_19804_.m_135381_(COAT, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public boolean isShearable(@NotNull ItemStack item, Level world, BlockPos pos) {
        return !this.getSheared() && !this.m_6162_();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, @NotNull Level world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!world.m_5776_()) {
            this.setSheared(true);
            int i = 1 + this.f_19796_.m_188503_(3);
            for (int j = 0; j < i; ++j) {
                ret.add(new ItemStack((ItemLike)Sheep.f_29800_.get(this.getFleeceColor())));
            }
            this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
        }
        return ret;
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSheared(nbt.m_128471_("Sheared"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COAT, (Object)0);
    }

    public static class ConvertingHandler
    extends DefaultConvertingHandler<Sheep> {
        public ConvertingHandler() {
            super(null);
        }

        @Override
        public ConvertedCreatureEntity<Sheep> createFrom(@NotNull Sheep entity) {
            return Helper.createEntity((EntityType)ModEntities.CONVERTED_SHEEP.get(), entity.m_20193_()).map(creature -> {
                this.copyImportantStuff(creature, entity);
                creature.setSheared(entity.m_29875_());
                return creature;
            }).orElse(null);
        }
    }
}

