/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionBuilder;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.factions.IFactionVillageBuilder;
import de.teamlapen.vampirism.api.entity.factions.ILordPlayerBuilder;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFactionBuilder;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.vampirism.entity.factions.Faction;
import de.teamlapen.vampirism.entity.factions.FactionPredicate;
import de.teamlapen.vampirism.entity.factions.FactionVillageBuilder;
import de.teamlapen.vampirism.entity.factions.PlayableFaction;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.NonNullSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactionRegistry
implements IFactionRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Integer, Predicate<LivingEntity>> predicateMap = new HashMap<Integer, Predicate<LivingEntity>>();
    @Nullable
    private List<Faction<?>> temp = new CopyOnWriteArrayList();
    private Faction<?>[] allFactions;
    private PlayableFaction<?>[] playableFactions;

    public void finish() {
        this.allFactions = this.temp.toArray(new Faction[0]);
        this.temp = null;
        ArrayList<PlayableFaction> temp2 = new ArrayList<PlayableFaction>();
        for (Faction<?> allFaction : this.allFactions) {
            if (!(allFaction instanceof PlayableFaction)) continue;
            temp2.add((PlayableFaction)allFaction);
        }
        this.playableFactions = temp2.toArray(new PlayableFaction[0]);
    }

    @Override
    @Nullable
    public IFaction<?> getFaction(Entity entity) {
        if (entity instanceof IFactionEntity) {
            return ((IFactionEntity)entity).getFaction();
        }
        if (entity instanceof Player) {
            return VampirismPlayerAttributes.get((Player)((Player)entity)).faction;
        }
        return null;
    }

    @Override
    @Nullable
    public IFaction<?> getFactionByID(ResourceLocation id) {
        if (this.allFactions == null) {
            return null;
        }
        for (Faction<?> f : this.allFactions) {
            if (!f.getID().equals((Object)id)) continue;
            return f;
        }
        return null;
    }

    public Faction<?>[] getFactions() {
        return this.allFactions;
    }

    public PlayableFaction<?>[] getPlayableFactions() {
        return this.playableFactions;
    }

    @Override
    public Predicate<LivingEntity> getPredicate(@NotNull IFaction<?> thisFaction, boolean ignoreDisguise) {
        return this.getPredicate(thisFaction, true, true, true, ignoreDisguise, null);
    }

    @Override
    public Predicate<LivingEntity> getPredicate(@NotNull IFaction<?> thisFaction, boolean player, boolean mob, boolean neutralPlayer, boolean ignoreDisguise, @Nullable IFaction<?> otherFaction) {
        Object predicate;
        int id;
        int key = 0;
        if (otherFaction != null) {
            id = otherFaction.hashCode();
            if (id > 63) {
                LOGGER.warn("Faction id over 64, predicates won't work");
            }
            key |= (id & 0x3F) << 10;
        }
        if (player) {
            key |= 0x200;
        }
        if (mob) {
            key |= 0x100;
        }
        if (neutralPlayer) {
            key |= 0x80;
        }
        if (ignoreDisguise) {
            key |= 0x40;
        }
        if ((id = thisFaction.hashCode()) > 64) {
            LOGGER.warn("Faction id over 64, predicates won't work");
        }
        if (this.predicateMap.containsKey(key |= id & 0x3F)) {
            predicate = this.predicateMap.get(key);
        } else {
            predicate = new FactionPredicate(thisFaction, player, mob, neutralPlayer, ignoreDisguise, otherFaction);
            this.predicateMap.put(key, (Predicate<LivingEntity>)predicate);
        }
        return predicate;
    }

    private void addFaction(@NotNull Faction<?> faction) {
        if (this.temp == null) {
            throw new IllegalStateException(String.format("[Vampirism]You have to register factions during InterModEnqueueEvent. (%s)", faction.getID()));
        }
        this.temp.add(faction);
    }

    @Override
    @NotNull
    public <T extends IFactionEntity> IFactionBuilder<T> createFaction(ResourceLocation id, Class<T> entityInterface) {
        if (!UtilLib.isNonNull(id, entityInterface)) {
            throw new IllegalArgumentException("[Vampirism] Parameter for faction cannot be null");
        }
        return new FactionBuilder<T>(id, entityInterface);
    }

    @Override
    @NotNull
    public <T extends IFactionPlayer<T>> IPlayableFactionBuilder<T> createPlayableFaction(ResourceLocation id, Class<T> entityInterface, NonNullSupplier<Capability<T>> playerCapabilitySupplier) {
        if (!UtilLib.isNonNull(id, entityInterface, playerCapabilitySupplier)) {
            throw new IllegalArgumentException("[Vampirism] Parameters for faction cannot be null");
        }
        return new PlayableFactionBuilder<T>(id, entityInterface, playerCapabilitySupplier);
    }

    public class FactionBuilder<T extends IFactionEntity>
    implements IFactionBuilder<T> {
        protected final ResourceLocation id;
        protected final Class<T> entityInterface;
        protected int color = Color.WHITE.getRGB();
        protected boolean hostileTowardsNeutral;
        protected final FactionVillageBuilder villageFactionData = new FactionVillageBuilder();
        @Nullable
        protected TextColor chatColor;
        protected String name;
        protected String namePlural;

        FactionBuilder(ResourceLocation id, Class<T> entityInterface) {
            this.id = id;
            this.entityInterface = entityInterface;
        }

        @Override
        public IFactionBuilder<T> color(int color) {
            this.color = color;
            return this;
        }

        @Override
        public IFactionBuilder<T> chatColor(TextColor color) {
            this.chatColor = color;
            return this;
        }

        @Override
        public IFactionBuilder<T> chatColor(@NotNull ChatFormatting color) {
            if (!color.m_126664_()) {
                throw new IllegalArgumentException("Parameter must be a color");
            }
            this.chatColor = TextColor.m_131270_((ChatFormatting)color);
            return this;
        }

        @Override
        public IFactionBuilder<T> hostileTowardsNeutral() {
            this.hostileTowardsNeutral = true;
            return this;
        }

        @Override
        public IFactionBuilder<T> village(@NotNull Consumer<IFactionVillageBuilder> villageBuilder) {
            villageBuilder.accept(this.villageFactionData);
            return this;
        }

        @Override
        public IFactionBuilder<T> name(@NotNull String nameKey) {
            this.name = nameKey;
            return this;
        }

        @Override
        public IFactionBuilder<T> namePlural(@NotNull String namePluralKey) {
            this.namePlural = namePluralKey;
            return this;
        }

        @Override
        @NotNull
        public IFaction<T> register() {
            Faction faction = new Faction(this);
            FactionRegistry.this.addFaction(faction);
            return faction;
        }
    }

    public class PlayableFactionBuilder<T extends IFactionPlayer<T>>
    extends FactionBuilder<T>
    implements IPlayableFactionBuilder<T> {
        protected final NonNullSupplier<Capability<T>> playerCapabilitySupplier;
        protected int highestLevel;
        protected int highestLordLevel;
        protected BiFunction<Integer, Boolean, Component> lordTitleFunction;
        protected Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot;
        protected boolean hasLordSkills;

        public PlayableFactionBuilder(ResourceLocation id, Class<T> entityInterface, NonNullSupplier<Capability<T>> playerCapabilitySupplier) {
            super(id, entityInterface);
            this.highestLevel = 1;
            this.highestLordLevel = 0;
            this.hasLordSkills = false;
            this.playerCapabilitySupplier = playerCapabilitySupplier;
        }

        @Override
        public IPlayableFactionBuilder<T> color(int color) {
            return (IPlayableFactionBuilder)super.color(color);
        }

        @Override
        public IPlayableFactionBuilder<T> hostileTowardsNeutral() {
            return (IPlayableFactionBuilder)super.hostileTowardsNeutral();
        }

        @Override
        @NotNull
        public IPlayableFactionBuilder<T> highestLevel(int highestLevel) {
            this.highestLevel = highestLevel;
            return this;
        }

        @NotNull
        public PlayableFactionBuilder<T> lordLevel(int highestLordLevel) {
            this.highestLordLevel = highestLordLevel;
            return this;
        }

        @NotNull
        public PlayableFactionBuilder<T> lordTitle(@NotNull BiFunction<Integer, Boolean, Component> lordTitleFunction) {
            this.lordTitleFunction = lordTitleFunction;
            return this;
        }

        @NotNull
        public PlayableFactionBuilder<T> enableLordSkills(boolean enabled) {
            this.hasLordSkills = enabled;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> village(@NotNull Consumer<IFactionVillageBuilder> villageBuilder) {
            return (IPlayableFactionBuilder)super.village(villageBuilder);
        }

        @Override
        @NotNull
        public IPlayableFactionBuilder<T> refinementItems(@NotNull Function<IRefinementItem.AccessorySlotType, IRefinementItem> refinementItemBySlot) {
            this.refinementItemBySlot = refinementItemBySlot;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> chatColor(@NotNull TextColor color) {
            return (IPlayableFactionBuilder)super.chatColor(color);
        }

        @Override
        public IPlayableFactionBuilder<T> chatColor(@NotNull ChatFormatting color) {
            return (IPlayableFactionBuilder)super.chatColor(color);
        }

        @Override
        public IPlayableFactionBuilder<T> name(@NotNull String nameKey) {
            return (IPlayableFactionBuilder)super.name(nameKey);
        }

        @Override
        public IPlayableFactionBuilder<T> namePlural(@NotNull String namePluralKey) {
            return (IPlayableFactionBuilder)super.namePlural(namePluralKey);
        }

        @Override
        @NotNull
        public ILordPlayerBuilder<T> lord() {
            return new LordPlayerBuilder(this);
        }

        @Override
        @NotNull
        public IPlayableFaction<T> register() {
            PlayableFaction faction = new PlayableFaction(this);
            FactionRegistry.this.addFaction(faction);
            return faction;
        }
    }

    public static class LordPlayerBuilder<T extends IFactionPlayer<T>>
    implements ILordPlayerBuilder<T> {
        protected final PlayableFactionBuilder<T> factionBuilder;
        protected int maxLevel = 0;
        protected BiFunction<Integer, Boolean, Component> lordTitleFunction;
        protected boolean lordSkillsEnabled;

        public LordPlayerBuilder(PlayableFactionBuilder<T> factionBuilder) {
            this.factionBuilder = factionBuilder;
        }

        @Override
        @NotNull
        public LordPlayerBuilder<T> lordLevel(int level) {
            this.maxLevel = level;
            return this;
        }

        @Override
        @NotNull
        public LordPlayerBuilder<T> lordTitle(@NotNull BiFunction<Integer, Boolean, Component> lordTitleFunction) {
            this.lordTitleFunction = lordTitleFunction;
            return this;
        }

        @Override
        @NotNull
        public ILordPlayerBuilder<T> enableLordSkills() {
            this.lordSkillsEnabled = true;
            return this;
        }

        @Override
        public IPlayableFactionBuilder<T> build() {
            if (this.lordTitleFunction == null) {
                this.lordTitleFunction = (a, b) -> Component.m_237113_((String)("Lord " + a));
            }
            return this.factionBuilder.lordTitle(this.lordTitleFunction).lordLevel(this.maxLevel).enableLordSkills(this.lordSkillsEnabled);
        }
    }
}

