/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion.management;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.entity.minion.IMinionData;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionInventory;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MinionData
implements INBTSerializable<CompoundTag>,
IMinionData {
    public static final int MAX_NAME_LENGTH = 15;
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, Supplier<? extends MinionData>> constructors = new HashMap<ResourceLocation, Supplier<? extends MinionData>>();
    @NotNull
    private final MinionInventory inventory;
    private float health;
    private String name;
    @NotNull
    private CompoundTag entityCaps = new CompoundTag();
    @NotNull
    private IMinionTask.IMinionTaskDesc<MinionData> activeTaskDesc;
    private boolean taskLocked;

    public static void registerDataType(ResourceLocation id, Supplier<? extends MinionData> supplier) {
        constructors.put(id, supplier);
    }

    @NotNull
    public static MinionData fromNBT(@NotNull CompoundTag nbt) {
        ResourceLocation dataType = new ResourceLocation(nbt.m_128461_("data_type"));
        Supplier<? extends MinionData> c = constructors.get(dataType);
        if (c == null) {
            LOGGER.error("No data constructor available for {}", (Object)dataType);
            return new MinionData();
        }
        MinionData d = c.get();
        d.deserializeNBT(nbt);
        return d;
    }

    protected MinionData(String name, int invSize) {
        this.health = this.getMaxHealth();
        this.name = name;
        this.inventory = new MinionInventory(invSize);
        this.activeTaskDesc = new IMinionTask.NoDesc<MinionData>((IMinionTask)MinionTasks.NOTHING.get());
    }

    protected MinionData() {
        this.inventory = new MinionInventory();
        this.activeTaskDesc = new IMinionTask.NoDesc<MinionData>((IMinionTask)MinionTasks.NOTHING.get());
    }

    public void deserializeNBT(@NotNull CompoundTag nbt) {
        this.inventory.read(nbt.m_128437_("inv", 10));
        this.inventory.setAvailableSize(nbt.m_128451_("inv_size"));
        this.health = nbt.m_128457_("health");
        this.name = nbt.m_128461_("name");
        this.taskLocked = nbt.m_128471_("locked");
        if (nbt.m_128425_("task", 10)) {
            CompoundTag task = nbt.m_128469_("task");
            ResourceLocation id = new ResourceLocation(task.m_128461_("id"));
            IMinionTask<?, ?> activeTask = RegUtil.getMinionTask(id);
            if (activeTask != null) {
                this.activeTaskDesc = activeTask.readFromNBT(task);
            } else {
                LOGGER.error("Saved minion task does not exist anymore {}", (Object)id);
            }
        }
        this.entityCaps = nbt.m_128469_("caps");
    }

    @NotNull
    public IMinionTask.IMinionTaskDesc<MinionData> getCurrentTaskDesc() {
        return this.activeTaskDesc;
    }

    public int getDefaultInventorySize() {
        return 9;
    }

    public MutableComponent getFormattedName() {
        return Component.m_237113_((String)this.name);
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    @Override
    public MinionInventory getInventory() {
        return this.inventory;
    }

    public int getInventorySize() {
        return this.getDefaultInventorySize();
    }

    @Override
    public int getMaxHealth() {
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return 45;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void handleMinionAppearanceConfig(String name, int ... data) {
    }

    public boolean hasUsedSkillPoints() {
        return false;
    }

    public boolean isTaskLocked() {
        return this.taskLocked;
    }

    @NotNull
    public CompoundTag getEntityCaps() {
        return this.entityCaps;
    }

    public void updateEntityCaps(CompoundTag caps) {
        this.entityCaps = caps;
    }

    public void resetStats(@NotNull MinionEntity<?> entity) {
        entity.getInventory().ifPresent(inv -> {
            if (!InventoryHelper.removeItemFromInventory(inv, new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get()))) {
                entity.getLordOpt().ifPresent(lord -> InventoryHelper.removeItemFromInventory((Container)lord.getPlayer().m_150109_(), new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get())));
            }
        });
        HelperLib.sync(entity);
    }

    @NotNull
    public final CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.serializeNBT(tag);
        return tag;
    }

    public void serializeNBT(@NotNull CompoundTag tag) {
        tag.m_128405_("inv_size", this.inventory.getAvailableSize());
        tag.m_128365_("inv", (Tag)this.inventory.write(new ListTag()));
        tag.m_128350_("health", this.health);
        tag.m_128359_("name", this.name);
        tag.m_128359_("data_type", this.getDataType().toString());
        tag.m_128379_("locked", this.taskLocked);
        if (this.activeTaskDesc != null) {
            CompoundTag task = new CompoundTag();
            task.m_128359_("id", RegUtil.id(this.activeTaskDesc.getTask()).toString());
            this.activeTaskDesc.writeToNBT(task);
            tag.m_128365_("task", (Tag)task);
        }
        tag.m_128365_("caps", (Tag)this.entityCaps);
    }

    public boolean setTaskLocked(boolean locked) {
        this.taskLocked = locked;
        return this.taskLocked;
    }

    public void shrinkInventory(@NotNull MinionEntity<?> entity) {
        Optional<MinionInventory> invOpt = entity.getMinionData().map(MinionData::getInventory);
        if (invOpt.isPresent()) {
            MinionInventory inv = invOpt.get();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 6 + this.getDefaultInventorySize(); i < inv.m_6643_(); ++i) {
                ItemStack stack = inv.m_8016_(i);
                if (stack.m_41619_()) continue;
                stacks.add(stack);
            }
            inv.setAvailableSize(this.getInventorySize());
            for (ItemStack stack : stacks) {
                if (stack.m_41619_()) continue;
                inv.addItemStack(stack);
                if (stack.m_41619_()) continue;
                entity.getLordOpt().ifPresent(lord -> {
                    if (!lord.getPlayer().m_36356_(stack)) {
                        entity.m_19983_(stack);
                    }
                });
            }
        }
    }

    public <Q extends IMinionTask.IMinionTaskDesc<MinionData>, T extends IMinionTask<Q, ?>> void switchTask(@NotNull T oldTask, IMinionTask.IMinionTaskDesc<MinionData> oldDesc, @NotNull IMinionTask.IMinionTaskDesc<MinionData> newDesc) {
        oldTask.deactivateTask(oldDesc);
        this.activeTaskDesc = newDesc;
    }

    public boolean upgradeStat(int statId, @NotNull MinionEntity<?> entity) {
        if (statId == -1) {
            this.resetStats(entity);
            return true;
        }
        return false;
    }

    protected ResourceLocation getDataType() {
        return new ResourceLocation("");
    }
}

