/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrucifixItem
extends Item
implements IItemWithTier,
IFactionExclusiveItem,
IFactionLevelItem<IHunterPlayer> {
    private static final String baseRegName = "crucifix";
    private final IItemWithTier.TIER tier;
    private static final Set<CrucifixItem> all_crucifix = Collections.synchronizedSet(new HashSet());

    public CrucifixItem(IItemWithTier.TIER tier) {
        super(new Item.Properties().m_41487_(1));
        this.tier = tier;
        all_crucifix.add(this);
    }

    @Override
    public int getMinLevel(@NotNull ItemStack stack) {
        return 1;
    }

    @Override
    @Nullable
    public ISkill<IHunterPlayer> getRequiredSkill(@NotNull ItemStack stack) {
        if (this.tier == IItemWithTier.TIER.ULTIMATE) {
            return (ISkill)HunterSkills.ULTIMATE_CRUCIFIX.get();
        }
        return (ISkill)HunterSkills.CRUCIFIX_WIELDER.get();
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    @Override
    public IItemWithTier.TIER getVampirismTier() {
        return this.tier;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack p_77661_1_) {
        return UseAnim.NONE;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, @NotNull Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addTierInformation(tooltip);
        this.addFactionToolTips(stack, worldIn, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean held) {
        if (held && entity instanceof LivingEntity && entity.f_19797_ % 16 == 8 && Helper.isVampire(entity)) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)ModEffects.POISON.get(), 20, 1));
        }
    }

    protected boolean affectsEntity(@NotNull LivingEntity e) {
        return e.m_6336_() == MobType.f_21641_ || Helper.isVampire((Entity)e);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int p_77615_4_) {
        if (entity instanceof Player) {
            all_crucifix.forEach(item -> ((Player)entity).m_36335_().m_41524_((Item)item, this.getCooldown(stack)));
        }
    }

    protected int getCooldown(ItemStack stack) {
        return switch (this.tier) {
            case IItemWithTier.TIER.ENHANCED -> 100;
            case IItemWithTier.TIER.ULTIMATE -> 60;
            default -> 140;
        };
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return 72000;
    }

    protected static int determineEntityTier(LivingEntity e) {
        if (e instanceof Player) {
            int level = VampirismPlayerAttributes.get((Player)((Player)e)).vampireLevel;
            int tier = 1;
            if (level == VReference.VAMPIRE_FACTION.getHighestReachableLevel()) {
                tier = 3;
            } else if (level >= 8) {
                tier = 2;
            }
            if (VampirePlayer.getOpt((Player)e).map(VampirePlayer::getSkillHandler).map(h -> h.isRefinementEquipped((IRefinement)ModRefinements.CRUCIFIX_RESISTANT.get())).orElse(false).booleanValue()) {
                ++tier;
            }
            return tier;
        }
        if (e instanceof VampireBaronEntity) {
            return 3;
        }
        if (e instanceof AdvancedVampireEntity) {
            return 2;
        }
        return 1;
    }

    protected double determineSlowdown(int entityTier) {
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case IItemWithTier.TIER.NORMAL -> {
                if (entityTier > 1) {
                    yield 0.1;
                }
                yield 0.5;
            }
            case IItemWithTier.TIER.ENHANCED -> {
                if (entityTier > 2) {
                    yield 0.1;
                }
                yield 0.5;
            }
            case IItemWithTier.TIER.ULTIMATE -> entityTier > 3 ? 0.3 : 0.5;
        };
    }

    protected int getRange(ItemStack stack) {
        return switch (this.tier) {
            case IItemWithTier.TIER.ENHANCED -> 8;
            case IItemWithTier.TIER.ULTIMATE -> 10;
            default -> 4;
        };
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity entity, @NotNull ItemStack stack, int count) {
        for (LivingEntity nearbyEntity : entity.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_().m_26888_(this::affectsEntity), entity, entity.m_20191_().m_82400_((double)this.getRange(stack)))) {
            double scale;
            Vec3 oldDelta;
            Vec3 horizontalDelta;
            Vec3 baseVector = entity.m_20182_().m_82546_(nearbyEntity.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
            double parallelScale = baseVector.m_82526_(horizontalDelta = (oldDelta = nearbyEntity.m_20184_()).m_82542_(1.0, 0.0, 1.0));
            if (!(parallelScale > 0.0)) continue;
            Vec3 parallelPart = baseVector.m_82490_(parallelScale);
            Vec3 newDelta = oldDelta.m_82546_(parallelPart.m_82490_(scale = this.determineSlowdown(CrucifixItem.determineEntityTier(nearbyEntity))));
            if (newDelta.m_82556_() > oldDelta.m_82556_()) {
                newDelta = Vec3.f_82478_;
            }
            Vec3 collisionDelta = nearbyEntity.m_20272_(newDelta);
            if (collisionDelta.f_82480_ != newDelta.f_82480_ && newDelta.f_82480_ < 0.0) {
                newDelta = newDelta.m_82542_(1.0, 0.0, 1.0);
            }
            nearbyEntity.m_20256_(newDelta);
        }
    }
}

