/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.inventory.HunterBasicMenu;
import de.teamlapen.vampirism.inventory.HunterTrainerMenu;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.network.ClientboundRequestMinionSelectPacket;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public record ServerboundSimpleInputEvent(Type type) implements IMessage.IServerBoundMessage
{
    static void encode(@NotNull ServerboundSimpleInputEvent msg, @NotNull FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.type);
    }

    @NotNull
    static ServerboundSimpleInputEvent decode(@NotNull FriendlyByteBuf buf) {
        Type t = (Type)buf.m_130066_(Type.class);
        return new ServerboundSimpleInputEvent(t);
    }

    static void handle(@NotNull ServerboundSimpleInputEvent msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            Optional factionPlayerOpt = FactionPlayerHandler.getOpt((Player)player).map(FactionPlayerHandler::getCurrentFactionPlayer).orElseGet(Optional::empty);
            switch (msg.type) {
                case FINISH_SUCK_BLOOD: {
                    VampirePlayer.getOpt((Player)player).ifPresent(vampire -> vampire.endFeeding(true));
                    break;
                }
                case RESET_SKILLS: {
                    InventoryHelper.removeItemFromInventory((Container)player.m_150109_(), new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get()));
                    factionPlayerOpt.ifPresent(OblivionItem::applyEffect);
                    break;
                }
                case REVERT_BACK: {
                    FactionPlayerHandler.getOpt((Player)player).ifPresent(handler -> handler.leaveFaction(!player.f_8924_.m_7035_()));
                    break;
                }
                case TOGGLE_VAMPIRE_VISION: {
                    VampirePlayer.getOpt((Player)player).ifPresent(VampirePlayer::switchVision);
                    break;
                }
                case TRAINER_LEVELUP: {
                    if (!(player.f_36096_ instanceof HunterTrainerMenu)) break;
                    ((HunterTrainerMenu)player.f_36096_).onLevelupClicked();
                    break;
                }
                case BASIC_HUNTER_LEVELUP: {
                    if (!(player.f_36096_ instanceof HunterBasicMenu)) break;
                    ((HunterBasicMenu)player.f_36096_).onLevelUpClicked();
                    break;
                }
                case SHOW_MINION_CALL_SELECTION: {
                    ClientboundRequestMinionSelectPacket.createRequestForPlayer(player, ClientboundRequestMinionSelectPacket.Action.CALL).ifPresent(a -> VampirismMod.dispatcher.sendTo((IMessage.IClientBoundMessage)a, player));
                    break;
                }
                case VAMPIRISM_MENU: {
                    factionPlayerOpt.ifPresent(fPlayer -> fPlayer.getTaskManager().openVampirismMenu());
                    break;
                }
                case RESURRECT: {
                    VampirePlayer.getOpt((Player)player).ifPresent(VampirePlayer::tryResurrect);
                    break;
                }
                case GIVE_UP: {
                    VampirePlayer.getOpt((Player)player).ifPresent(VampirePlayer::giveUpDBNO);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static enum Type {
        FINISH_SUCK_BLOOD,
        RESET_SKILLS,
        REVERT_BACK,
        TOGGLE_VAMPIRE_VISION,
        TRAINER_LEVELUP,
        BASIC_HUNTER_LEVELUP,
        SHOW_MINION_CALL_SELECTION,
        VAMPIRISM_MENU,
        RESURRECT,
        GIVE_UP;

    }
}

