/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen.structure.huntercamp;

import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blockentity.TentBlockEntity;
import de.teamlapen.vampirism.blocks.FirePlaceBlock;
import de.teamlapen.vampirism.blocks.TentBlock;
import de.teamlapen.vampirism.blocks.TentMainBlock;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.world.gen.VampirismFeatures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class HunterCampPieces
extends StructurePiece {
    protected final int x;
    protected final int z;
    protected int y;

    public static <C extends FeatureConfiguration> void addStartPieces(@NotNull StructurePiecesBuilder structurePiecesBuilder, @NotNull Structure.GenerationContext cContext) {
        WorldgenRandom rand = cContext.f_226626_();
        Fireplace hunterCamp = new Fireplace((RandomSource)rand, cContext.f_226628_().f_45578_ * 16 + rand.m_188503_(16), 63, cContext.f_226628_().f_45579_ * 16 + rand.m_188503_(16));
        structurePiecesBuilder.m_142679_((StructurePiece)hunterCamp);
        hunterCamp.m_214092_(hunterCamp, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)rand);
    }

    public HunterCampPieces(@NotNull StructurePieceType structurePieceType, int part, int x, int y, int z) {
        super(structurePieceType, part, new BoundingBox(x - 1, y, z - 1, x + 1, y + 2, z + 1));
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public HunterCampPieces(@NotNull StructurePieceType structurePieceType, @NotNull CompoundTag nbt) {
        super(structurePieceType, nbt);
        this.x = nbt.m_128451_("x");
        this.y = nbt.m_128451_("y");
        this.z = nbt.m_128451_("z");
    }

    public void m_213694_(@NotNull WorldGenLevel worldIn, @NotNull StructureManager structureManager, @NotNull ChunkGenerator chunkGenerator, @NotNull RandomSource random, @NotNull BoundingBox structureBoundingBoxIn, @NotNull ChunkPos chunkPos, @NotNull BlockPos blockPos) {
        this.y = worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.x, this.z);
        this.f_73383_ = new BoundingBox(this.x - 1, this.y, this.z - 1, this.x + 1, this.y + 2, this.z + 1);
    }

    protected void m_183620_(@NotNull StructurePieceSerializationContext context, @NotNull CompoundTag tagCompound) {
        tagCompound.m_128405_("x", this.x);
        tagCompound.m_128405_("y", this.y);
        tagCompound.m_128405_("z", this.z);
    }

    protected boolean testPreconditions(@NotNull WorldGenLevel worldIn, @NotNull StructureManager manager, @NotNull ChunkPos chunkPos) {
        if (!((Boolean)VampirismConfig.COMMON.enableHunterTentGeneration.get()).booleanValue()) {
            return false;
        }
        return this.y >= 63 && !worldIn.m_8055_(new BlockPos(this.x, this.y - 1, this.z)).m_278721_() && UtilLib.getStructureStartAt((Level)worldIn.m_6018_(), new BlockPos(this.x, this.y, this.z), (TagKey<Structure>)StructureTags.f_215889_).isEmpty();
    }

    public static class Fireplace
    extends HunterCampPieces {
        boolean specialComponentAdd = false;
        private boolean advanced;

        public Fireplace(@NotNull RandomSource random, int x, int y, int z) {
            super((StructurePieceType)VampirismFeatures.HUNTER_CAMP_FIREPLACE.get(), 0, x, y, z);
            this.m_73519_(Direction.Plane.HORIZONTAL.m_235690_(random));
        }

        public Fireplace(@NotNull CompoundTag nbt) {
            super((StructurePieceType)VampirismFeatures.HUNTER_CAMP_FIREPLACE.get(), nbt);
            this.advanced = nbt.m_128471_("advanced");
            this.specialComponentAdd = nbt.m_128471_("specialComponentAdd");
        }

        public void m_214092_(@NotNull StructurePiece componentInt, @NotNull StructurePieceAccessor listIn, @NotNull RandomSource rand) {
            @NotNull ArrayList directions = Lists.newArrayList((Object[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
            if (rand.m_188503_(3) == 0) {
                this.advanced = true;
                listIn.m_142679_(this.getTentComponent(rand, directions, true));
                listIn.m_142679_(this.getTentComponent(rand, directions, false));
                int i = rand.m_188503_(4);
                if (i < 2) {
                    listIn.m_142679_(this.getComponent(rand, directions, true));
                }
                if (i < 1) {
                    listIn.m_142679_(this.getComponent(rand, directions, true));
                }
            } else {
                listIn.m_142679_(this.getTentComponent(rand, directions, false));
                if (rand.m_188503_(2) == 0) {
                    listIn.m_142679_(this.getComponent(rand, directions, false));
                }
            }
        }

        @Override
        public void m_213694_(@NotNull WorldGenLevel worldIn, @NotNull StructureManager structureManager, @NotNull ChunkGenerator chunkGenerator, @NotNull RandomSource random, @NotNull BoundingBox structureBoundingBoxIn, @NotNull ChunkPos chunkPos, @NotNull BlockPos blockPos) {
            super.m_213694_(worldIn, structureManager, chunkGenerator, random, structureBoundingBoxIn, chunkPos, blockPos);
            if (!this.testPreconditions(worldIn, structureManager, chunkPos)) {
                return;
            }
            this.m_73434_(worldIn, (Boolean)VampirismConfig.COMMON.useVanillaCampfire.get() != false ? Blocks.f_50683_.m_49966_() : ((FirePlaceBlock)((Object)ModBlocks.FIRE_PLACE.get())).m_49966_(), 1, 0, 1, structureBoundingBoxIn);
            this.m_73434_(worldIn, Blocks.f_50016_.m_49966_(), 1, 1, 1, structureBoundingBoxIn);
        }

        @Override
        protected void m_183620_(@NotNull StructurePieceSerializationContext context, @NotNull CompoundTag tagCompound) {
            super.m_183620_(context, tagCompound);
            tagCompound.m_128379_("advanced", this.advanced);
            tagCompound.m_128379_("specialComponentAdd", this.specialComponentAdd);
        }

        @NotNull
        private StructurePiece getComponent(@NotNull RandomSource rand, @NotNull List<Direction> directions, boolean advanced) {
            @NotNull Direction direction = directions.remove(rand.m_188503_(directions.size()));
            int x = this.x + (direction.m_122434_().equals((Object)Direction.Axis.X) ? (direction.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : 0);
            int z = this.z + (direction.m_122434_().equals((Object)Direction.Axis.Z) ? (direction.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : 0);
            if (!this.specialComponentAdd && rand.m_188503_(2) == 0) {
                this.specialComponentAdd = true;
                return new SpecialBlock(x, this.y, z, direction, advanced);
            }
            return new Tent(x, this.y, z, direction, advanced);
        }

        @NotNull
        private StructurePiece getTentComponent(@NotNull RandomSource rand, @NotNull List<Direction> directions, boolean advanced) {
            @NotNull Direction direction = directions.remove(rand.m_188503_(directions.size()));
            int x = this.x + (direction.m_122434_().equals((Object)Direction.Axis.X) ? (direction.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : 0);
            int z = this.z + (direction.m_122434_().equals((Object)Direction.Axis.Z) ? (direction.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE) ? 3 : -3) : 0);
            return new Tent(x, this.y, z, direction, advanced);
        }
    }

    public static class SpecialBlock
    extends HunterCampPieces {
        private final Direction direction;
        private final boolean advanced;

        public SpecialBlock(int x, int y, int z, Direction direction, boolean advanced) {
            super((StructurePieceType)VampirismFeatures.HUNTER_CAMP_SPECIAL.get(), 2, x, y, z);
            this.m_73519_(direction);
            this.direction = direction;
            this.advanced = advanced;
        }

        public SpecialBlock(@NotNull CompoundTag compoundNBT) {
            super((StructurePieceType)VampirismFeatures.HUNTER_CAMP_SPECIAL.get(), compoundNBT);
            this.direction = Direction.m_122407_((int)compoundNBT.m_128451_("dir"));
            this.advanced = compoundNBT.m_128471_("advanced");
        }

        @Override
        public void m_213694_(@NotNull WorldGenLevel worldIn, @NotNull StructureManager structureManager, @NotNull ChunkGenerator chunkGenerator, @NotNull RandomSource random, @NotNull BoundingBox structureBoundingBoxIn, @NotNull ChunkPos chunkPos, @NotNull BlockPos blockPos) {
            super.m_213694_(worldIn, structureManager, chunkGenerator, random, structureBoundingBoxIn, chunkPos, blockPos);
            if (!this.testPreconditions(worldIn, structureManager, chunkPos)) {
                return;
            }
            if (this.advanced) {
                if (!worldIn.m_8055_(new BlockPos(this.x + 1, worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.x + 1, this.z) - 1, this.z)).m_247087_()) {
                    this.m_73434_(worldIn, ((WeaponTableBlock)((Object)ModBlocks.WEAPON_TABLE.get())).m_49966_(), 2, worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.x + 1, this.z) - this.y, 1, structureBoundingBoxIn);
                }
                if (!worldIn.m_8055_(new BlockPos(this.x - 1, worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.x - 1, this.z) - 1, this.z)).m_247087_()) {
                    this.m_73434_(worldIn, Blocks.f_50091_.m_49966_(), 0, worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.x - 1, this.z) - this.y, 1, structureBoundingBoxIn);
                }
            } else {
                this.m_73434_(worldIn, Blocks.f_50091_.m_49966_(), 1, 0, 1, structureBoundingBoxIn);
            }
        }

        @Override
        protected void m_183620_(@NotNull StructurePieceSerializationContext context, @NotNull CompoundTag tagCompound) {
            super.m_183620_(context, tagCompound);
            tagCompound.m_128405_("dir", this.direction.m_122416_());
            tagCompound.m_128379_("advanced", this.advanced);
        }
    }

    public static class Tent
    extends HunterCampPieces {
        @NotNull
        private final Direction direction;
        private final boolean advanced;
        int xDiff;
        int xCenter;
        private int mirror;

        public Tent(int x, int y, int z, @NotNull Direction direction, boolean advanced) {
            super((StructurePieceType)VampirismFeatures.HUNTER_CAMP_TENT.get(), 1, x, y, z);
            this.m_73519_(direction);
            this.direction = direction;
            this.advanced = advanced;
        }

        public Tent(@NotNull CompoundTag nbt) {
            super((StructurePieceType)VampirismFeatures.HUNTER_CAMP_TENT.get(), nbt);
            this.direction = Direction.m_122407_((int)nbt.m_128451_("direction"));
            this.mirror = nbt.m_128451_("mirror");
            this.advanced = nbt.m_128471_("advanced");
        }

        @Override
        public void m_213694_(@NotNull WorldGenLevel worldIn, @NotNull StructureManager structureManager, @NotNull ChunkGenerator chunkGenerator, @NotNull RandomSource random, @NotNull BoundingBox structureBoundingBoxIn, @NotNull ChunkPos chunkPos, @NotNull BlockPos blockPos) {
            int d;
            int c;
            int b;
            int a;
            if (this.mirror == 0 ? (this.mirror = random.m_188503_(2) + 1) == 1 : this.mirror == 1) {
                this.xDiff = 2;
                this.xCenter = this.x + 1;
            } else {
                this.xDiff = 0;
                this.xCenter = this.x - 1;
            }
            super.m_213694_(worldIn, structureManager, chunkGenerator, random, structureBoundingBoxIn, chunkPos, blockPos);
            if (!this.testPreconditions(worldIn, structureManager, chunkPos)) {
                return;
            }
            Direction dir = this.direction == Direction.SOUTH || this.direction == Direction.WEST ? this.direction.m_122424_() : this.direction;
            int nul = this.direction.m_122416_() % 4;
            int one = (this.direction.m_122416_() + 1) % 4;
            int two = (this.direction.m_122416_() + 2) % 4;
            int three = (this.direction.m_122416_() + 3) % 4;
            boolean positiveAxisDirection = this.direction.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE);
            boolean xAxis = this.direction.m_122434_().equals((Object)Direction.Axis.X);
            int n = positiveAxisDirection ? one : (a = xAxis ? nul : two);
            int n2 = !positiveAxisDirection ? three : (b = xAxis ? two : nul);
            int n3 = positiveAxisDirection ? three : (c = xAxis ? two : nul);
            int n4 = !positiveAxisDirection ? one : (d = xAxis ? nul : two);
            if (this.mirror == 1) {
                this.m_73434_(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir.m_122424_())).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(a)), this.xDiff, 0, 0, structureBoundingBoxIn);
                this.m_73434_(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir)).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(b)), 1, 0, 0, structureBoundingBoxIn);
                this.m_73434_(worldIn, (BlockState)((BlockState)((TentMainBlock)((Object)ModBlocks.TENT_MAIN.get())).m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir)).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(c)), 1, 0, 1, structureBoundingBoxIn);
                this.m_73434_(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir.m_122424_())).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(d)), this.xDiff, 0, 1, structureBoundingBoxIn);
            } else {
                this.m_73434_(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir)).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(b)), this.xDiff, 0, 0, structureBoundingBoxIn);
                this.m_73434_(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir.m_122424_())).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(a)), 1, 0, 0, structureBoundingBoxIn);
                this.m_73434_(worldIn, (BlockState)((BlockState)((TentMainBlock)((Object)ModBlocks.TENT_MAIN.get())).m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir.m_122424_())).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(d)), 1, 0, 1, structureBoundingBoxIn);
                this.m_73434_(worldIn, (BlockState)((BlockState)((TentBlock)((Object)ModBlocks.TENT.get())).m_49966_().m_61124_((Property)TentBlock.FACING, (Comparable)dir)).m_61124_((Property)TentBlock.POSITION, (Comparable)Integer.valueOf(c)), this.xDiff, 0, 1, structureBoundingBoxIn);
            }
            BlockEntity tile = worldIn.m_7702_(new BlockPos(this.x, this.y, this.z));
            if (tile instanceof TentBlockEntity) {
                ((TentBlockEntity)tile).setSpawn(true);
                if (this.advanced) {
                    ((TentBlockEntity)tile).setAdvanced(true);
                }
            }
            BlockState air = Blocks.f_50016_.m_49966_();
            this.m_73434_(worldIn, air, 1, 0, -1, structureBoundingBoxIn);
            this.m_73434_(worldIn, air, this.xDiff, 0, -1, structureBoundingBoxIn);
            this.m_73434_(worldIn, air, 1, 1, -1, structureBoundingBoxIn);
            this.m_73434_(worldIn, air, this.xDiff, 1, -1, structureBoundingBoxIn);
            this.m_73434_(worldIn, air, this.xDiff, 1, 0, structureBoundingBoxIn);
            this.m_73434_(worldIn, air, 1, 1, 0, structureBoundingBoxIn);
            this.m_73434_(worldIn, air, 1, 1, 1, structureBoundingBoxIn);
            this.m_73434_(worldIn, air, this.xDiff, 1, 1, structureBoundingBoxIn);
            if (worldIn.m_8055_(new BlockPos(this.x, this.y - 1, this.z - 2)).m_204336_(BlockTags.f_144274_)) {
                this.m_73434_(worldIn, Blocks.f_50440_.m_49966_(), 1, -1, -1, structureBoundingBoxIn);
            }
            if (worldIn.m_8055_(new BlockPos(this.xCenter, this.y - 1, this.z - 2)).m_204336_(BlockTags.f_144274_)) {
                this.m_73434_(worldIn, Blocks.f_50440_.m_49966_(), this.xDiff, -1, -1, structureBoundingBoxIn);
            }
        }

        @Override
        protected void m_183620_(@NotNull StructurePieceSerializationContext context, @NotNull CompoundTag tagCompound) {
            tagCompound.m_128405_("direction", this.direction.m_122416_());
            tagCompound.m_128405_("mirror", this.mirror);
            tagCompound.m_128379_("advanced", this.advanced);
            super.m_183620_(context, tagCompound);
        }

        @Override
        protected boolean testPreconditions(@NotNull WorldGenLevel worldIn, @NotNull StructureManager manager, @NotNull ChunkPos chunkPos) {
            return super.testPreconditions(worldIn, manager, chunkPos) && !worldIn.m_8055_(new BlockPos(this.xCenter, this.y - 1, this.z - 1)).m_278721_() && !worldIn.m_8055_(new BlockPos(this.x, this.y - 1, this.z - 1)).m_278721_() && !worldIn.m_8055_(new BlockPos(this.xCenter, this.y - 1, this.z)).m_278721_();
        }
    }
}

