/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class UtilLib {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern oldFormatPattern = Pattern.compile("%[sd]");

    @NotNull
    public static String entityToString(@Nullable Entity e) {
        if (e == null) {
            return "Entity is null";
        }
        return e.toString();
    }

    public static boolean doesBlockHaveSolidTopSurface(@NotNull Level worldIn, @NotNull BlockPos pos) {
        return worldIn.m_8055_(pos).m_60783_((BlockGetter)worldIn, pos, Direction.UP);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public static void drawTexturedModalRect(@NotNull Matrix4f matrix, float zLevel, int x, int y, int textureX, int textureY, int width, int height, int texWidth, int texHeight) {
        float f = 1.0f / (float)texWidth;
        float f1 = 1.0f / (float)texHeight;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)textureX * f, (float)(textureY + height) * f1).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(textureX + width) * f, (float)(textureY + height) * f1).m_5752_();
        buffer.m_252986_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(textureX + width) * f, (float)textureY * f1).m_5752_();
        buffer.m_252986_(matrix, (float)x, (float)y, zLevel).m_7421_((float)textureX * f, (float)textureY * f1).m_5752_();
        tesselator.m_85914_();
    }

    @NotNull
    public static HitResult getPlayerLookingSpot(@NotNull Player player, double restriction) {
        float scale = 1.0f;
        float pitch = player.f_19860_ + (player.m_146909_() - player.f_19860_) * scale;
        float yaw = player.f_19859_ + (player.m_146908_() - player.f_19859_) * scale;
        double x = player.f_19854_ + (player.m_20185_() - player.f_19854_) * (double)scale;
        double y = player.f_19855_ + (player.m_20186_() - player.f_19855_) * (double)scale + 1.62;
        double z = player.f_19856_ + (player.m_20189_() - player.f_19856_) * (double)scale;
        Vec3 vector1 = new Vec3(x, y, z);
        float cosYaw = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float sinPitch = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        float pitchAdjustedSinYaw = sinYaw * cosPitch;
        float pitchAdjustedCosYaw = cosYaw * cosPitch;
        double distance = 500.0;
        if (restriction == 0.0 && player instanceof ServerPlayer) {
            distance = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() - 0.5;
        } else if (restriction > 0.0) {
            distance = restriction;
        }
        Vec3 vector2 = vector1.m_82520_((double)pitchAdjustedSinYaw * distance, (double)sinPitch * distance, (double)pitchAdjustedCosYaw * distance);
        return player.m_20193_().m_45547_(new ClipContext(vector1, vector2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
    }

    @NotNull
    public static BlockPos getRandomPosInBox(@NotNull Level w, @NotNull AABB box) {
        int x = (int)box.f_82288_ + w.f_46441_.m_188503_((int)(box.f_82291_ - box.f_82288_) + 1);
        int z = (int)box.f_82290_ + w.f_46441_.m_188503_((int)(box.f_82293_ - box.f_82290_) + 1);
        int y = w.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) + 5;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while ((double)y > box.f_82289_ && !w.m_8055_((BlockPos)pos).m_60796_((BlockGetter)w, (BlockPos)pos)) {
            pos.m_122178_(x, --y, z);
        }
        if ((double)y < box.f_82289_ || (double)y > box.f_82292_ - 1.0) {
            pos.m_122178_(x, (int)box.f_82289_ + w.f_46441_.m_188503_((int)(box.f_82292_ - box.f_82289_) + 1), z);
        }
        return pos.m_7494_();
    }

    public static int countPlayerLoadedChunks(@NotNull Level world) {
        ArrayList chunks = Lists.newArrayList();
        int i = 0;
        for (Player player : world.m_6907_()) {
            if (player.m_5833_()) continue;
            int x = Mth.m_14107_((double)(player.m_20185_() / 16.0));
            int z = Mth.m_14107_((double)(player.m_20189_() / 16.0));
            for (int dx = -8; dx <= 8; ++dx) {
                for (int dz = -8; dz <= 8; ++dz) {
                    ChunkPos chunkpos = new ChunkPos(dx + x, dz + z);
                    if (chunks.contains(chunkpos)) continue;
                    ++i;
                    chunks.add(chunkpos);
                }
            }
        }
        return i;
    }

    @NotNull
    public static Vec3 getItemPosition(@NotNull LivingEntity entity, boolean mainHand) {
        Player player;
        boolean left = (mainHand ? entity.m_5737_() : entity.m_5737_().m_20828_()) == HumanoidArm.LEFT;
        boolean firstPerson = entity instanceof Player && (player = (Player)entity).m_7578_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
        Vec3 dir = firstPerson ? entity.m_20156_() : Vec3.m_82503_((Vec2)new Vec2(entity.m_146909_(), entity.f_20883_));
        dir = dir.m_82524_(0.62831855f * (left ? 1.0f : -1.0f)).m_82490_(0.75);
        return dir.m_82520_(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
    }

    @Nullable
    public static <T extends Mob> Entity spawnEntityBehindEntity(@NotNull LivingEntity entity, @NotNull EntityType<T> toSpawn, @NotNull MobSpawnType reason) {
        BlockPos behind = UtilLib.getPositionBehindEntity(entity, 2.0f);
        Mob e = (Mob)toSpawn.m_20615_(entity.m_20193_());
        if (e == null) {
            return null;
        }
        Level level = entity.m_20193_();
        e.m_6034_((double)behind.m_123341_(), entity.m_20186_(), (double)behind.m_123343_());
        if (e.m_5545_((LevelAccessor)level, reason) && e.m_6914_((LevelReader)level)) {
            entity.m_20193_().m_7967_((Entity)e);
            return e;
        }
        int y = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, behind).m_123342_();
        e.m_6034_((double)behind.m_123341_(), (double)y, (double)behind.m_123343_());
        if (e.m_5545_((LevelAccessor)level, reason) && e.m_6914_((LevelReader)level)) {
            level.m_7967_((Entity)e);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                UtilLib.onInitialSpawn(serverLevel, (Entity)e, reason);
            }
            return e;
        }
        e.m_142687_(Entity.RemovalReason.DISCARDED);
        return null;
    }

    private static void onInitialSpawn(@NotNull ServerLevel level, Entity e, @NotNull MobSpawnType reason) {
        if (e instanceof Mob) {
            Mob mob = (Mob)e;
            mob.m_6518_((ServerLevelAccessor)level, e.m_20193_().m_6436_(e.m_20183_()), reason, null, null);
        }
    }

    @NotNull
    public static BlockPos getPositionBehindEntity(@NotNull LivingEntity p, float distance) {
        float yaw = p.f_20885_;
        float cosYaw = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        double x = p.m_20185_() + (double)(sinYaw * distance);
        double z = p.m_20189_() + (double)(cosYaw * distance);
        return new BlockPos((int)x, (int)p.m_20186_(), (int)z);
    }

    public static boolean spawnEntityInWorld(@NotNull ServerLevel world, @NotNull AABB box, @NotNull Entity e, int maxTry, @NotNull List<? extends LivingEntity> avoidedEntities, @NotNull MobSpawnType reason) {
        if (!world.m_46812_((int)box.f_82288_, (int)box.f_82289_, (int)box.f_82290_, (int)box.f_82291_, (int)box.f_82292_, (int)box.f_82293_)) {
            return false;
        }
        boolean flag = false;
        int i = 0;
        BlockPos backupPos = null;
        while (!flag && i++ < maxTry) {
            BlockPos c = UtilLib.getRandomPosInBox((Level)world, box);
            if (!world.m_45772_(new AABB(c)) || !world.isAreaLoaded(c, 5) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_((EntityType)e.m_6095_()), (LevelReader)world, (BlockPos)c, (EntityType)e.m_6095_())) continue;
            e.m_6034_((double)c.m_123341_(), (double)c.m_123342_() + 0.2, (double)c.m_123343_());
            if ((!SpawnPlacements.m_217074_((EntityType)e.m_6095_(), (ServerLevelAccessor)world, (MobSpawnType)reason, (BlockPos)c, (RandomSource)world.m_213780_()) || e instanceof Mob) && (!((Mob)e).m_5545_((LevelAccessor)world, reason) || !((Mob)e).m_6914_((LevelReader)e.m_20193_()))) continue;
            backupPos = c;
            for (LivingEntity livingEntity : avoidedEntities) {
                if (livingEntity.m_20280_(e) < 500.0 && livingEntity.m_142582_(e)) continue;
                flag = true;
            }
        }
        if (!flag && backupPos != null) {
            e.m_6034_((double)backupPos.m_123341_(), (double)backupPos.m_123342_() + 0.2, (double)backupPos.m_123343_());
            flag = true;
        }
        if (flag) {
            world.m_7967_(e);
            UtilLib.onInitialSpawn(world, e, reason);
            return true;
        }
        return false;
    }

    @Nullable
    public static Entity spawnEntityInWorld(@NotNull ServerLevel world, @NotNull AABB box, @NotNull EntityType<?> entityType, int maxTry, @NotNull List<? extends LivingEntity> avoidedEntities, @NotNull MobSpawnType reason) {
        Entity e = entityType.m_20615_((Level)world);
        if (UtilLib.spawnEntityInWorld(world, box, e, maxTry, avoidedEntities, reason)) {
            return e;
        }
        if (e != null) {
            e.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return null;
    }

    public static boolean teleportTo(@NotNull Mob entity, double x, double y, double z, boolean sound) {
        double d3 = entity.m_20185_();
        double d4 = entity.m_20186_();
        double d5 = entity.m_20189_();
        entity.m_20343_(x, y, z);
        boolean flag = false;
        BlockPos blockPos = entity.m_20183_();
        double ty = y;
        if (entity.m_20193_().m_46805_(blockPos)) {
            boolean flag1 = false;
            while (!flag1 && blockPos.m_123342_() > 0) {
                BlockState blockState = entity.m_20193_().m_8055_(blockPos.m_7495_());
                if (blockState.m_280555_()) {
                    flag1 = true;
                    continue;
                }
                entity.m_20343_(x, ty -= 1.0, z);
                blockPos = blockPos.m_7495_();
            }
            if (flag1) {
                entity.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                if (entity.m_20193_().m_45786_((Entity)entity) && !entity.m_20193_().m_46855_(entity.m_20191_())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.m_6034_(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (entity.m_217043_().m_188501_() - 0.5f) * 0.2f;
            float f1 = (entity.m_217043_().m_188501_() - 0.5f) * 0.2f;
            float f2 = (entity.m_217043_().m_188501_() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.m_20185_() - d3) * d6 + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_() * 2.0;
            double d8 = d4 + (entity.m_20186_() - d4) * d6 + entity.m_217043_().m_188500_() * (double)entity.m_20206_();
            double d9 = d5 + (entity.m_20189_() - d5) * d6 + (entity.m_217043_().m_188500_() - 0.5) * (double)entity.m_20205_() * 2.0;
            entity.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        if (sound) {
            entity.m_20193_().m_7785_(d3, d4, d5, SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            entity.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return true;
    }

    public static void spawnParticles(@NotNull Level world, @NotNull ParticleOptions particle, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int amount, float maxOffset) {
        double x = xCoord;
        double y = yCoord;
        double z = zCoord;
        for (int i = 0; i < amount; ++i) {
            world.m_7106_(particle, x, y, z, xSpeed, ySpeed, zSpeed);
            RandomSource ran = world.f_46441_;
            x = xCoord + ran.m_188583_() * (double)maxOffset;
            y = yCoord + ran.m_188583_() * (double)maxOffset;
            z = zCoord + ran.m_188583_() * (double)maxOffset;
        }
    }

    public static void spawnParticlesAroundEntity(@NotNull LivingEntity e, @NotNull ParticleOptions particle, double maxDistance, int amount) {
        int short1 = amount;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0) - 0.5;
            float f = (e.m_217043_().m_188501_() - 0.5f) * 0.2f;
            float f1 = (e.m_217043_().m_188501_() - 0.5f) * 0.2f;
            float f2 = (e.m_217043_().m_188501_() - 0.5f) * 0.2f;
            double d7 = e.m_20185_() + maxDistance * d6 + (e.m_217043_().m_188500_() - 0.5) * (double)e.m_20205_() * 2.0;
            double d8 = e.m_20186_() + maxDistance / 2.0 * d6 + e.m_217043_().m_188500_() * (double)e.m_21223_();
            double d9 = e.m_20189_() + maxDistance * d6 + (e.m_217043_().m_188500_() - 0.5) * (double)e.m_20205_() * 2.0;
            e.m_20193_().m_7106_(particle, d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
    }

    public static void sendMessageToAllExcept(Player player, @NotNull Component message) {
        for (Player o : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            if (o.equals((Object)player)) continue;
            o.m_213846_(message);
        }
    }

    public static void sendMessageToAll(@NotNull Component message) {
        UtilLib.sendMessageToAllExcept(null, message);
    }

    public static boolean canReallySee(@NotNull LivingEntity entity, @NotNull LivingEntity target, boolean alsoRaytrace) {
        if (alsoRaytrace && !entity.m_142582_((Entity)target)) {
            return false;
        }
        Vec3 look1 = new Vec3(-Math.sin((double)(entity.f_20885_ / 180.0f) * Math.PI), 0.0, Math.cos((double)(entity.f_20885_ / 180.0f) * Math.PI));
        Vec3 dist = new Vec3(target.m_20185_() - entity.m_20185_(), 0.0, target.m_20189_() - entity.m_20189_());
        double alpha = Math.acos((look1 = look1.m_82541_()).m_82526_(dist = dist.m_82541_()));
        return alpha < 1.7453292519943295;
    }

    public static void write(@NotNull CompoundTag nbt, String base, @NotNull BlockPos pos) {
        nbt.m_128405_(base + "_x", pos.m_123341_());
        nbt.m_128405_(base + "_y", pos.m_123342_());
        nbt.m_128405_(base + "_z", pos.m_123343_());
    }

    @NotNull
    public static BlockPos readPos(@NotNull CompoundTag nbt, String base) {
        return new BlockPos(nbt.m_128451_(base + "_x"), nbt.m_128451_(base + "_y"), nbt.m_128451_(base + "_z"));
    }

    public static String @NotNull [] prefix(String prefix, String ... strings) {
        String[] result = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = prefix + strings[i];
        }
        return result;
    }

    @NotNull
    public static <T> Predicate<T> getPredicateForClass(@NotNull Class<T> clazz) {
        return clazz::isInstance;
    }

    @NotNull
    public static AABB createBB(@NotNull BlockPos center, int distance, boolean fullY) {
        return new AABB((double)(center.m_123341_() - distance), fullY ? 0.0 : (double)(center.m_123342_() - distance), (double)(center.m_123343_() - distance), (double)(center.m_123341_() + distance), fullY ? 256.0 : (double)(center.m_123342_() + distance), (double)(center.m_123343_() + distance));
    }

    public static boolean isNonNull(Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayerOp(@NotNull Player player) {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11307_().m_11388_((Object)player.m_36316_()) != null;
    }

    public static boolean isSameInstanceAsServer() {
        return ServerLifecycleHooks.getCurrentServer() != null;
    }

    @Nullable
    public static String translate(String key, Object ... format) {
        String pattern = ForgeI18n.getPattern((String)key);
        if (format.length == 0) {
            return pattern;
        }
        try {
            pattern = UtilLib.replaceDeprecatedFormatter(pattern);
            return ForgeI18n.parseFormat((String)pattern, (Object[])Arrays.stream(format).map(o -> {
                Object object;
                if (o instanceof Component) {
                    Component component = (Component)o;
                    object = component.getString();
                } else {
                    object = o;
                }
                return object;
            }).toArray());
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Illegal format found `{}`", (Object)pattern);
            return pattern;
        }
    }

    @NotNull
    private static String replaceDeprecatedFormatter(@NotNull String text) {
        StringBuilder sb = null;
        Matcher m = oldFormatPattern.matcher(text);
        int i = 0;
        while (m.find()) {
            String t = "{" + i++ + "}";
            if (sb == null) {
                sb = new StringBuilder(text.length());
            }
            m.appendReplacement(sb, t);
        }
        if (sb == null) {
            return text;
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @NotNull
    public static VoxelShape rotateShape(@NotNull VoxelShape shape, RotationAmount rotation) {
        HashSet rotatedShapes = new HashSet();
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            if (rotation == RotationAmount.NINETY) {
                rotatedShapes.add(UtilLib.blockBox(8.0 - z1, y1 * 16.0, 8.0 + x1, 8.0 - z2, y2 * 16.0, 8.0 + x2));
            } else if (rotation == RotationAmount.HUNDRED_EIGHTY) {
                rotatedShapes.add(UtilLib.blockBox(8.0 - x1, y1 * 16.0, 8.0 - z1, 8.0 - x2, y2 * 16.0, 8.0 - z2));
            } else if (rotation == RotationAmount.TWO_HUNDRED_SEVENTY) {
                rotatedShapes.add(UtilLib.blockBox(8.0 + z1, y1 * 16.0, 8.0 - x1, 8.0 + z2, y2 * 16.0, 8.0 - x2));
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElseGet(() -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    }

    @NotNull
    public static VoxelShape rollShape(@NotNull VoxelShape shape, @NotNull Direction direction) {
        HashSet rotatedShapes = new HashSet();
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            y1 = y1 * 16.0 - 8.0;
            y2 = y2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            switch (direction) {
                case NORTH: {
                    z1 = 8.0 - z1;
                    z2 = 8.0 - z2;
                    y1 = 8.0 + y1;
                    y2 = 8.0 + y2;
                    double yMin = Math.min(y1, y2);
                    double yMax = Math.max(y1, y2);
                    double zMin = Math.min(z1, z2);
                    double zMax = Math.max(z1, z2);
                    rotatedShapes.add(Block.m_49796_((double)(x1 * 16.0), (double)zMin, (double)yMin, (double)(x2 * 16.0), (double)zMax, (double)yMax));
                    break;
                }
                case SOUTH: {
                    z1 = 8.0 + z1;
                    z2 = 8.0 + z2;
                    y1 = 8.0 - y1;
                    y2 = 8.0 - y2;
                    double yMin = Math.min(y1, y2);
                    double yMax = Math.max(y1, y2);
                    double zMin = Math.min(z1, z2);
                    double zMax = Math.max(z1, z2);
                    rotatedShapes.add(Block.m_49796_((double)(x1 * 16.0), (double)zMin, (double)yMin, (double)(x2 * 16.0), (double)zMax, (double)yMax));
                }
            }
        });
        return rotatedShapes.stream().reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElseGet(() -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    }

    @NotNull
    public static VoxelShape blockBox(double pX1, double pY1, double pZ1, double pX2, double pY2, double pZ2) {
        return Block.m_49796_((double)Math.min(pX1, pX2), (double)Math.min(pY1, pY2), (double)Math.min(pZ1, pZ2), (double)Math.max(pX1, pX2), (double)Math.max(pY1, pY2), (double)Math.max(pZ1, pZ2));
    }

    @Nullable
    public static StructureStart getStructureStartAt(@NotNull Entity entity, @NotNull Structure s) {
        return UtilLib.getStructureStartAt(entity.m_20193_(), entity.m_20183_(), s);
    }

    @NotNull
    public static Optional<StructureStart> getStructureStartAt(@NotNull Entity entity, @NotNull TagKey<Structure> s) {
        return UtilLib.getStructureStartAt(entity.m_20193_(), entity.m_20183_(), s);
    }

    public static boolean isInsideStructure(Level w, @NotNull BlockPos p, @NotNull Structure s) {
        StructureStart start = UtilLib.getStructureStartAt(w, p, s);
        return start != null && start.m_73603_();
    }

    public static boolean isInsideStructure(Level w, @NotNull BlockPos p, @NotNull TagKey<Structure> s) {
        return UtilLib.getStructureStartAt(w, p, s).isPresent();
    }

    public static boolean isInsideStructure(@NotNull Entity entity, @NotNull Structure s) {
        StructureStart start = UtilLib.getStructureStartAt(entity, s);
        return start != null && start.m_73603_();
    }

    public static boolean isInsideStructure(@NotNull Entity entity, @NotNull TagKey<Structure> structures) {
        return UtilLib.getStructureStartAt(entity, structures).isPresent();
    }

    @Nullable
    public static StructureStart getStructureStartAt(Level level, @NotNull BlockPos pos, @NotNull Structure s) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46749_(pos)) {
            return UtilLib.getStructureStartAt(serverLevel, pos, s);
        }
        return null;
    }

    @NotNull
    public static Optional<StructureStart> getStructureStartAt(Level level, @NotNull BlockPos pos, @NotNull TagKey<Structure> structureTag) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46749_(pos)) {
            Registry registry = serverLevel.m_9598_().m_175515_(Registries.f_256944_);
            return serverLevel.m_215010_().m_220477_(new ChunkPos(pos), structure -> registry.m_203300_(registry.m_7447_(structure)).map(a -> a.m_203656_(structureTag)).orElse(false)).stream().findFirst();
        }
        return Optional.empty();
    }

    @NotNull
    public static StructureStart getStructureStartAt(@NotNull ServerLevel w, @NotNull BlockPos pos, @NotNull Structure structure) {
        for (StructureStart structurestart : w.m_215010_().m_220504_(SectionPos.m_123199_((BlockPos)pos), structure)) {
            if (!structurestart.m_73601_().m_71051_((Vec3i)pos)) continue;
            return structurestart;
        }
        return StructureStart.f_73561_;
    }

    @Nullable
    public static CompoundTag checkNBT(@NotNull ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }

    public static float[] getColorComponents(int color) {
        int i = (color & 0xFF0000) >> 16;
        int j = (color & 0xFF00) >> 8;
        int k = color & 0xFF;
        return new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
    }

    @NotNull
    public static int[] bbToInt(@NotNull AABB bb) {
        return new int[]{(int)bb.f_82288_, (int)bb.f_82289_, (int)bb.f_82290_, (int)bb.f_82291_, (int)bb.f_82292_, (int)bb.f_82293_};
    }

    @NotNull
    public static int[] mbToInt(@NotNull BoundingBox bb) {
        return new int[]{bb.m_162395_(), bb.m_162396_(), bb.m_162398_(), bb.m_162399_(), bb.m_162400_(), bb.m_162401_()};
    }

    @NotNull
    public static AABB intToBB(@NotNull @NotNull int @NotNull [] array) {
        return new AABB((double)array[0], (double)array[1], (double)array[2], (double)array[3], (double)array[4], (double)array[5]);
    }

    @NotNull
    public static BoundingBox intToMB(@NotNull @NotNull int @NotNull [] array) {
        return new BoundingBox(array[0], array[1], array[2], array[3], array[4], array[5]);
    }

    @NotNull
    public static BoundingBox AABBtoMB(@NotNull AABB bb) {
        return new BoundingBox((int)bb.f_82288_, (int)bb.f_82289_, (int)bb.f_82290_, (int)bb.f_82291_, (int)bb.f_82292_, (int)bb.f_82293_);
    }

    @NotNull
    public static AABB MBtoAABB(@NotNull BoundingBox bb) {
        return new AABB((double)bb.m_162395_(), (double)bb.m_162396_(), (double)bb.m_162398_(), (double)bb.m_162399_(), (double)bb.m_162400_(), (double)bb.m_162401_());
    }

    public static int renderMultiLine(@NotNull Font fontRenderer, @NotNull GuiGraphics graphics, @NotNull Component text, int textLength, int x, int y, int color) {
        int d = 0;
        for (FormattedCharSequence sequence : fontRenderer.m_92923_((FormattedText)text, textLength)) {
            graphics.m_280649_(fontRenderer, sequence, x, y + d, color, false);
            Objects.requireNonNull(fontRenderer);
            d += 9;
        }
        return d;
    }

    @Nullable
    public static DyeColor getColorForItem(@NotNull Item item) {
        if (!item.m_204114_().m_203656_(Tags.Items.DYES)) {
            return null;
        }
        Optional<DyeColor> color = Arrays.stream(DyeColor.values()).filter(dye -> item.m_204114_().m_203656_(dye.getTag())).findFirst();
        if (color.isPresent()) {
            return color.get();
        }
        LOGGER.warn("Could not determine color of {}", (Object)ForgeRegistries.ITEMS.getKey((Object)item));
        return null;
    }

    public static boolean isValidResourceLocation(@NotNull String loc) {
        return ResourceLocation.m_135820_((String)loc) != null;
    }

    public static void replaceEntity(@NotNull LivingEntity old, @NotNull LivingEntity replacement) {
        Level w = old.m_20193_();
        MinecraftForge.EVENT_BUS.post((Event)new LivingConversionEvent.Post(old, replacement));
        old.m_142687_(Entity.RemovalReason.DISCARDED);
        w.m_7967_((Entity)replacement);
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> newSortedSet(T ... elements) {
        LinkedHashSet s = new LinkedHashSet();
        Collections.addAll(s, elements);
        return s;
    }

    public static boolean matchesItem(@NotNull Ingredient ingredient, @NotNull ItemStack searchStack) {
        return Arrays.stream(ingredient.m_43908_()).anyMatch(stack -> {
            if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)searchStack)) {
                return false;
            }
            if (stack.m_41783_() != null) {
                return stack.areShareTagsEqual(searchStack);
            }
            return true;
        });
    }

    public static int countItemWithNBT(@NotNull Inventory inventory, @NotNull ItemStack stack) {
        int i = 0;
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack itemstack = inventory.m_8020_(j);
            if (!ItemStack.m_41656_((ItemStack)itemstack, (ItemStack)stack) || !ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)stack)) continue;
            i += itemstack.m_41613_();
        }
        return i;
    }

    @NotNull
    public static ResourceLocation amend(@NotNull ResourceLocation original, String amendment) {
        return new ResourceLocation(original.m_135827_(), original.m_135815_() + amendment);
    }

    public static float horizontalDistance(BlockPos pos1, BlockPos pos2) {
        int i = pos2.m_123341_() - pos1.m_123341_();
        int j = pos2.m_123343_() - pos1.m_123343_();
        return Mth.m_14116_((float)(i * i + j * j));
    }

    public static boolean never(BlockState state, BlockGetter block, BlockPos pos) {
        return false;
    }

    public static enum RotationAmount {
        NINETY,
        HUNDRED_EIGHTY,
        TWO_HUNDRED_SEVENTY;

    }
}

