/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.task;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Task {
    @NotNull
    private final Variant variant;
    @NotNull
    private final Supplier<IPlayableFaction<?>> faction;
    @NotNull
    private final TaskRequirement requirements;
    @NotNull
    private final TaskReward rewards;
    @NotNull
    private final TaskUnlocker[] unlocker;
    private final boolean useDescription;
    @Nullable
    private String translationKey;
    @Nullable
    private Component translation;
    @Nullable
    private String descKey;
    @Nullable
    private Component desc;

    public Task(@NotNull Variant variant, @NotNull Supplier<IPlayableFaction<?>> faction, @NotNull TaskRequirement requirements, @NotNull TaskReward rewards, @NotNull TaskUnlocker[] unlocker, boolean useDescription) {
        this.variant = variant;
        this.faction = faction;
        this.requirements = requirements;
        this.useDescription = useDescription;
        this.rewards = rewards;
        this.unlocker = unlocker;
    }

    @NotNull
    public Component getDescription() {
        return this.desc != null ? this.desc : (this.desc = Component.m_237115_((String)this.getDescriptionKey()));
    }

    @NotNull
    public String getDescriptionKey() {
        return this.descKey != null ? this.descKey : (this.descKey = (this.translationKey != null ? this.translationKey : this.getTranslationKey()) + ".desc");
    }

    @Nullable
    public IPlayableFaction<?> getFaction() {
        return this.faction.get();
    }

    @NotNull
    public TaskRequirement getRequirement() {
        return this.requirements;
    }

    @NotNull
    public TaskReward getReward() {
        return this.rewards;
    }

    @NotNull
    public Component getTranslation() {
        return this.translation != null ? this.translation : (this.translation = Component.m_237115_((String)this.getTranslationKey()));
    }

    @NotNull
    public String getTranslationKey() {
        return this.translationKey != null ? this.translationKey : (this.translationKey = Util.m_137492_((String)"task", (ResourceLocation)this.getRegistryName()));
    }

    @NotNull
    public TaskUnlocker[] getUnlocker() {
        return this.unlocker;
    }

    public boolean isUnique() {
        return this.variant == Variant.UNIQUE;
    }

    public boolean useDescription() {
        return this.useDescription;
    }

    @Nullable
    private ResourceLocation getRegistryName() {
        return VampirismRegistries.TASKS.get().getKey((Object)this);
    }

    public static enum Variant {
        REPEATABLE,
        UNIQUE;

    }
}

