/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModTiles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TotemTopBlock
extends BaseEntityBlock {
    private static final List<TotemTopBlock> blocks = new ArrayList<TotemTopBlock>();
    private static final VoxelShape shape = TotemTopBlock.makeShape();
    public final ResourceLocation faction;
    private final boolean crafted;

    @NotNull
    public static List<TotemTopBlock> getBlocks() {
        return Collections.unmodifiableList(blocks);
    }

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
        VoxelShape b = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0);
        return Shapes.m_83110_((VoxelShape)a, (VoxelShape)b);
    }

    public TotemTopBlock(boolean crafted, ResourceLocation faction) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(12.0f, 2000.0f).m_60918_(SoundType.f_56742_));
        this.faction = faction;
        this.crafted = crafted;
        blocks.add(this);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public float m_7325_() {
        return Float.MAX_VALUE;
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof TotemBlockEntity) {
            ((TotemBlockEntity)tile).updateTileStatus();
            worldIn.m_7696_(pos, (Block)this, 1, 0);
        }
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return shape;
    }

    public boolean isCrafted() {
        return this.crafted;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)ModTiles.TOTEM.get()).m_155264_(pos, state);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!(newState.m_60734_() instanceof TotemTopBlock)) {
            worldIn.m_46747_(pos);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        TotemBlockEntity t = this.getTile(world, pos);
        if (t != null && world.m_8055_(pos.m_7495_()).m_60734_().equals(ModBlocks.TOTEM_BASE.get())) {
            t.initiateCapture(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean onDestroyedByPlayer(BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, boolean willHarvest, FluidState fluid) {
        TotemBlockEntity tile = this.getTile(world, pos);
        if (tile != null && !tile.canPlayerRemoveBlock(player)) {
            return false;
        }
        if (super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid)) {
            if (tile != null && tile.getControllingFaction() != null) {
                tile.notifyNearbyPlayers((Component)Component.m_237115_((String)"text.vampirism.village.village_abandoned"));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private TotemBlockEntity getTile(@NotNull Level world, @NotNull BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TotemBlockEntity) {
            return (TotemBlockEntity)tile;
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return TotemTopBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModTiles.TOTEM.get()), (BlockEntityTicker)(level.m_5776_() ? TotemBlockEntity::clientTick : TotemBlockEntity::serverTick));
    }
}

