/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.client.model.blocks.BakedAltarInspirationModel;
import de.teamlapen.vampirism.client.model.blocks.BakedBloodContainerModel;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.effects.VampirismPotion;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.vampirism.proxy.ClientProxy;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.OilUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    static void onModelBakeRequest(ModelEvent.RegisterAdditional event) {
        int x;
        for (x = 0; x < 14; ++x) {
            event.register(new ResourceLocation("vampirism", "block/blood_container/blood_" + (x + 1)));
            event.register(new ResourceLocation("vampirism", "block/blood_container/impure_blood_" + (x + 1)));
        }
        for (x = 0; x < 10; ++x) {
            event.register(new ResourceLocation("vampirism", "block/altar_inspiration/blood" + (x + 1)));
        }
    }

    static void onModelBakeEvent(@NotNull ModelEvent.ModifyBakingResult event) {
        Object newModel;
        BakedModel registeredModel;
        ArrayList modelLocations;
        ResourceLocation loc;
        try {
            for (int x = 0; x < 14; ++x) {
                loc = new ResourceLocation("vampirism", "block/blood_container/blood_" + (x + 1));
                ResourceLocation locImpure = new ResourceLocation("vampirism", "block/blood_container/impure_blood_" + (x + 1));
                BakedBloodContainerModel.BLOOD_FLUID_MODELS[x] = (BakedModel)event.getModels().get(loc);
                BakedBloodContainerModel.IMPURE_BLOOD_FLUID_MODELS[x] = (BakedModel)event.getModels().get(locImpure);
            }
            Map registry = event.getModels();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (modelLoc.m_135815_().contains("fluid")) {
                    LOGGER.info((Object)modelLoc);
                }
                if (!modelLoc.m_135827_().equals("vampirism") || !modelLoc.m_135815_().equals(ModBlocks.BLOOD_CONTAINER.getId().m_135815_())) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc2 : modelLocations) {
                registeredModel = (BakedModel)event.getModels().get(loc2);
                newModel = new BakedBloodContainerModel(registeredModel);
                event.getModels().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for blood container", (Throwable)e);
        }
        try {
            for (int x = 0; x < 10; ++x) {
                loc = new ResourceLocation("vampirism", "block/altar_inspiration/blood" + (x + 1));
                BakedAltarInspirationModel.FLUID_MODELS[x] = (BakedModel)event.getModels().get(loc);
            }
            Map registry = event.getModels();
            modelLocations = Lists.newArrayList();
            for (ResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.m_135827_().equals("vampirism") || !modelLoc.m_135815_().equals(ModBlocks.ALTAR_INSPIRATION.getId().m_135815_())) continue;
                modelLocations.add(modelLoc);
            }
            for (ResourceLocation loc2 : modelLocations) {
                registeredModel = (BakedModel)event.getModels().get(loc2);
                newModel = new BakedAltarInspirationModel(registeredModel);
                event.getModels().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for altar inspiration", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onFovOffsetUpdate(@NotNull ComputeFovModifierEvent event) {
        if (((Boolean)VampirismConfig.CLIENT.disableFovChange.get()).booleanValue() && Helper.isVampire(event.getPlayer())) {
            AttributeInstance speed = event.getPlayer().m_21051_(Attributes.f_22279_);
            AttributeModifier vampirespeed = speed.m_22111_(LevelAttributeModifier.getUUID(Attributes.f_22279_));
            if (vampirespeed == null) {
                return;
            }
            event.setNewFovModifier((float)((double)event.getFovModifier() * ((vampirespeed.m_22218_() + 1.0) * (double)event.getPlayer().m_150110_().m_35947_() + speed.m_22135_()) / ((vampirespeed.m_22218_() + 1.0) * ((double)event.getPlayer().m_150110_().m_35947_() + speed.m_22135_()))));
        }
    }

    @SubscribeEvent
    public void onToolTip(@NotNull ItemTooltipEvent event) {
        if (VampirismPotion.isHunterPotion(event.getItemStack(), true).map(Potion::m_43488_).map(effectInstances -> effectInstances.stream().map(MobEffectInstance::m_19544_).anyMatch(MobEffect::m_19486_)).orElse(false).booleanValue() && (event.getEntity() == null || !Helper.isHunter(event.getEntity()))) {
            event.getToolTip().add(Component.m_237115_((String)"text.vampirism.hunter_potion.deadly").m_130940_(ChatFormatting.DARK_RED));
        }
    }

    @SubscribeEvent
    public void onWorldClosed(LevelEvent.Unload event) {
        ((ClientProxy)VampirismMod.proxy).clearBossBarOverlay();
    }

    static void onModelRegistry(@NotNull ModelEvent.RegisterAdditional event) {
        for (DyeColor dye : DyeColor.values()) {
            event.register(new ResourceLocation("vampirism", "block/coffin/coffin_bottom_" + dye.m_41065_()));
            event.register(new ResourceLocation("vampirism", "block/coffin/coffin_top_" + dye.m_41065_()));
            event.register(new ResourceLocation("vampirism", "block/coffin/coffin_" + dye.m_41065_()));
        }
    }

    @SubscribeEvent
    public void onItemToolTip(@NotNull ItemTooltipEvent event) {
        if (event.getItemStack().m_41720_() instanceof IFactionExclusiveItem) {
            return;
        }
        OilUtils.getAppliedOilStatus(event.getItemStack()).ifPresent(oil -> {
            List toolTips = event.getToolTip();
            int position = 1;
            int flags = this.getHideFlags(event.getItemStack());
            if (ClientEventHandler.shouldShowInTooltip(flags, ItemStack.TooltipPart.ADDITIONAL)) {
                ArrayList additionalComponents = new ArrayList();
                event.getItemStack().m_41720_().m_7373_(event.getItemStack(), Minecraft.m_91087_().f_91074_ == null ? null : Minecraft.m_91087_().f_91074_.m_9236_(), additionalComponents, event.getFlags());
                position += additionalComponents.size();
                Optional<Component> oilTooltip = ((IApplicableOil)oil.getKey()).getToolTipLine(event.getItemStack(), (IApplicableOil)oil.getKey(), (Integer)oil.getValue(), event.getFlags());
                if (oilTooltip.isPresent()) {
                    toolTips.add(position++, oilTooltip.get());
                }
            }
            ArrayList<MutableComponent> factionToolTips = new ArrayList<MutableComponent>();
            factionToolTips.add(Component.m_237119_());
            factionToolTips.add(Component.m_237115_((String)"text.vampirism.faction_specifics").m_130940_(ChatFormatting.GRAY));
            factionToolTips.add(Component.m_237113_((String)" ").m_7220_(VReference.HUNTER_FACTION.getName()).m_7220_((Component)Component.m_237115_((String)"text.vampirism.faction_only")).m_130940_(Minecraft.m_91087_().f_91074_ != null ? (Helper.isHunter((Player)Minecraft.m_91087_().f_91074_) ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED) : ChatFormatting.GRAY));
            toolTips.addAll(Math.min(event.getToolTip().size(), position), factionToolTips);
        });
    }

    private static boolean shouldShowInTooltip(int p_242394_0_, @NotNull ItemStack.TooltipPart p_242394_1_) {
        return (p_242394_0_ & p_242394_1_.m_41809_()) == 0;
    }

    private int getHideFlags(@NotNull ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("HideFlags", 99) ? stack.m_41783_().m_128451_("HideFlags") : 0;
    }
}

