/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.overlay;

import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.mixin.client.BossOverlayGuiAccessor;
import de.teamlapen.vampirism.network.ClientboundUpdateMultiBossEventPacket;
import de.teamlapen.vampirism.world.MultiBossEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.jetbrains.annotations.NotNull;

public class CustomBossEventOverlay
implements IGuiOverlay {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    @NotNull
    private final Minecraft client;
    private final Map<UUID, MultiBossEvent> bossInfoMap = new LinkedHashMap<UUID, MultiBossEvent>();

    public CustomBossEventOverlay() {
        this.client = Minecraft.m_91087_();
    }

    public void clear() {
        this.bossInfoMap.clear();
    }

    public void read(@NotNull ClientboundUpdateMultiBossEventPacket packet) {
        if (packet.operation() == ClientboundUpdateMultiBossEventPacket.OperationType.ADD) {
            this.bossInfoMap.put(packet.uniqueId(), new MultiBossEvent(packet));
        } else if (packet.operation() == ClientboundUpdateMultiBossEventPacket.OperationType.REMOVE) {
            this.bossInfoMap.remove(packet.uniqueId());
        } else {
            this.bossInfoMap.get(packet.uniqueId()).updateFromPackage(packet);
        }
    }

    public void render(ForgeGui gui, @NotNull GuiGraphics graphics, float partialTicks, int width, int height) {
        int i = Minecraft.m_91087_().m_91268_().m_85445_();
        int n = ((BossOverlayGuiAccessor)this.client.f_91065_.m_93090_()).getMapBossInfos().size();
        Objects.requireNonNull(this.client.f_91062_);
        int j = 12 + n * (10 + 9);
        for (MultiBossEvent value : this.bossInfoMap.values()) {
            int k = i / 2 - 91;
            this.render(graphics, k, j, value);
            Component itextcomponent = value.getName();
            int l = this.client.f_91062_.m_92852_((FormattedText)itextcomponent);
            int i1 = i / 2 - l / 2;
            int j1 = j - 9;
            graphics.m_280614_(this.client.f_91062_, itextcomponent, i1, j1, 0xFFFFFF, true);
            if (j < this.client.m_91268_().m_85446_() / 3) continue;
            break;
        }
    }

    private void render(@NotNull GuiGraphics graphics, int k, int j, @NotNull MultiBossEvent value) {
        int width;
        int textureStart = 0;
        List<Color> s = value.getColors();
        Map<Color, Float> perc = value.getEntries();
        for (int i = 0; i < s.size() && textureStart < 182; textureStart += width, ++i) {
            Color color = s.get(i);
            width = (int)(perc.getOrDefault(color, Float.valueOf(0.0f)).floatValue() * 182.0f);
            if (i == s.size() - 1 && textureStart + width < 182) {
                width = 182 - textureStart;
            }
            graphics.m_280246_(color.getRedF(), color.getGreenF(), color.getBlueF(), color.getAlphaF());
            graphics.m_280218_(GUI_BARS_TEXTURES, k + textureStart, j, textureStart, BossEvent.BossBarColor.WHITE.ordinal() * 5 * 2 + 5, width, 5);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (value.getOverlay() != BossEvent.BossBarOverlay.PROGRESS) {
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280218_(GUI_BARS_TEXTURES, k, j, 0, 80 + (value.getOverlay().ordinal() - 1) * 5 * 2, 182, 5);
        }
    }
}

