/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.lib.lib.client.gui.ExtendedGui;
import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.lib.util.OptifineHandler;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.items.StakeItem;
import de.teamlapen.vampirism.modcompat.IMCHandler;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class VampirismHUDOverlay
extends ExtendedGui {
    private final Minecraft mc;
    private static final ResourceLocation ICONS = new ResourceLocation("vampirism", "textures/gui/icons.png");
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private int screenColor = 0;
    private int screenPercentage = 0;
    private boolean fullScreen = false;
    private int renderFullTick = 0;
    private int rederFullOn;
    private int renderFullOff;
    private int renderFullColor;
    private int screenBottomColor = 0;
    private int screenBottomPercentage = 0;
    private boolean addTempPoison;
    private MobEffectInstance addedTempPoison;

    public VampirismHUDOverlay(Minecraft mc) {
        this.mc = mc;
    }

    public void makeRenderFullColor(int on, int off, int color) {
        this.rederFullOn = on;
        this.renderFullOff = off;
        this.renderFullTick = on + off;
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        this.renderFullColor = color;
    }

    @SubscribeEvent
    public void onClientTick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.ClientTickEvent event) {
        if (this.mc.f_91074_ == null || !this.mc.f_91074_.m_6084_()) {
            this.renderFullTick = 0;
            this.screenPercentage = 0;
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        @Nullable IFactionPlayer player = FactionPlayerHandler.getOpt((Player)this.mc.f_91074_).resolve().flatMap(FactionPlayerHandler::getCurrentFactionPlayer).orElse(null);
        if (player instanceof VampirePlayer) {
            this.handleScreenColorVampire((VampirePlayer)player);
        } else if (player instanceof HunterPlayer) {
            this.handleScreenColorHunter((HunterPlayer)player);
        } else {
            this.screenPercentage = 0;
            this.screenBottomPercentage = 0;
        }
        if (this.renderFullTick > 0) {
            this.screenColor = this.renderFullColor;
            this.fullScreen = true;
            this.screenPercentage = this.renderFullTick > this.renderFullOff ? (int)(100.0f * (1.0f - (float)(this.renderFullTick - this.renderFullOff) / (float)this.rederFullOn)) : (int)((float)(100 * this.renderFullTick) / (float)this.renderFullOff);
            --this.renderFullTick;
        }
    }

    @SubscribeEvent
    public void onRenderCrosshair(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiOverlayEvent.Pre event) {
        float progress;
        if (event.getOverlay().id() != VanillaGuiOverlay.CROSSHAIR.id() || this.mc.f_91074_ == null || !this.mc.f_91074_.m_6084_()) {
            return;
        }
        HitResult p = Minecraft.m_91087_().f_91077_;
        if (p != null && p.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)p).m_82443_();
            if (!entity.m_20145_()) {
                VampirismPlayerAttributes atts = VampirismPlayerAttributes.get((Player)this.mc.f_91074_);
                if (atts.vampireLevel > 0 && !this.mc.f_91074_.m_5833_() && !atts.getVampSpecial().bat) {
                    VampirePlayer.getOpt((Player)this.mc.f_91074_).ifPresent(player -> {
                        Object biteableOpt = LazyOptional.empty();
                        if (entity instanceof IBiteableEntity) {
                            biteableOpt = LazyOptional.of(() -> (IBiteableEntity)entity);
                        } else if (entity instanceof PathfinderMob && entity.m_6084_()) {
                            biteableOpt = ExtendedCreature.getSafe(entity);
                        } else if (entity instanceof Player) {
                            biteableOpt = VampirePlayer.getOpt((Player)entity);
                        }
                        biteableOpt.filter(iBiteableEntity -> iBiteableEntity.canBeBitten((IVampire)player)).ifPresent(biteable -> {
                            int color = 0xFF0000;
                            if (entity instanceof IHunterMob || ExtendedCreature.getSafe(entity).map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false).booleanValue()) {
                                color = 626722;
                            }
                            this.renderBloodFangs(event.getGuiGraphics(), this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_(), Mth.m_14036_((float)biteable.getBloodLevelRelative(), (float)0.2f, (float)1.0f), color);
                            event.setCanceled(true);
                        });
                    });
                }
                if (atts.hunterLevel > 0 && !this.mc.f_91074_.m_5833_() && this.mc.f_91074_.m_21205_().m_41720_() == ModItems.STAKE.get() && entity instanceof LivingEntity && entity instanceof IVampireMob && StakeItem.canKillInstant((LivingEntity)entity, (LivingEntity)this.mc.f_91074_) && ((LivingEntity)entity).m_21223_() > 0.0f) {
                    this.renderStakeInstantKill(event.getGuiGraphics(), this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_());
                    event.setCanceled(true);
                }
            }
        } else if (p != null && p.m_6662_() == HitResult.Type.BLOCK) {
            BlockEntity tile;
            BlockState block = Minecraft.m_91087_().f_91073_.m_8055_(((BlockHitResult)p).m_82425_());
            if (ModBlocks.BLOOD_CONTAINER.get() == block.m_60734_() && VampirePlayer.getOpt((Player)this.mc.f_91074_).map(VampirePlayer::wantsBlood).orElse(false).booleanValue() && (tile = Minecraft.m_91087_().f_91073_.m_7702_(((BlockHitResult)p).m_82425_())) != null) {
                tile.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> {
                    if (FluidLib.getFluidAmount(handler, (Fluid)ModFluids.BLOOD.get()) > 0) {
                        this.renderBloodFangs(event.getGuiGraphics(), this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_(), 1.0f, 0xFF0000);
                        event.setCanceled(true);
                    }
                });
            }
        }
        Options gamesettings = this.mc.f_91066_;
        if (gamesettings.m_92176_().m_90612_() && this.mc.f_91072_.m_105295_() != GameType.SPECTATOR && (progress = VampirePlayer.getOpt((Player)this.mc.f_91074_).map(VampirePlayer::getFeedProgress).orElse(Float.valueOf(0.0f)).floatValue()) > 0.0f) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (progress <= 1.0f) {
                int x = this.mc.m_91268_().m_85445_() / 2 - 8;
                int y = this.mc.m_91268_().m_85446_() / 2 - 7 + 16;
                int l = (int)(progress * 14.0f) + 2;
                event.getGuiGraphics().m_280218_(ICONS, x, y, 0, 19, 16, 2);
                event.getGuiGraphics().m_280218_(ICONS, x, y, 16, 19, l, 2);
            }
        }
    }

    @SubscribeEvent
    public void onRenderFoodBar(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id() == VanillaGuiOverlay.FOOD_LEVEL.id() && this.mc.f_91074_ != null && Helper.isVampire((Player)this.mc.f_91074_) && !IMCHandler.requestedToDisableBloodbar && this.mc.f_91072_.m_105288_() && this.mc.f_91074_.m_6084_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderGameOverlay(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiEvent.Pre event) {
        if ((this.screenPercentage > 0 || this.screenBottomPercentage > 0) && ((Boolean)VampirismConfig.CLIENT.renderScreenOverlay.get()).booleanValue()) {
            PoseStack stack = event.getGuiGraphics().m_280168_();
            stack.m_85836_();
            int w = this.mc.m_91268_().m_85445_();
            int h = this.mc.m_91268_().m_85446_();
            if (this.fullScreen) {
                float r = (float)(this.screenColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(this.screenColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(this.screenColor & 0xFF) / 255.0f;
                float a = (float)this.screenPercentage / 100.0f * (float)(this.screenColor >> 24 & 0xFF) / 255.0f;
                Matrix4f matrix = stack.m_85850_().m_252922_();
                VertexConsumer buffer = event.getGuiGraphics().m_280091_().m_6299_(RenderType.m_286086_());
                buffer.m_252986_(matrix, 0.0f, (float)h, 0.0f).m_85950_(r, g, b, a).m_5752_();
                buffer.m_252986_(matrix, (float)w, (float)h, 0.0f).m_85950_(r, g, b, a).m_5752_();
                buffer.m_252986_(matrix, (float)w, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
                buffer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, a).m_5752_();
                event.getGuiGraphics().m_280262_();
            } else if (this.screenPercentage > 0) {
                int bw = 0;
                int bh = 0;
                bh = Math.round((float)h / 4.0f * (float)this.screenPercentage / 100.0f);
                bw = Math.round((float)w / 8.0f * (float)this.screenPercentage / 100.0f);
                event.getGuiGraphics().m_280024_(0, 0, w, bh, this.screenColor, 0);
                if (!OptifineHandler.isShaders()) {
                    event.getGuiGraphics().m_280024_(0, h - bh, w, h, 0, this.screenColor);
                }
                this.fillGradient2(stack, 0, 0, bw, h, 0, this.screenColor);
                this.fillGradient2(stack, w - bw, 0, w, h, this.screenColor, 0);
            } else {
                int hh = 0;
                hh = Math.round((float)h / 4.0f * (float)this.screenBottomPercentage / 100.0f);
                event.getGuiGraphics().m_280024_(0, h - hh, w, h, 0, this.screenBottomColor);
            }
            stack.m_85849_();
        }
    }

    @SubscribeEvent
    public void onRenderHealthBarPost(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay().id() != VanillaGuiOverlay.PLAYER_HEALTH.id()) {
            return;
        }
        if (this.addTempPoison) {
            this.mc.f_91074_.f_20945_.remove(MobEffects.f_19614_);
        }
    }

    @SubscribeEvent
    public void onRenderHealthBarPre(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id() != VanillaGuiOverlay.PLAYER_HEALTH.id()) {
            return;
        }
        boolean bl = this.addTempPoison = this.mc.f_91074_.m_21023_((MobEffect)ModEffects.POISON.get()) && !this.mc.f_91074_.f_20945_.containsKey(MobEffects.f_19614_);
        if (this.addTempPoison) {
            if (this.addedTempPoison == null) {
                this.addedTempPoison = new MobEffectInstance(MobEffects.f_19614_, 100);
            }
            this.mc.f_91074_.f_20945_.put(MobEffects.f_19614_, this.addedTempPoison);
        }
    }

    private void handleScreenColorHunter(@NotNull HunterPlayer hunter) {
        if (hunter.getSpecialAttributes().isDisguised()) {
            this.screenPercentage = (int)(100.0f * hunter.getSpecialAttributes().getDisguiseProgress());
            this.screenColor = -15658735;
            this.fullScreen = false;
        } else if (hunter.getSpecialAttributes().isVampireNearby()) {
            this.screenPercentage = (int)(70.0f * hunter.getSpecialAttributes().getVampireNearbyProgress());
            this.screenColor = -2135287754;
            this.fullScreen = false;
        } else {
            this.screenPercentage = (int)Math.max(0.0f, (float)this.screenPercentage / 20.0f * 10.0f);
        }
    }

    private void handleScreenColorVampire(@NotNull VampirePlayer vampire) {
        if (vampire.getActionHandler().isActionActive((ILastingAction)VampireActions.VAMPIRE_RAGE.get())) {
            this.screenPercentage = 100;
            this.screenColor = -1048576;
            this.fullScreen = false;
        } else {
            this.screenPercentage = vampire.getTicksInSun() / 2;
            if (this.screenPercentage > 0) {
                MobEffectInstance effect = this.mc.f_91074_.m_21124_((MobEffect)ModEffects.SUNSCREEN.get());
                if (effect == null || effect.m_19564_() < 5) {
                    this.screenColor = -2219;
                    this.fullScreen = false;
                    if (vampire.getRepresentingPlayer().m_150110_().f_35937_ || effect != null && effect.m_19564_() >= 3) {
                        this.screenPercentage = Math.min(20, this.screenPercentage);
                    }
                    this.screenPercentage = Math.min(this.screenPercentage, (Integer)VampirismConfig.BALANCE.vpMaxYellowBorderPercentage.get());
                } else {
                    this.screenPercentage = 0;
                }
            } else {
                this.screenPercentage = 0;
            }
        }
        if (vampire.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get())) {
            float batPercentage = vampire.getActionHandler().getPercentageForAction((IAction)VampireActions.BAT.get());
            if (batPercentage < 0.2f && batPercentage > 0.0f) {
                this.screenBottomColor = -865048583;
                this.screenBottomPercentage = (int)((0.2f - batPercentage) * 1000.0f);
                this.fullScreen = false;
            } else {
                this.screenBottomPercentage = 0;
            }
        } else {
            this.screenBottomPercentage = 0;
        }
    }

    private void renderBloodFangs(@NotNull GuiGraphics graphics, int width, int height, float perc, int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 256.0f;
        float g = (float)((color & 0xFF00) >> 8) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        int left = width / 2 - 8;
        int top = height / 2 - 4;
        RenderSystem.enableBlend();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 0.7f);
        graphics.m_280218_(ICONS, left, top, 27, 0, 16, 10);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)0.8f);
        int percHeight = (int)(10.0f * perc);
        graphics.m_280218_(ICONS, left, top + (10 - percHeight), 27, 10 - percHeight, 16, percHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderStakeInstantKill(@NotNull GuiGraphics graphics, int width, int height) {
        if (this.mc.f_91066_.m_92176_().m_90612_() && this.mc.f_91072_.m_105295_() != GameType.SPECTATOR) {
            RenderSystem.blendFuncSeparate((int)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR.value, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR.value, (int)GlStateManager.SourceFactor.ONE.value, (int)GlStateManager.DestFactor.ZERO.value);
            graphics.m_280246_(0.6171875f, 0.0f, 0.0f, 1.0f);
            graphics.m_280218_(GUI_ICONS_LOCATION, (width - 15) / 2, (height - 15) / 2, 0, 0, 15, 15);
            int j = height / 2 - 7 + 16;
            int k = width / 2 - 8;
            graphics.m_280218_(GUI_ICONS_LOCATION, k, j, 68, 94, 16, 16);
            graphics.m_280218_(GUI_ICONS_LOCATION, k, j, 36, 94, 16, 4);
            graphics.m_280218_(GUI_ICONS_LOCATION, k, j, 52, 94, 17, 4);
        }
    }
}

