/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.blocks;

import de.teamlapen.vampirism.blockentity.BloodContainerBlockEntity;
import de.teamlapen.vampirism.core.ModFluids;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedBloodContainerModel
implements IDynamicBakedModel {
    public static final int FLUID_LEVELS = 14;
    public static final BakedModel[] BLOOD_FLUID_MODELS = new BakedModel[14];
    public static final BakedModel[] IMPURE_BLOOD_FLUID_MODELS = new BakedModel[14];
    private static final ItemOverrides overrideList = new CustomItemOverride();
    private final BakedModel baseModel;
    private boolean impure;
    private int fluidLevel = 0;
    private boolean item;

    public BakedBloodContainerModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public BakedBloodContainerModel(BakedModel baseModel, @NotNull FluidStack stack) {
        this.baseModel = baseModel;
        this.impure = stack.getFluid().equals(ModFluids.IMPURE_BLOOD.get());
        this.fluidLevel = Mth.m_14045_((int)(stack.getAmount() / 900), (int)1, (int)14) - 1;
        this.item = true;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return overrideList;
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.baseModel.m_213637_(state, side, rand));
        if (!this.item) {
            Integer level = (Integer)extraData.get(BloodContainerBlockEntity.FLUID_LEVEL_PROP);
            Boolean impure = (Boolean)extraData.get(BloodContainerBlockEntity.FLUID_IMPURE);
            if (impure != null && level != null && level > 0 && level <= 14) {
                quads.addAll((impure != false ? IMPURE_BLOOD_FLUID_MODELS[level - 1] : BLOOD_FLUID_MODELS[level - 1]).getQuads(state, side, rand, ModelData.EMPTY, renderType));
            }
        } else {
            quads.addAll((this.impure ? IMPURE_BLOOD_FLUID_MODELS[this.fluidLevel] : BLOOD_FLUID_MODELS[this.fluidLevel]).getQuads(state, side, rand, ModelData.EMPTY, renderType));
        }
        return quads;
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.baseModel.getRenderTypes(state, rand, data);
    }

    private static class CustomItemOverride
    extends ItemOverrides {
        CustomItemOverride() {
        }

        public BakedModel m_173464_(@NotNull BakedModel originalModel, @NotNull ItemStack stack, ClientLevel world, LivingEntity entity, int p) {
            FluidStack fluid;
            if (originalModel instanceof BakedBloodContainerModel && stack.m_41782_() && stack.m_41783_().m_128441_("fluid") && !(fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41783_().m_128469_("fluid"))).isEmpty()) {
                return new BakedBloodContainerModel(originalModel, fluid);
            }
            return originalModel;
        }
    }
}

