/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinementSet;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.player.tasks.TaskBuilder;
import de.teamlapen.vampirism.entity.player.tasks.reward.LordLevelReward;
import de.teamlapen.vampirism.entity.player.tasks.reward.RefinementItemReward;
import de.teamlapen.vampirism.entity.player.tasks.unlock.LordLvlUnlocker;
import de.teamlapen.vampirism.entity.player.tasks.unlock.LvlUnlocker;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModTasks {
    public static final DeferredRegister<Task> TASKS = DeferredRegister.create(VampirismRegistries.TASK_ID, (String)"vampirism");
    public static final RegistryObject<Task> FEEDING_ADAPTER = TASKS.register("feeding_adapter", () -> ModTasks.vampire().unlockedBy(new LvlUnlocker(4)).addRequirement("advanced_hunter", ModTags.Entities.ADVANCED_HUNTER, 10).addRequirement("item", () -> new ItemStack((ItemLike)Items.f_42417_, 5)).setReward(() -> new ItemStack((ItemLike)ModItems.FEEDING_ADAPTER.get())).build());
    public static final RegistryObject<Task> VAMPIRE_LORD1 = TASKS.register("vampire_lord1", () -> ModTasks.vampire().unlockedBy(new LvlUnlocker(VReference.VAMPIRE_FACTION.getHighestReachableLevel())).addRequirement("infect", ModStats.infected_creatures, 25).addRequirement("pure_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.get(), 5)).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 32)).addRequirement("village", ModStats.win_village_capture, 3).setUnique().setReward(new LordLevelReward(1)).build());
    public static final RegistryObject<Task> VAMPIRE_LORD2 = TASKS.register("vampire_lord2", () -> ModTasks.vampire().unlockedBy(new LordLvlUnlocker(1, true)).addRequirement("hunter", ModTags.Entities.HUNTER, 30).addRequirement("pure_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.get(), 5)).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 48)).setUnique().setReward(new LordLevelReward(2)).build());
    public static final RegistryObject<Task> VAMPIRE_LORD3 = TASKS.register("vampire_lord3", () -> ModTasks.vampire().unlockedBy(new LordLvlUnlocker(2, true)).addRequirement("hunter", ModTags.Entities.HUNTER, 30).addRequirement("pure_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.get(), 5)).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 48)).setUnique().setReward(new LordLevelReward(3)).build());
    public static final RegistryObject<Task> VAMPIRE_LORD4 = TASKS.register("vampire_lord4", () -> ModTasks.vampire().unlockedBy(new LordLvlUnlocker(3, true)).addRequirement("hunter", ModTags.Entities.ADVANCED_HUNTER, 5).addRequirement("pure_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.get(), 10)).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 64)).setUnique().setReward(new LordLevelReward(4)).build());
    public static final RegistryObject<Task> VAMPIRE_LORD5 = TASKS.register("vampire_lord5", () -> ModTasks.vampire().unlockedBy(new LordLvlUnlocker(4, true)).addRequirement("infect", ModStats.infected_creatures, 50).addRequirement("pure_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.get(), 20)).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 64)).addRequirement("village", ModStats.capture_village, 6).setUnique().setReward(new LordLevelReward(5)).build());
    public static final RegistryObject<Task> HUNTER_LORD1 = TASKS.register("hunter_lord1", () -> ModTasks.hunter().unlockedBy(new LvlUnlocker(VReference.HUNTER_FACTION.getHighestReachableLevel())).addRequirement("vampire", ModTags.Entities.VAMPIRE, 50).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 32)).addRequirement("village", ModStats.win_village_capture, 3).setUnique().setReward(new LordLevelReward(1)).build());
    public static final RegistryObject<Task> HUNTER_LORD2 = TASKS.register("hunter_lord2", () -> ModTasks.hunter().unlockedBy(new LordLvlUnlocker(1, true)).addRequirement("vampire", ModTags.Entities.VAMPIRE, 50).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 32)).setUnique().setReward(new LordLevelReward(2)).build());
    public static final RegistryObject<Task> HUNTER_LORD3 = TASKS.register("hunter_lord3", () -> ModTasks.hunter().unlockedBy(new LordLvlUnlocker(2, true)).addRequirement("vampire", ModTags.Entities.VAMPIRE, 50).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 32)).setUnique().setReward(new LordLevelReward(3)).build());
    public static final RegistryObject<Task> HUNTER_LORD4 = TASKS.register("hunter_lord4", () -> ModTasks.hunter().unlockedBy(new LordLvlUnlocker(3, true)).addRequirement("vampire", ModTags.Entities.VAMPIRE, 75).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 64)).setUnique().setReward(new LordLevelReward(4)).build());
    public static final RegistryObject<Task> HUNTER_LORD5 = TASKS.register("hunter_lord5", () -> ModTasks.hunter().unlockedBy(new LordLvlUnlocker(4, true)).addRequirement("vampire", ModTags.Entities.VAMPIRE, 100).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 64)).addRequirement("village", ModStats.capture_village, 6).setUnique().setReward(new LordLevelReward(5)).build());
    public static final RegistryObject<Task> OBLIVION_POTION = TASKS.register("oblivion_potion", () -> TaskBuilder.builder().addRequirement("poison", () -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43584_)).addRequirement("vampire_blood", () -> new ItemStack((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get())).setReward(() -> new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get())).build());

    public static void register(IEventBus bus) {
        TASKS.register(bus);
    }

    @NotNull
    private static TaskBuilder vampire() {
        return TaskBuilder.builder().withFaction(() -> VReference.VAMPIRE_FACTION);
    }

    @NotNull
    private static TaskBuilder hunter() {
        return TaskBuilder.builder().withFaction(() -> VReference.HUNTER_FACTION);
    }

    static {
        TASKS.register("fire_resistance1", () -> ModTasks.vampire().addRequirement("magma", () -> new ItemStack((ItemLike)Items.f_42542_, 3)).addRequirement("hunter", ModTags.Entities.HUNTER, 10).setReward(() -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)ModPotions.VAMPIRE_FIRE_RESISTANCE.get()))).build());
        TASKS.register("fire_resistance2", () -> ModTasks.vampire().unlockedBy(new LvlUnlocker(7)).addRequirement("magma", () -> new ItemStack((ItemLike)Items.f_42542_, 5)).addRequirement("hunter", ModTags.Entities.HUNTER, 15).setReward(() -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)ModPotions.LONG_VAMPIRE_FIRE_RESISTANCE.get()))).build());
        TASKS.register("vampire_minion_binding", () -> ModTasks.vampire().unlockedBy(new LordLvlUnlocker(1)).addRequirement("advanced_hunter", ModTags.Entities.ADVANCED_HUNTER, 4).addRequirement("baron", (EntityType)ModEntities.VAMPIRE_BARON.get(), 5).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 32)).setReward(() -> new ItemStack((ItemLike)ModItems.VAMPIRE_MINION_BINDING.get())).build());
        TASKS.register("vampire_minion_upgrade_simple", () -> ModTasks.vampire().unlockedBy(new LordLvlUnlocker(2)).addRequirement("advanced_hunter", ModTags.Entities.ADVANCED_HUNTER, 8).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_41912_, 16)).setReward(() -> new ItemStack((ItemLike)ModItems.VAMPIRE_MINION_UPGRADE_SIMPLE.get())).build());
        TASKS.register("vampire_minion_upgrade_enhanced", () -> ModTasks.vampire().unlockedBy(new LordLvlUnlocker(3)).addRequirement("baron", (EntityType)ModEntities.VAMPIRE_BARON.get(), 10).addRequirement("human_heart", () -> new ItemStack((ItemLike)ModItems.HUMAN_HEART.get(), 32)).addRequirement("book", () -> new ItemStack((ItemLike)ModItems.VAMPIRE_BOOK.get())).addRequirement("diamond", () -> new ItemStack((ItemLike)Items.f_41959_, 3)).setReward(() -> new ItemStack((ItemLike)ModItems.VAMPIRE_MINION_UPGRADE_ENHANCED.get())).build());
        TASKS.register("vampire_minion_upgrade_special", () -> ModTasks.vampire().unlockedBy(new LordLvlUnlocker(5)).addRequirement("baron", (EntityType)ModEntities.VAMPIRE_BARON.get(), 20).addRequirement("human_heart", () -> new ItemStack((ItemLike)ModItems.HUMAN_HEART.get(), 64)).addRequirement("book", () -> new ItemStack((ItemLike)ModItems.VAMPIRE_BOOK.get())).addRequirement("diamond", () -> new ItemStack((ItemLike)Items.f_41959_, 8)).setReward(() -> new ItemStack((ItemLike)ModItems.VAMPIRE_MINION_UPGRADE_SPECIAL.get())).build());
        TASKS.register("hunter_minion_equipment", () -> ModTasks.hunter().unlockedBy(new LordLvlUnlocker(1)).addRequirement("advanced_vampire", ModTags.Entities.ADVANCED_VAMPIRE, 4).addRequirement("baron", (EntityType)ModEntities.VAMPIRE_BARON.get(), 5).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 32)).setReward(() -> new ItemStack((ItemLike)ModItems.HUNTER_MINION_EQUIPMENT.get())).build());
        TASKS.register("hunter_minion_upgrade_simple", () -> ModTasks.hunter().unlockedBy(new LordLvlUnlocker(2)).addRequirement("advanced_vampire", ModTags.Entities.ADVANCED_VAMPIRE, 8).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_41912_, 16)).setReward(() -> new ItemStack((ItemLike)ModItems.HUNTER_MINION_UPGRADE_SIMPLE.get())).build());
        TASKS.register("hunter_minion_upgrade_enhanced", () -> ModTasks.hunter().unlockedBy(new LordLvlUnlocker(3)).addRequirement("baron", (EntityType)ModEntities.VAMPIRE_BARON.get(), 10).addRequirement("vampire_blood", () -> new ItemStack((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get(), 16)).addRequirement("book", () -> new ItemStack((ItemLike)ModItems.VAMPIRE_BOOK.get())).addRequirement("diamond", () -> new ItemStack((ItemLike)Items.f_41959_, 3)).setReward(() -> new ItemStack((ItemLike)ModItems.HUNTER_MINION_UPGRADE_ENHANCED.get())).build());
        TASKS.register("hunter_minion_upgrade_special", () -> ModTasks.hunter().unlockedBy(new LordLvlUnlocker(5)).addRequirement("baron", (EntityType)ModEntities.VAMPIRE_BARON.get(), 20).addRequirement("vampire_blood", () -> new ItemStack((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get(), 32)).addRequirement("book", () -> new ItemStack((ItemLike)ModItems.VAMPIRE_BOOK.get())).addRequirement("diamond", () -> new ItemStack((ItemLike)Items.f_41959_, 8)).setReward(() -> new ItemStack((ItemLike)ModItems.HUNTER_MINION_UPGRADE_SPECIAL.get())).build());
        TASKS.register("v_infect1", () -> ModTasks.vampire().addRequirement("infect", ModStats.infected_creatures, 20).setReward(() -> new ItemStack((ItemLike)Items.f_42417_, 5)).build());
        TASKS.register("v_infect2", () -> ModTasks.vampire().addRequirement("infect", ModStats.infected_creatures, 25).setReward(() -> new ItemStack((ItemLike)Items.f_42417_, 15)).build());
        TASKS.register("v_infect3", () -> ModTasks.vampire().addRequirement("infect", ModStats.infected_creatures, 15).setReward(() -> new ItemStack((ItemLike)Items.f_42416_, 5)).build());
        TASKS.register("v_capture1", () -> ModTasks.vampire().addRequirement("village", ModStats.capture_village, 1).setReward(() -> new ItemStack((ItemLike)Items.f_42616_, 10)).build());
        TASKS.register("v_capture2", () -> ModTasks.vampire().addRequirement("village", ModStats.capture_village, 1).setReward(() -> new ItemStack((ItemLike)Items.f_42616_, 5)).build());
        TASKS.register("v_kill1", () -> ModTasks.vampire().addRequirement("hunter", ModTags.Entities.HUNTER, 10).setReward(() -> new ItemStack((ItemLike)ModItems.HUMAN_HEART.get(), 5)).build());
        TASKS.register("v_kill2", () -> ModTasks.vampire().addRequirement("hunter", ModTags.Entities.ADVANCED_HUNTER, 4).setReward(() -> new ItemStack((ItemLike)ModItems.HUMAN_HEART.get(), 8)).build());
        TASKS.register("h_kill1", () -> ModTasks.hunter().addRequirement("vampire", ModTags.Entities.VAMPIRE, 20).setReward(() -> new ItemStack((ItemLike)Items.f_42415_, 2)).build());
        TASKS.register("h_kill2", () -> ModTasks.hunter().addRequirement("vampire", ModTags.Entities.VAMPIRE, 15).setReward(() -> new ItemStack((ItemLike)Items.f_42415_, 2)).build());
        TASKS.register("h_capture1", () -> ModTasks.hunter().addRequirement("village", ModStats.capture_village, 2).setReward(() -> new ItemStack((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get(), 10)).build());
        TASKS.register("break_bones1", () -> TaskBuilder.builder().addRequirement("skeleton", EntityType.f_20524_, 20).setReward(() -> new ItemStack((ItemLike)Items.f_42465_)).build());
        TASKS.register("break_bones2", () -> TaskBuilder.builder().addRequirement("skeleton", EntityType.f_20524_, 14).setReward(() -> new ItemStack((ItemLike)Items.f_42466_)).build());
        TASKS.register("break_bones3", () -> TaskBuilder.builder().addRequirement("skeleton", EntityType.f_20524_, 10).setReward(() -> new ItemStack((ItemLike)Items.f_42467_)).build());
        TASKS.register("break_bones4", () -> TaskBuilder.builder().addRequirement("skeleton", EntityType.f_20524_, 10).setReward(() -> new ItemStack((ItemLike)Items.f_42464_)).build());
        TASKS.register("totem_top", () -> TaskBuilder.builder().unlockedBy(new LvlUnlocker(5)).addRequirement("obsidian", () -> new ItemStack((ItemLike)Items.f_41999_, 32)).addRequirement("diamond", () -> new ItemStack((ItemLike)Items.f_42415_, 1)).addRequirement("zombie", ModTags.Entities.ZOMBIES, 32).setReward(() -> new ItemStack((ItemLike)ModBlocks.TOTEM_TOP_CRAFTED.get())).build());
        TASKS.register("oblivion_potion_pure_blood_1", () -> TaskBuilder.builder().unlockedBy(new LvlUnlocker(1, 3)).addRequirement("poison", () -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43584_)).addRequirement("vampire_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_0.get())).setReward(() -> new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get())).build());
        TASKS.register("oblivion_potion_pure_blood_2", () -> TaskBuilder.builder().unlockedBy(new LvlUnlocker(4, 6)).addRequirement("poison", () -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43584_)).addRequirement("vampire_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_1.get())).setReward(() -> new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get())).build());
        TASKS.register("oblivion_potion_pure_blood_3", () -> TaskBuilder.builder().unlockedBy(new LvlUnlocker(7, 9)).addRequirement("poison", () -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43584_)).addRequirement("vampire_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_2.get())).setReward(() -> new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get())).build());
        TASKS.register("oblivion_potion_pure_blood_4", () -> TaskBuilder.builder().unlockedBy(new LvlUnlocker(10, 12)).addRequirement("poison", () -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43584_)).addRequirement("vampire_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_3.get())).setReward(() -> new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get())).build());
        TASKS.register("oblivion_potion_pure_blood_5", () -> TaskBuilder.builder().unlockedBy(new LvlUnlocker(13, 14)).addRequirement("poison", () -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43584_)).addRequirement("vampire_blood", () -> new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.get())).setReward(() -> new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get())).build());
        TASKS.register("random_refinement1", () -> ModTasks.vampire().addRequirement("hunter", ModTags.Entities.ADVANCED_HUNTER, 10).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 2)).setReward(new RefinementItemReward(VReference.VAMPIRE_FACTION)).build());
        TASKS.register("random_refinement2", () -> ModTasks.vampire().addRequirement("barons", (EntityType)ModEntities.VAMPIRE_BARON.get(), 3).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 2)).setReward(new RefinementItemReward(VReference.VAMPIRE_FACTION)).build());
        TASKS.register("random_refinement3", () -> ModTasks.vampire().addRequirement("trades", Stats.f_12941_, 15).addRequirement("gold", () -> new ItemStack((ItemLike)Items.f_42417_, 2)).setReward(new RefinementItemReward(VReference.VAMPIRE_FACTION)).build());
        TASKS.register("random_rare_refinement", () -> ModTasks.vampire().addRequirement("raid", Stats.f_12950_, 1).setReward(new RefinementItemReward(VReference.VAMPIRE_FACTION, IRefinementSet.Rarity.RARE)).build());
    }
}

