/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.BiteableEntry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedCreature
implements ISyncable.ISyncableEntityCapabilityInst,
IExtendedCreatureVampirism {
    private static final String KEY_BLOOD = "bloodLevel";
    private static final String KEY_MAX_BLOOD = "maxBlood";
    private static final String POISONOUS_BLOOD = "poisonousBlood";
    public static final Capability<IExtendedCreatureVampirism> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IExtendedCreatureVampirism>(){});
    private final PathfinderMob entity;
    private final boolean canBecomeVampire;
    private boolean poisonousBlood;
    private boolean markForBloodCalculation = false;
    private int maxBlood;
    private int blood;
    private int remainingBarkTicks;

    @NotNull
    public static LazyOptional<IExtendedCreatureVampirism> getSafe(@NotNull Entity mob) {
        return mob.getCapability(CAP);
    }

    @NotNull
    static <Q extends PathfinderMob> ICapabilityProvider createNewCapability(final Q creature) {
        return new ICapabilitySerializable<CompoundTag>(){
            @Nullable
            final Function<Q, IExtendedCreatureVampirism> constructor;
            final IExtendedCreatureVampirism inst;
            final LazyOptional<IExtendedCreatureVampirism> opt;
            {
                this.constructor = VampirismAPI.entityRegistry().getCustomExtendedCreatureConstructor(creature);
                this.inst = this.constructor == null ? new ExtendedCreature(creature) : this.constructor.apply(creature);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadData(nbt);
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            @NotNull
            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveData(tag);
                return tag;
            }
        };
    }

    public ExtendedCreature(PathfinderMob entity) {
        this.entity = entity;
        BiteableEntry entry = VampirismAPI.entityRegistry().getEntry(entity);
        if (entry != null && entry.blood > 0) {
            this.maxBlood = entry.blood;
            this.canBecomeVampire = entry.convertible;
        } else {
            if (entry == null) {
                this.markForBloodCalculation = true;
            }
            this.maxBlood = -1;
            this.canBecomeVampire = false;
        }
        this.blood = this.maxBlood;
        this.poisonousBlood = false;
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return this.getBlood() > 0;
    }

    @Override
    public boolean canBecomeVampire() {
        return this.canBecomeVampire;
    }

    @Override
    public int getBlood() {
        return this.blood;
    }

    @Override
    public void setBlood(int blood) {
        if (blood >= 0 && blood <= this.getMaxBlood() && this.getBlood() != -1) {
            this.blood = blood;
        }
    }

    @Override
    public float getBloodLevelRelative() {
        return (float)this.getBlood() / (float)this.getMaxBlood();
    }

    @Override
    public float getBloodSaturation() {
        return 1.0f;
    }

    @Override
    @NotNull
    public ResourceLocation getCapKey() {
        return REFERENCE.EXTENDED_CREATURE_KEY;
    }

    @Override
    public PathfinderMob getEntity() {
        return this.entity;
    }

    @Override
    public int getMaxBlood() {
        return this.maxBlood;
    }

    private void setMaxBlood(int blood) {
        this.maxBlood = blood;
        this.blood = blood;
    }

    @Override
    public int getTheEntityID() {
        return this.entity.m_19879_();
    }

    @Override
    public boolean hasPoisonousBlood() {
        return this.poisonousBlood;
    }

    @Override
    public void loadUpdateFromNBT(@NotNull CompoundTag nbt) {
        if (nbt.m_128441_(KEY_BLOOD)) {
            this.setBlood(nbt.m_128451_(KEY_BLOOD));
        }
        if (nbt.m_128441_(KEY_MAX_BLOOD)) {
            this.setBlood(nbt.m_128451_(KEY_MAX_BLOOD));
        }
        if (nbt.m_128441_(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(nbt.m_128471_(POISONOUS_BLOOD));
        }
    }

    @Override
    @Nullable
    public IConvertedCreature<?> makeVampire() {
        if (this.canBecomeVampire()) {
            this.blood = -1;
            IConvertedCreature<?> c = VampirismAPI.entityRegistry().convert(this.entity);
            if (c != null) {
                UtilLib.replaceEntity((LivingEntity)this.entity, (LivingEntity)((PathfinderMob)c));
            }
            return c;
        }
        return null;
    }

    @Override
    public boolean canBeInfected(IVampire vampire) {
        return this.canBecomeVampire && !this.hasPoisonousBlood() && !this.entity.m_21023_((MobEffect)ModEffects.SANGUINARE.get());
    }

    @Override
    public boolean tryInfect(IVampire vampire) {
        if (this.canBeInfected(vampire)) {
            SanguinareEffect.addRandom((LivingEntity)this.entity, false);
            return true;
        }
        return false;
    }

    @Override
    public int onBite(IVampire biter) {
        if (this.getBlood() <= 0) {
            return 0;
        }
        int amt = Math.max(1, this.getMaxBlood() / (biter instanceof VampirePlayer ? 6 : 2));
        if (amt >= this.blood) {
            amt = this.blood > 1 && biter.isAdvancedBiter() ? this.blood - 1 : this.blood;
        }
        this.blood -= amt;
        if (this.blood == 0) {
            DamageHandler.hurtModded((Entity)this.entity, ModDamageSources::noBlood, 1000.0f);
        }
        this.sync();
        this.entity.m_6703_(biter.getRepresentingEntity());
        if (this.entity instanceof AgeableMob && ((AgeableMob)this.entity).m_146764_() < 0) {
            amt = Math.round((float)amt / 3.0f);
        }
        if (biter.isAdvancedBiter() && this.entity.m_217043_().m_188503_(4) == 0) {
            amt = 2 * amt;
        }
        return amt;
    }

    @Override
    public void setPoisonousBlood(boolean poisonous) {
        if (poisonous == !this.poisonousBlood) {
            this.poisonousBlood = poisonous;
            this.sync();
        }
    }

    public int getRemainingBarkTicks() {
        return this.remainingBarkTicks;
    }

    public void increaseRemainingBarkTicks(int additionalBarkTicks) {
        this.remainingBarkTicks += additionalBarkTicks;
    }

    @Override
    public void tick() {
        if (!this.entity.m_20193_().f_46443_) {
            if (this.blood == 0 && this.entity.f_19797_ % 20 == 10 && this.entity.m_21124_((MobEffect)ModEffects.SANGUINARE.get()) == null) {
                DamageHandler.hurtModded((Entity)this.entity, ModDamageSources::noBlood, 1000.0f);
            }
            if (this.blood > 0 && this.blood < this.getMaxBlood() && this.entity.f_19797_ % 40 == 8) {
                this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 41));
                this.entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 41, 2));
                if (this.entity.m_217043_().m_188503_(BalanceMobProps.mobProps.BLOOD_REGEN_CHANCE) == 0) {
                    this.setBlood(this.getBlood() + 1);
                    this.sync();
                }
            }
        }
        if (this.markForBloodCalculation && VampirismEntityRegistry.biteableEntryManager.init()) {
            BiteableEntry entry = VampirismEntityRegistry.biteableEntryManager.calculate(this.entity);
            if (entry != null) {
                this.setMaxBlood(entry.blood);
            }
            this.markForBloodCalculation = false;
        }
        if (this.remainingBarkTicks > 0) {
            --this.remainingBarkTicks;
        }
    }

    @NotNull
    public String toString() {
        return super.toString() + " for entity (" + this.entity.toString() + ") [B" + this.blood + ",MB" + this.maxBlood + ",CV" + this.canBecomeVampire + "]";
    }

    @Override
    public void writeFullUpdateToNBT(@NotNull CompoundTag nbt) {
        nbt.m_128405_(KEY_BLOOD, this.getBlood());
        nbt.m_128405_(KEY_MAX_BLOOD, this.getBlood());
        nbt.m_128379_(POISONOUS_BLOOD, this.hasPoisonousBlood());
    }

    @Override
    public void loadData(@NotNull CompoundTag compound) {
        if (compound.m_128441_(KEY_MAX_BLOOD)) {
            this.setMaxBlood(compound.m_128451_(KEY_MAX_BLOOD));
        }
        if (compound.m_128441_(KEY_BLOOD)) {
            this.setBlood(compound.m_128451_(KEY_BLOOD));
        }
        if (compound.m_128441_(POISONOUS_BLOOD)) {
            this.setPoisonousBlood(compound.m_128471_(POISONOUS_BLOOD));
        }
    }

    @Override
    public void saveData(@NotNull CompoundTag compound) {
        compound.m_128405_(KEY_BLOOD, this.blood);
        compound.m_128405_(KEY_MAX_BLOOD, this.maxBlood);
        compound.m_128379_(POISONOUS_BLOOD, this.poisonousBlood);
    }

    public void sync() {
        HelperLib.sync(this, (Entity)this.getEntity(), false);
    }

    private void sync(@NotNull CompoundTag data) {
        HelperLib.sync(this, data, (Entity)this.getEntity(), false);
    }
}

