/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultConvertingHandler<T extends PathfinderMob>
implements IConvertingHandler<T> {
    private static final IConvertingHandler.IDefaultHelper defaultHelper = new IConvertingHandler.IDefaultHelper(){

        @Override
        public double getConvertedDMG(@NotNull EntityType<? extends PathfinderMob> entityType) {
            AttributeSupplier map = DefaultAttributes.m_22297_(entityType);
            if (map.m_22258_(Attributes.f_22281_)) {
                return map.m_22253_(Attributes.f_22281_) * 1.3;
            }
            return BalanceMobProps.mobProps.CONVERTED_MOB_DEFAULT_DMG;
        }

        @Override
        public double getConvertedKnockbackResistance(@NotNull EntityType<? extends PathfinderMob> entityType) {
            AttributeSupplier map = DefaultAttributes.m_22297_(entityType);
            return map.m_22253_(Attributes.f_22278_) * 1.3;
        }

        @Override
        public double getConvertedMaxHealth(@NotNull EntityType<? extends PathfinderMob> entityType) {
            AttributeSupplier map = DefaultAttributes.m_22297_(entityType);
            return map.m_22253_(Attributes.f_22276_) * 1.5;
        }

        @Override
        public double getConvertedSpeed(@NotNull EntityType<? extends PathfinderMob> entityType) {
            AttributeSupplier map = DefaultAttributes.m_22297_(entityType);
            return Math.min(map.m_22253_(Attributes.f_22279_) * 1.2, 2.9);
        }
    };
    @NotNull
    protected final IConvertingHandler.IDefaultHelper helper;

    public DefaultConvertingHandler(@Nullable IConvertingHandler.IDefaultHelper helper) {
        this.helper = Objects.requireNonNullElse(helper, defaultHelper);
    }

    @Override
    @Nullable
    public IConvertedCreature<T> createFrom(@NotNull T entity) {
        return Helper.createEntity((EntityType)ModEntities.CONVERTED_CREATURE.get(), entity.m_20193_()).map(convertedCreature -> {
            this.copyImportantStuff((ConvertedCreatureEntity<T>)convertedCreature, entity);
            convertedCreature.m_20084_(Mth.m_216261_((RandomSource)convertedCreature.m_217043_()));
            convertedCreature.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 2));
            return convertedCreature;
        }).orElse(null);
    }

    public IConvertingHandler.IDefaultHelper getHelper() {
        return this.helper;
    }

    protected void copyImportantStuff(@NotNull ConvertedCreatureEntity<T> converted, @NotNull T entity) {
        converted.m_20359_((Entity)entity);
        converted.setEntityCreature(entity);
        converted.updateEntityAttributes();
        converted.m_21153_(converted.m_21233_() / 3.0f * 2.0f);
        converted.f_20883_ = ((PathfinderMob)entity).f_20883_;
        converted.f_20885_ = ((PathfinderMob)entity).f_20885_;
    }
}

