/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks;

import com.google.common.base.Objects;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskInstance;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.entity.player.TaskManager;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskInstance
implements ITaskInstance {
    @NotNull
    private final UUID taskGiver;
    @NotNull
    private final Task task;
    @NotNull
    private final UUID instanceId;
    @NotNull
    private final Map<ResourceLocation, Integer> stats;
    @NotNull
    private final ITaskRewardInstance reward;
    private final long taskDuration;
    private boolean accepted;
    private long taskTimeStamp;
    private boolean completed;

    @Nullable
    public static TaskInstance readNBT(@NotNull CompoundTag nbt) {
        Task task = RegUtil.getTask(new ResourceLocation(nbt.m_128461_("task")));
        if (task == null) {
            return null;
        }
        UUID id = nbt.m_128342_("id");
        UUID insId = nbt.m_128342_("insId");
        boolean accepted = nbt.m_128471_("accepted");
        long taskTimer = nbt.m_128454_("taskTimer");
        CompoundTag statsNBT = nbt.m_128469_("stats");
        HashMap<ResourceLocation, Integer> stats = new HashMap<ResourceLocation, Integer>();
        statsNBT.m_128431_().forEach(name -> stats.put(new ResourceLocation(name), statsNBT.m_128451_(name)));
        ResourceLocation rewardId = new ResourceLocation(nbt.m_128461_("rewardId"));
        ITaskRewardInstance reward = TaskManager.createReward(rewardId, nbt);
        long taskDuration = nbt.m_128454_("taskDuration");
        return new TaskInstance(id, task, stats, accepted, taskTimer, insId, reward, taskDuration);
    }

    @NotNull
    public static TaskInstance decode(@NotNull FriendlyByteBuf buffer) {
        UUID id = buffer.m_130259_();
        Task task = RegUtil.getTask(buffer.m_130281_());
        UUID insId = buffer.m_130259_();
        boolean accepted = buffer.readBoolean();
        long taskTimer = buffer.m_130258_();
        int statsAmount = buffer.m_130242_();
        HashMap<ResourceLocation, Integer> stats = new HashMap<ResourceLocation, Integer>();
        for (int i = 0; i < statsAmount; ++i) {
            stats.put(buffer.m_130281_(), buffer.m_130242_());
        }
        ResourceLocation rewardId = buffer.m_130281_();
        ITaskRewardInstance reward = TaskManager.createReward(rewardId, buffer);
        long taskDuration = buffer.m_130258_();
        return new TaskInstance(id, task, stats, accepted, taskTimer, insId, reward, taskDuration);
    }

    public TaskInstance(@NotNull Task task, @NotNull UUID taskGiver, @NotNull IFactionPlayer<?> player, long taskDuration) {
        this.task = task;
        this.taskGiver = taskGiver;
        this.instanceId = UUID.randomUUID();
        this.stats = new HashMap<ResourceLocation, Integer>();
        this.taskTimeStamp = -1L;
        this.taskDuration = taskDuration;
        this.reward = this.task.getReward().createInstance(player);
    }

    private TaskInstance(@NotNull UUID taskGiver, @NotNull Task task, @NotNull Map<ResourceLocation, Integer> stats, boolean accepted, long taskTimeStamp, @NotNull UUID instanceId, @NotNull ITaskRewardInstance taskRewardInstance, long taskDuration) {
        this.taskGiver = taskGiver;
        this.task = task;
        this.stats = new HashMap<ResourceLocation, Integer>(stats);
        this.accepted = accepted;
        this.taskTimeStamp = taskTimeStamp;
        this.instanceId = instanceId;
        this.reward = taskRewardInstance;
        this.taskDuration = taskDuration;
    }

    @Override
    public void aboardTask() {
        this.accepted = false;
        this.stats.clear();
        this.taskTimeStamp = -1L;
    }

    @Override
    public void complete() {
        this.completed = true;
    }

    @Override
    public void encode(@NotNull FriendlyByteBuf buffer) {
        buffer.m_130077_(this.taskGiver);
        buffer.m_130085_(RegUtil.id(this.task));
        buffer.m_130077_(this.instanceId);
        buffer.writeBoolean(this.accepted);
        buffer.m_130103_(this.taskTimeStamp);
        buffer.m_130130_(this.stats.size());
        this.stats.forEach((loc, val) -> {
            buffer.m_130085_(loc);
            buffer.m_130130_(val.intValue());
        });
        buffer.m_130085_(this.reward.getId());
        this.reward.encode(buffer);
        buffer.m_130103_(this.taskDuration);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskInstance instance = (TaskInstance)o;
        return this.accepted == instance.accepted && this.taskTimeStamp == instance.taskTimeStamp && Objects.equal((Object)this.taskGiver, (Object)instance.taskGiver) && Objects.equal((Object)this.instanceId, (Object)instance.instanceId) && Objects.equal((Object)this.task, (Object)instance.task) && Objects.equal(this.stats, instance.stats);
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.instanceId;
    }

    @Override
    @NotNull
    public ITaskRewardInstance getReward() {
        return this.reward;
    }

    @Override
    @NotNull
    public Map<ResourceLocation, Integer> getStats() {
        return this.stats;
    }

    @Override
    @NotNull
    public Task getTask() {
        return this.task;
    }

    @Override
    @NotNull
    public UUID getTaskBoard() {
        return this.taskGiver;
    }

    @Override
    public long getTaskDuration() {
        return this.taskDuration;
    }

    @Override
    public long getTaskTimeStamp() {
        return this.taskTimeStamp;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.taskGiver, this.task, this.instanceId});
    }

    @Override
    public boolean isAccepted() {
        return this.accepted;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isUnique() {
        return this.task.isUnique();
    }

    @Override
    public void startTask(long timestamp) {
        this.taskTimeStamp = timestamp;
        this.accepted = true;
    }

    @Override
    @NotNull
    public CompoundTag writeNBT(@NotNull CompoundTag nbt) {
        nbt.m_128362_("id", this.taskGiver);
        nbt.m_128359_("task", RegUtil.id(this.task).toString());
        nbt.m_128362_("insId", this.instanceId);
        nbt.m_128379_("accepted", this.accepted);
        nbt.m_128356_("taskTimer", this.taskTimeStamp);
        CompoundTag stats = new CompoundTag();
        this.stats.forEach((loc, amount) -> stats.m_128405_(loc.toString(), amount.intValue()));
        nbt.m_128365_("stats", (Tag)stats);
        nbt.m_128359_("rewardId", this.reward.getId().toString());
        this.reward.writeNBT(nbt);
        nbt.m_128356_("taskDuration", this.taskDuration);
        return nbt;
    }
}

