/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponTableCraftingSlot
extends Slot {
    private final Player player;
    private final ContainerLevelAccess worldPos;
    private final CraftingContainer craftMatrix;
    private int amountCrafted = 0;

    public WeaponTableCraftingSlot(Player player, CraftingContainer craftingInventory, @NotNull Container inventoryIn, int index, int xPosition, int yPosition, ContainerLevelAccess worldPosCallable) {
        super(inventoryIn, index, xPosition, yPosition);
        this.player = player;
        this.craftMatrix = craftingInventory;
        this.worldPos = worldPosCallable;
    }

    public boolean m_5857_(@Nullable ItemStack stack) {
        return false;
    }

    public void m_142406_(@NotNull Player playerIn, @NotNull ItemStack stack) {
        this.m_5845_(stack);
        int lava = (Integer)this.worldPos.m_39299_((world, blockPos) -> {
            if (world.m_8055_(blockPos).m_60734_() instanceof WeaponTableBlock) {
                return (Integer)world.m_8055_(blockPos).m_61143_((Property)WeaponTableBlock.LAVA);
            }
            return 0;
        }, (Object)0);
        IWeaponTableRecipe recipe = HunterPlayer.getOpt(playerIn).map(hunterPlayer -> this.findMatchingRecipe(playerIn, (IFactionPlayer<IHunterPlayer>)hunterPlayer, lava)).orElse(null);
        if (recipe != null && recipe.getRequiredLavaUnits() > 0) {
            this.worldPos.m_39292_((world, pos) -> {
                int remainingLava = Math.max(0, lava - recipe.getRequiredLavaUnits());
                BlockState state = world.m_8055_(pos);
                if (state.m_60734_() instanceof WeaponTableBlock) {
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)WeaponTableBlock.LAVA, (Comparable)Integer.valueOf(remainingLava)));
                }
            });
        }
        ForgeHooks.setCraftingPlayer((Player)playerIn);
        NonNullList remaining = playerIn.m_9236_().m_7465_().m_44069_((RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get(), (Container)this.craftMatrix, playerIn.m_9236_());
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack itemstack = this.craftMatrix.m_8020_(i);
            ItemStack itemstack1 = (ItemStack)remaining.get(i);
            if (!itemstack.m_41619_()) {
                this.craftMatrix.m_7407_(i, 1);
                itemstack = this.craftMatrix.m_8020_(i);
            }
            if (itemstack1.m_41619_()) continue;
            if (itemstack.m_41619_()) {
                this.craftMatrix.m_6836_(i, itemstack1);
                continue;
            }
            if (ItemStack.m_41656_((ItemStack)itemstack, (ItemStack)itemstack1) && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)itemstack1)) {
                itemstack1.m_41769_(itemstack.m_41613_());
                this.craftMatrix.m_6836_(i, itemstack1);
                continue;
            }
            if (this.player.m_150109_().m_36054_(itemstack1)) continue;
            this.player.m_36176_(itemstack1, false);
        }
        this.worldPos.m_39292_((world, pos) -> {
            if (recipe != null && !world.f_46443_) {
                world.m_46796_(1030, pos, 0);
            }
        });
        playerIn.m_36220_(ModStats.weapon_table);
    }

    @NotNull
    public ItemStack m_6201_(int amount) {
        if (this.m_6657_()) {
            this.amountCrafted += Math.min(amount, this.m_7993_().m_41613_());
        }
        return super.m_6201_(amount);
    }

    protected void m_5845_(@NotNull ItemStack stack) {
        if (this.amountCrafted > 0) {
            stack.m_41678_(this.player.m_20193_(), this.player, this.amountCrafted);
        }
        this.amountCrafted = 0;
    }

    @Nullable
    protected IWeaponTableRecipe findMatchingRecipe(@NotNull Player playerIn, @NotNull IFactionPlayer<IHunterPlayer> factionPlayer, int lava) {
        Optional optional = playerIn.m_20193_().m_7465_().m_44015_((RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get(), (Container)this.craftMatrix, playerIn.m_20193_());
        if (optional.isPresent()) {
            IWeaponTableRecipe recipe = (IWeaponTableRecipe)optional.get();
            if (factionPlayer.getLevel() >= recipe.getRequiredLevel() && lava >= recipe.getRequiredLavaUnits() && Helper.areSkillsEnabled(factionPlayer.getSkillHandler(), recipe.getRequiredSkills())) {
                return recipe;
            }
        }
        return null;
    }

    protected void m_7169_(@NotNull ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.m_5845_(stack);
    }
}

