/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.client.model.armor.ClothingBootsModel;
import de.teamlapen.vampirism.client.model.armor.ClothingCrownModel;
import de.teamlapen.vampirism.client.model.armor.ClothingPantsModel;
import de.teamlapen.vampirism.client.model.armor.DummyClothingModel;
import de.teamlapen.vampirism.client.model.armor.VampireHatModel;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireClothingItem
extends ArmorItem
implements IFactionExclusiveItem {
    public static final de.teamlapen.vampirism.util.ArmorMaterial VAMPIRE_CLOTH = new de.teamlapen.vampirism.util.ArmorMaterial("vampire_cloth", 15, de.teamlapen.vampirism.util.ArmorMaterial.createReduction(1, 2, 3, 1), 15, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_204132_(ModTags.Items.HEART));

    public VampireClothingItem(@NotNull ArmorItem.Type type) {
        super((ArmorMaterial)VAMPIRE_CLOTH, type, new Item.Properties().m_41499_(ArmorMaterials.IRON.m_266425_(type)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        this.addFactionToolTips(stack, worldIn, tooltip, flagIn, VampirismMod.proxy.getClientPlayer());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return switch (RegUtil.id((Item)VampireClothingItem.this).m_135815_()) {
                    case "vampire_clothing_crown" -> ClothingCrownModel.getAdjustedInstance(original);
                    case "vampire_clothing_legs" -> ClothingPantsModel.getAdjustedInstance(original);
                    case "vampire_clothing_boots" -> ClothingBootsModel.getAdjustedInstance(original);
                    case "vampire_clothing_hat" -> VampireHatModel.getAdjustedInstance(original);
                    default -> DummyClothingModel.getAdjustedInstance(original);
                };
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return String.format("vampirism:textures/models/armor/%s.png", RegUtil.id((Item)this).m_135815_());
    }

    @Override
    @Nullable
    public IFaction<?> getExclusiveFaction(@NotNull ItemStack stack) {
        return VReference.VAMPIRE_FACTION;
    }

    public void onArmorTick(ItemStack stack, Level world, @NotNull Player player) {
        super.onArmorTick(stack, world, player);
        if (player.f_19797_ % 16 == 8 && !Helper.isVampire(player)) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.POISON.get(), 20, 1));
        }
        if (stack.m_41720_() == ModItems.VAMPIRE_CLOTHING_CROWN.get() && stack.m_41788_() && "10000000".equals(stack.m_41786_().getString())) {
            UtilLib.spawnParticlesAroundEntity((LivingEntity)player, (ParticleOptions)ParticleTypes.f_175830_, 0.5, 4);
            if (player.f_19797_ % 16 == 4) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 30, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 2));
            }
        }
    }
}

