/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks.entity;

import de.teamlapen.lib.lib.blockentity.InventoryBlockEntity;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.blocks.StoneAltarBlock;
import de.teamlapen.werewolves.blocks.StoneAltarFireBowlBlock;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfLevelConf;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.inventory.container.StoneAltarContainer;
import de.teamlapen.werewolves.util.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoneAltarBlockEntity
extends InventoryBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component NAME = Component.m_237115_((String)"container.werewolves.stone_altar");
    private int targetLevel;
    private Phase phase = Phase.NOT_RUNNING;
    private Player player;
    private UUID playerUuid;
    private int ticks;
    private final LazyOptional<IItemHandler> itemHandlerOptional = LazyOptional.of(() -> this.createWrapper());
    private List<BlockPos> fire_bowls;

    public StoneAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.STONE_ALTAR.get(), pos, state, 2, StoneAltarContainer.SELECTOR_INFOS);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StoneAltarBlockEntity blockEntity) {
        if (level != null && !level.f_46443_) {
            if (blockEntity.playerUuid != null) {
                if (!blockEntity.loadRitual(blockEntity.playerUuid)) {
                    return;
                }
                blockEntity.playerUuid = null;
                blockEntity.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
            switch (blockEntity.phase) {
                case STARTING: {
                    if (blockEntity.ticks != 0) break;
                    blockEntity.phase = Phase.FOG;
                    blockEntity.ticks = 300;
                    blockEntity.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    break;
                }
                case FOG: {
                    if (blockEntity.ticks == 0) {
                        blockEntity.phase = Phase.ENDING;
                        blockEntity.ticks = 90;
                        blockEntity.player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 120, 3, false, false));
                        blockEntity.m_6596_();
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)StoneAltarBlock.LIT, (Comparable)Boolean.valueOf(false)));
                        break;
                    }
                    if (blockEntity.ticks % 10 != 0) break;
                    ModParticles.spawnParticlesServer((Level)level, (ParticleOptions)ParticleTypes.f_123757_, (double)((double)pos.m_123341_() + Math.random()), (double)(pos.m_123342_() + 1), (double)((double)pos.m_123343_() + Math.random()), (int)30, (double)0.6, (double)0.6, (double)0.6, (double)0.0);
                    if (blockEntity.fire_bowls == null) break;
                    for (BlockPos fire_bowl : blockEntity.fire_bowls) {
                        ModParticles.spawnParticlesServer((Level)level, (ParticleOptions)ParticleTypes.f_123757_, (double)((double)fire_bowl.m_123341_() + Math.random()), (double)(fire_bowl.m_123342_() + 1), (double)((double)fire_bowl.m_123343_() + Math.random()), (int)30, (double)0.6, (double)0.6, (double)0.6, (double)0.0);
                    }
                    break;
                }
                case ENDING: {
                    if (blockEntity.ticks != 0) break;
                    blockEntity.phase = Phase.NOT_RUNNING;
                    blockEntity.endRitual();
                    blockEntity.cleanup();
                    blockEntity.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    break;
                }
                case NOT_RUNNING: {
                    return;
                }
            }
            --blockEntity.ticks;
        }
    }

    public void aboardRitual() {
        this.phase = Phase.NOT_RUNNING;
        this.ticks = 0;
        this.cleanup();
    }

    public boolean loadRitual(UUID playerUuid) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_6907_().size() == 0) {
            return false;
        }
        this.player = this.f_58857_.m_46003_(playerUuid);
        if (this.player == null || !this.player.m_6084_()) {
            this.phase = Phase.NOT_RUNNING;
            this.ticks = 0;
            LOGGER.warn("Failed to find player {}", (Object)playerUuid);
            return false;
        }
        this.targetLevel = WerewolfPlayer.get(this.player).getLevel() + 1;
        return true;
    }

    public void startRitual(BlockState state) {
        if (this.player == null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)StoneAltarBlock.LIT, (Comparable)Boolean.valueOf(false)), 11);
            return;
        }
        if (this.phase == Phase.NOT_RUNNING && ((Boolean)state.m_61143_((Property)StoneAltarBlock.LIT)).booleanValue()) {
            this.phase = Phase.STARTING;
            this.ticks = 40;
            this.consumeItems();
            this.m_6596_();
        }
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void m_6836_(int slot, @Nonnull ItemStack stack) {
        super.m_6836_(slot, stack);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
    }

    public void cleanup() {
        this.targetLevel = 0;
        this.player = null;
    }

    public void endRitual() {
        WerewolfPlayer.getOpt(this.player).ifPresent(werewolf -> {
            werewolf.getLevelHandler().reset();
            werewolf.syncLevelHandler();
        });
        FactionPlayerHandler handler = FactionPlayerHandler.get((Player)this.player);
        int lvl = handler.getCurrentLevel() + 1;
        handler.setFactionLevel(WReference.WEREWOLF_FACTION, lvl);
    }

    public void consumeItems() {
        WerewolfLevelConf.StoneAltarRequirement requirement = (WerewolfLevelConf.StoneAltarRequirement)WerewolfLevelConf.getInstance().getRequirement(FactionPlayerHandler.get((Player)this.player).getCurrentLevel() + 1);
        this.m_8020_(0).m_41774_(requirement.liverAmount);
        this.m_8020_(1).m_41774_(requirement.bonesAmount);
    }

    public Phase getCurrentPhase() {
        return this.phase;
    }

    public Result canActivate(Player player) {
        if (this.phase != Phase.NOT_RUNNING) {
            return Result.IS_RUNNING;
        }
        if (!Helper.isWerewolf(player)) {
            return Result.OTHER_FACTION;
        }
        this.targetLevel = WerewolfPlayer.get(player).getLevel() + 1;
        if (!this.checkLevel(this.targetLevel)) {
            return Result.WRONG_LEVEL;
        }
        Result r = this.checkStructure();
        if (r != null) {
            return r;
        }
        if (player.m_20193_().m_46461_()) {
            return Result.NIGHT_ONLY;
        }
        if (!this.checkItemRequirements(player)) {
            return Result.INV_MISSING;
        }
        if (!WerewolfPlayer.getOpt(player).map(w -> w.getLevelHandler().canLevelUp()).orElse(false).booleanValue() && !VampirismMod.inDev) {
            return Result.TO_LESS_BLOOD;
        }
        return Result.OK;
    }

    private Result checkStructure() {
        ArrayList<BlockPos> i = new ArrayList<BlockPos>();
        ArrayList<BlockPos> h = new ArrayList<BlockPos>();
        AABB aabb = new AABB(this.f_58858_).m_82400_(3.0);
        for (double x = aabb.f_82288_; x <= aabb.f_82291_; x += 1.0) {
            for (double y = aabb.f_82289_; y <= aabb.f_82292_; y += 1.0) {
                for (double z = aabb.f_82290_; z <= aabb.f_82293_; z += 1.0) {
                    BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
                    BlockState state = this.f_58857_.m_8055_(pos);
                    if (state.m_60734_() != ModBlocks.STONE_ALTAR_FIRE_BOWL.get()) continue;
                    i.add(pos);
                    if (!((Boolean)state.m_61143_((Property)StoneAltarFireBowlBlock.LIT)).booleanValue()) continue;
                    h.add(pos);
                }
            }
        }
        if (h.size() >= 4) {
            this.fire_bowls = h;
            return null;
        }
        if (i.size() >= 4) {
            return Result.STRUCTURE_LIT;
        }
        return Result.STRUCTURE_LESS;
    }

    private boolean checkLevel(int targetLevel) {
        return targetLevel >= 2 && targetLevel <= 14;
    }

    private boolean checkItemRequirements(Player player) {
        WerewolfLevelConf.StoneAltarRequirement req = (WerewolfLevelConf.StoneAltarRequirement)WerewolfLevelConf.getInstance().getRequirement(this.targetLevel);
        ItemStack missing = InventoryHelper.checkItems((Container)this, (Item[])new Item[]{(Item)ModItems.LIVER.get(), (Item)ModItems.CRACKED_BONE.get()}, (int[])new int[]{req.liverAmount, req.bonesAmount});
        return missing.m_41619_();
    }

    public Map<Item, Integer> getMissingItems() {
        WerewolfLevelConf.StoneAltarRequirement req = (WerewolfLevelConf.StoneAltarRequirement)WerewolfLevelConf.getInstance().getRequirement(this.targetLevel);
        return Helper.getMissingItems((Container)this, new Item[]{(Item)ModItems.LIVER.get(), (Item)ModItems.CRACKED_BONE.get()}, new int[]{req.liverAmount, req.bonesAmount});
    }

    @Nonnull
    protected Component m_6820_() {
        return NAME;
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int id, @Nonnull Inventory playerInventory) {
        return new StoneAltarContainer(id, playerInventory, (Container)this, this.f_58857_ == null ? ContainerLevelAccess.f_39287_ : ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void m_142466_(@Nonnull CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        if (tagCompound.m_128403_("player")) {
            UUID playerUuid = tagCompound.m_128342_("player");
            if (!this.loadRitual(playerUuid)) {
                this.playerUuid = playerUuid;
            }
            this.ticks = tagCompound.m_128451_("ticks");
            this.phase = Phase.valueOf(tagCompound.m_128461_("phase"));
        }
    }

    public void m_183515_(CompoundTag compound) {
        if (this.player != null) {
            compound.m_128362_("player", this.player.m_20148_());
        }
        compound.m_128405_("ticks", this.ticks);
        compound.m_128359_("phase", this.phase.name());
        super.m_183515_(compound);
    }

    public static enum Phase {
        NOT_RUNNING,
        STARTING,
        FOG,
        ENDING;

    }

    public static enum Result {
        IS_RUNNING,
        OK,
        WRONG_LEVEL,
        NIGHT_ONLY,
        INV_MISSING,
        OTHER_FACTION,
        STRUCTURE_LESS,
        STRUCTURE_LIT,
        TO_LESS_BLOOD;

    }
}

