/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui.overlay;

import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.mixin.client.InGameGuiAccessor;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class WerewolfFormDurationOverlay
implements IGuiOverlay {
    private final Minecraft mc = Minecraft.m_91087_();
    public static final ResourceLocation ICONS = new ResourceLocation("textures/gui/icons.png");

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        LocalPlayer player = this.mc.f_91074_;
        if (Helper.isWerewolf((Player)player)) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)player);
            if (werewolf.getSpecialAttributes().transformationTime > 0.0) {
                double perc = 1.0 - werewolf.getSpecialAttributes().transformationTime;
                float trans = FormHelper.getActiveFormAction(werewolf).map(WerewolfFormAction::consumesWerewolfTime).orElse(false) != false ? 1.0f : 0.7f;
                this.renderExpBar(graphics, perc, trans);
            }
        }
    }

    private void renderExpBar(GuiGraphics graphics, double perc, float transparency) {
        int scaledWidth = ((InGameGuiAccessor)Minecraft.m_91087_().f_91065_).getScaledWidth();
        int scaledHeight = ((InGameGuiAccessor)Minecraft.m_91087_().f_91065_).getScaledHeight();
        int x = scaledWidth / 2 - 91;
        graphics.m_280246_(1.0f, 0.1f, 0.0f, transparency);
        int k = (int)((1.0 - perc) * 183.0);
        int l = scaledHeight - 32 + 3;
        graphics.m_280218_(ICONS, x, l, 0, 64, 182, 5);
        graphics.m_280218_(ICONS, x + k, l, k, 69, 182 - k, 5);
    }
}

