/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WerewolfBeastModel<T extends LivingEntity>
extends WerewolfBaseModel<T> {
    public static final String BODY = "body";
    public static final String HIP = "hip";
    public static final String NECK = "neck";
    public static final String ARM_LEFT = "armLeft";
    public static final String ARM_RIGHT = "armRight";
    public static final String BODY_FLUFF = "bodyFluff";
    public static final String LEG_LEFT = "legLeft";
    public static final String LEG_RIGHT = "legRight";
    public static final String TAIL = "tail";
    public static final String LEG_LEFT_2 = "legLeft2";
    public static final String FOOT_LEFT = "footLeft";
    public static final String LEG_RIGHT_2 = "legRight2";
    public static final String FOOT_RIGHT = "footRight";
    public static final String TAIL_2 = "tail2";
    public static final String TAIL_3 = "tail3";
    public static final String JOINT = "joint";
    public static final String NECK_FLUFF = "neckFluff";
    public static final String NECK_FLUFF_LEFT = "neckFluffLeft";
    public static final String NECK_FLUFF_RIGHT = "neckFluffRight";
    public static final String NECK_FLUFF_BOTTOM = "neckFluffBottom";
    public static final String HEAD = "head";
    public static final String EAR_LEFT = "earLeft";
    public static final String EAR_RIGHT = "earRight";
    public static final String SNOUT = "snout";
    public static final String JAW = "jaw";
    public static final String HEAD_FLUFF = "headFluff";
    public static final String HEAD_SIDBURN_LEFT = "headSidburnLeft";
    public static final String HEAD_SIDBURN_RIGHT = "headSidburnRight";
    public static final String EAR_LEFT_2 = "earLeft2";
    public static final String EAR_RIGHT_2 = "earRight2";
    public static final String NOSE = "nose";
    public static final String SNOUT_TEETH = "snoutTeeth";
    public static final String JAW_TEETH = "jawTeeth";
    public static final String JAW_FLUFF = "jawFluff";
    public static final String ARM_LEFT_2 = "armLeft2";
    public static final String FINGER_LEFT = "fingerLeft";
    public static final String FINGER_LEFT_2 = "fingerLeft2";
    public static final String FINGER_LEFT_3 = "fingerLeft3";
    public static final String FINGER_LEFT_4 = "fingerLeft4";
    public static final String THUMB_LEFT = "thumbLeft";
    public static final String ARM_RIGHT_2 = "armRight2";
    public static final String FINGER_RIGHT = "fingerRight";
    public static final String FINGER_RIGHT_2 = "fingerRight2";
    public static final String FINGER_RIGHT_3 = "fingerRight3";
    public static final String FINGER_RIGHT_4 = "fingerRight4";
    public static final String THUMB_RIGHT = "thumbRight";
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart neck;
    public final ModelPart armRight;
    public final ModelPart armLeft;
    public final ModelPart armRight2;
    public final ModelPart armLeft2;
    public final ModelPart legLeft;
    public final ModelPart legRight;
    public final ModelPart hip;
    public final ModelPart tail;
    public final ModelPart jaw;
    public final ModelPart earLeft;
    public final ModelPart earRight;

    public WerewolfBeastModel(ModelPart part) {
        super(part);
        this.body = part.m_171324_(BODY);
        this.hip = this.body.m_171324_(HIP);
        this.armRight = this.body.m_171324_(ARM_RIGHT);
        this.armLeft = this.body.m_171324_(ARM_LEFT);
        this.legRight = this.hip.m_171324_(LEG_RIGHT);
        this.legLeft = this.hip.m_171324_(LEG_LEFT);
        this.armLeft2 = this.armLeft.m_171324_(ARM_LEFT_2);
        this.armRight2 = this.armRight.m_171324_(ARM_RIGHT_2);
        this.tail = this.hip.m_171324_(TAIL);
        this.neck = this.body.m_171324_(NECK);
        ModelPart joint = this.neck.m_171324_(JOINT);
        this.head = joint.m_171324_(HEAD);
        this.jaw = this.head.m_171324_(JAW);
        this.earLeft = this.head.m_171324_(EAR_LEFT);
        this.earRight = this.head.m_171324_(EAR_RIGHT);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = WerewolfBaseModel.createMesh(CubeDeformation.f_171458_);
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_(BODY, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-4.5f, 0.0f, -4.0f, 9.0f, 8.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-2.5f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_(NECK, CubeListBuilder.m_171558_().m_171514_(0, 45).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 7.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)1.0f, (float)0.6981317f, (float)0.0f, (float)0.0f));
        PartDefinition joint = neck.m_171599_(JOINT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)-6.5f, (float)-1.0f, (float)-1.2217305f, (float)0.0f, (float)0.0f));
        PartDefinition head = joint.m_171599_(HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition snout = head.m_171599_(SNOUT, CubeListBuilder.m_171558_().m_171514_(34, 0).m_171481_(-2.0f, -2.0f, -4.0f, 4.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-5.0f, (float)-0.08726646f, (float)0.0f, (float)0.0f));
        PartDefinition hip = body.m_171599_(HIP, CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-3.5f, 0.0f, -3.0f, 7.0f, 9.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)1.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition headSidburnLeft = head.m_171599_(HEAD_SIDBURN_LEFT, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171481_(1.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f), PartPose.m_171430_((float)0.0f, (float)-0.5235988f, (float)0.0f));
        PartDefinition legRight = hip.m_171599_(LEG_RIGHT, CubeListBuilder.m_171558_().m_171514_(24, 39).m_171481_(-4.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f), PartPose.m_171423_((float)-0.5f, (float)9.0f, (float)0.0f, (float)-0.38397244f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.m_171599_(JAW, CubeListBuilder.m_171558_().m_171514_(50, 0).m_171481_(-1.5f, 0.0f, -3.5f, 3.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)1.5f, (float)-5.0f, (float)1.2217305f, (float)0.0f, (float)0.0f));
        PartDefinition jawFluff = jaw.m_171599_(JAW_FLUFF, CubeListBuilder.m_171558_().m_171514_(96, 8).m_171481_(-1.5f, 2.0f, -3.5f, 3.0f, 2.0f, 4.0f), PartPose.f_171404_);
        PartDefinition neckFluff = neck.m_171599_(NECK_FLUFF, CubeListBuilder.m_171558_().m_171514_(64, 19).m_171481_(-3.5f, -5.0f, 2.5f, 7.0f, 8.0f, 2.0f), PartPose.m_171430_((float)0.2617994f, (float)0.0f, (float)0.0f));
        PartDefinition tail = hip.m_171599_(TAIL, CubeListBuilder.m_171558_().m_171514_(62, 30).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)7.0f, (float)2.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition earLeft = head.m_171599_(EAR_LEFT, CubeListBuilder.m_171558_().m_171514_(26, 0).m_171481_(3.5f, -2.5f, -2.5f, 1.0f, 4.0f, 3.0f), PartPose.m_171430_((float)-0.4886922f, (float)0.34906584f, (float)0.0f));
        PartDefinition legRight2 = legRight.m_171599_(LEG_RIGHT_2, CubeListBuilder.m_171558_().m_171514_(44, 44).m_171481_(-3.5f, 2.0f, 3.0f, 3.0f, 10.0f, 4.0f), PartPose.f_171404_);
        PartDefinition footRight = legRight2.m_171599_(FOOT_RIGHT, CubeListBuilder.m_171558_().m_171514_(24, 54).m_171481_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)5.0f, (float)0.38397244f, (float)0.0f, (float)0.0f));
        PartDefinition snoutTeeth = snout.m_171599_(SNOUT_TEETH, CubeListBuilder.m_171558_().m_171514_(34, 6).m_171481_(-2.0f, 0.0f, -4.0f, 4.0f, 2.0f, 4.0f), PartPose.f_171404_);
        PartDefinition headSidburnRight = head.m_171599_(HEAD_SIDBURN_RIGHT, CubeListBuilder.m_171558_().m_171514_(32, 12).m_171481_(-4.0f, -1.0f, -5.0f, 3.0f, 6.0f, 0.0f).m_171480_(), PartPose.m_171430_((float)0.0f, (float)0.5235988f, (float)0.0f));
        PartDefinition nose = snout.m_171599_(NOSE, CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-1.5f, -3.5f, -3.7f, 3.0f, 2.0f, 5.0f), PartPose.m_171430_((float)0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition bodyFluff = body.m_171599_(BODY_FLUFF, CubeListBuilder.m_171558_().m_171514_(82, 14).m_171481_(-4.5f, 8.0f, -4.0f, 9.0f, 3.0f, 8.0f), PartPose.f_171404_);
        PartDefinition tail2 = tail.m_171599_(TAIL_2, CubeListBuilder.m_171558_().m_171514_(62, 37).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.m_171599_(TAIL_3, CubeListBuilder.m_171558_().m_171514_(62, 49).m_171481_(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)7.8f, (float)0.0f, (float)0.13665928f, (float)0.0f, (float)0.0f));
        PartDefinition neckFluffRight = neck.m_171599_(NECK_FLUFF_RIGHT, CubeListBuilder.m_171558_().m_171514_(82, 25).m_171481_(-3.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f), PartPose.m_171430_((float)0.34906584f, (float)-1.5707964f, (float)0.0f));
        PartDefinition headFluff = head.m_171599_(HEAD_FLUFF, CubeListBuilder.m_171558_().m_171514_(96, 0).m_171481_(-3.5f, 3.5f, -5.0f, 7.0f, 2.0f, 6.0f), PartPose.f_171404_);
        PartDefinition legLeft = hip.m_171599_(LEG_LEFT, CubeListBuilder.m_171558_().m_171514_(24, 39).m_171481_(0.0f, -2.0f, -3.0f, 4.0f, 8.0f, 6.0f), PartPose.m_171423_((float)0.5f, (float)9.0f, (float)0.0f, (float)-0.38397244f, (float)0.0f, (float)0.0f));
        PartDefinition earRight = head.m_171599_(EAR_RIGHT, CubeListBuilder.m_171558_().m_171514_(26, 0).m_171481_(-4.5f, -2.5f, -2.5f, 1.0f, 4.0f, 3.0f), PartPose.m_171430_((float)-0.4886922f, (float)-0.34906584f, (float)0.0f));
        PartDefinition earRight2 = earRight.m_171599_(EAR_RIGHT_2, CubeListBuilder.m_171558_().m_171514_(26, 7).m_171481_(-4.0f, -5.5f, -2.0f, 1.0f, 4.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)-0.17453292f));
        PartDefinition legLeft2 = legLeft.m_171599_(LEG_LEFT_2, CubeListBuilder.m_171558_().m_171514_(44, 44).m_171481_(0.5f, 2.0f, 3.0f, 3.0f, 10.0f, 4.0f).m_171480_(), PartPose.f_171404_);
        PartDefinition footLeft = legLeft2.m_171599_(FOOT_LEFT, CubeListBuilder.m_171558_().m_171514_(24, 54).m_171481_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 6.0f).m_171480_(), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)5.0f, (float)0.38397244f, (float)0.0f, (float)0.0f));
        PartDefinition jawTeeth = jaw.m_171599_(JAW_TEETH, CubeListBuilder.m_171558_().m_171514_(50, 6).m_171481_(-1.5f, -1.0f, -3.5f, 3.0f, 1.0f, 4.0f), PartPose.f_171404_);
        PartDefinition neckFluffBottom = neck.m_171599_(NECK_FLUFF_BOTTOM, CubeListBuilder.m_171558_().m_171514_(80, 0).m_171481_(-3.0f, -0.6f, 4.5f, 6.0f, 6.0f, 2.0f), PartPose.m_171430_((float)1.0471976f, (float)((float)Math.PI), (float)0.0f));
        PartDefinition earLeft2 = earLeft.m_171599_(EAR_LEFT_2, CubeListBuilder.m_171558_().m_171514_(26, 7).m_171481_(3.0f, -5.5f, -2.0f, 1.0f, 4.0f, 2.0f), PartPose.m_171430_((float)0.0f, (float)0.0f, (float)0.17453292f));
        PartDefinition neckFluffLeft = neck.m_171599_(NECK_FLUFF_LEFT, CubeListBuilder.m_171558_().m_171514_(82, 25).m_171481_(-2.5f, -5.5f, 3.0f, 6.0f, 8.0f, 3.0f), PartPose.m_171430_((float)0.34906584f, (float)1.5707964f, (float)0.0f));
        PartDefinition armRight = body.m_171599_(ARM_RIGHT, CubeListBuilder.m_171558_().m_171514_(36, 25).m_171481_(0.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.m_171423_((float)4.5f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1f));
        PartDefinition armRight2 = armRight.m_171599_(ARM_RIGHT_2, CubeListBuilder.m_171558_().m_171514_(48, 15).m_171481_(-1.5f, 0.0f, -2.0f, 3.0f, 10.0f, 4.0f), PartPose.m_171423_((float)2.0f, (float)7.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition thumbRight = armRight2.m_171599_(THUMB_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-0.5f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f), PartPose.m_171423_((float)-1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerRight = armRight2.m_171599_(FINGER_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerRight2 = armRight2.m_171599_(FINGER_RIGHT_2, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.2f, (float)9.0f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerRight3 = armRight2.m_171599_(FINGER_RIGHT_3, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.2f, (float)9.0f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerRight4 = armRight2.m_171599_(FINGER_RIGHT_4, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(-1.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f), PartPose.m_171423_((float)1.2f, (float)9.0f, (float)1.5f, (float)0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition armLeft = body.m_171599_(ARM_LEFT, CubeListBuilder.m_171558_().m_171514_(36, 25).m_171480_().m_171481_(-4.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f).m_171555_(false), PartPose.m_171423_((float)-4.5f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1f));
        PartDefinition armLeft2 = armLeft.m_171599_(ARM_LEFT_2, CubeListBuilder.m_171558_().m_171514_(48, 15).m_171480_().m_171481_(-1.5f, 0.0f, -2.0f, 3.0f, 10.0f, 4.0f).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)7.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition thumbLeft = armLeft2.m_171599_(THUMB_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 17).m_171480_().m_171481_(-1.5f, 0.0f, -0.5f, 2.0f, 2.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition fingerLeft = armLeft2.m_171599_(FINGER_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171480_().m_171481_(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.2f, (float)9.0f, (float)-1.5f, (float)-0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerLeft2 = armLeft2.m_171599_(FINGER_LEFT_2, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171480_().m_171481_(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.2f, (float)9.0f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerLeft3 = armLeft2.m_171599_(FINGER_LEFT_3, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171480_().m_171481_(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.2f, (float)9.0f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition fingerLeft4 = armLeft2.m_171599_(FINGER_LEFT_4, CubeListBuilder.m_171558_().m_171514_(0, 13).m_171480_().m_171481_(-0.5f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f).m_171555_(false), PartPose.m_171423_((float)-1.2f, (float)9.0f, (float)1.5f, (float)0.2618f, (float)0.0f, (float)0.1745f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    @Override
    @Nullable
    public ModelPart getModelRenderer() {
        return this.body;
    }

    @Override
    @Nullable
    public ModelPart getHeadModel() {
        return this.head;
    }

    @Override
    @Nullable
    public ModelPart getLeftArmModel() {
        return this.armRight2;
    }

    @Override
    @Nullable
    public ModelPart getRightArmModel() {
        return this.armLeft2;
    }

    @Override
    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }

    public void m_7695_(@Nonnull PoseStack matrixStackIn, @Nonnull VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.body.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public void m_6973_(@Nonnull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag1 = entityIn.m_6067_();
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = this.f_102818_ > 0.0f ? (flag1 ? this.m_102835_(this.head.f_104203_, -0.7853982f, this.f_102818_) : this.m_102835_(this.head.f_104203_, headPitch * ((float)Math.PI / 180), this.f_102818_)) : headPitch * ((float)Math.PI / 180);
        this.armRight.f_104205_ = 0.0f;
        this.armLeft.f_104205_ = 0.0f;
        this.armLeft2.f_104203_ = -1.0f;
        this.armRight2.f_104203_ = -1.0f;
        this.armRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount * 0.5f;
        this.armLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount * 0.5f;
        this.armRight.f_104205_ += Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armLeft.f_104205_ -= Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.armRight.f_104203_ += Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        this.armLeft.f_104203_ -= Mth.m_14031_((float)(ageInTicks * 0.067f)) * 0.05f;
        this.legRight.f_104203_ = -0.38397244f;
        this.legLeft.f_104203_ = -0.38397244f;
        this.legRight.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f * 0.7f)) * 1.4f * limbSwingAmount;
        this.legLeft.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f * 0.7f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        if (this.f_102817_) {
            this.body.f_104203_ = 0.7235988f;
            this.hip.f_104203_ = -0.7235988f;
        } else {
            this.body.f_104203_ = 0.5235988f;
            this.hip.f_104203_ = -0.5235988f;
        }
        this.tail.f_104203_ = 0.7853982f;
        this.tail.f_104203_ -= 0.035f;
        this.tail.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.07f;
        this.tail.f_104204_ = -0.035f;
        this.tail.f_104204_ += Mth.m_14031_((float)(ageInTicks * 0.14f)) * 0.07f;
        this.tail.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f * 0.7f)) * 0.3f * Mth.m_14154_((float)limbSwingAmount) + 0.3f;
        this.tail.f_104204_ += Mth.m_14031_((float)(limbSwing * 0.6662f * 0.7f)) * 0.1f * limbSwingAmount;
        if (this.f_102608_ > 0.0f) {
            HumanoidArm humanoidarm = this.m_102856_(entityIn);
            ModelPart modelpart = humanoidarm == HumanoidArm.LEFT ? this.armLeft : this.armRight;
            float f = this.f_102608_;
            this.neck.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.neck.f_104204_ *= -1.0f;
            }
            f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
            modelpart.f_104203_ -= f1 * 1.2f + f2;
            modelpart.f_104204_ += this.body.f_104204_ * 2.0f;
            float zChange = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
            modelpart.f_104205_ = humanoidarm == HumanoidArm.LEFT ? (modelpart.f_104205_ -= zChange) : (modelpart.f_104205_ += zChange);
        }
        this.jaw.f_104203_ = 0.8217305f;
        this.jaw.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.07f;
        this.earLeft.f_104203_ = -0.4886922f;
        this.earLeft.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.07f;
        this.earRight.f_104203_ = -0.4886922f;
        this.earRight.f_104203_ += Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.07f;
    }

    public void setRotateAngle(ModelPart ModelRenderer, float x, float y, float z) {
        ModelRenderer.f_104203_ = x;
        ModelRenderer.f_104204_ = y;
        ModelRenderer.f_104205_ = z;
    }

    private HumanoidArm m_102856_(T p_102857_) {
        HumanoidArm humanoidarm = p_102857_.m_5737_();
        return ((LivingEntity)p_102857_).f_20912_ == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.m_20828_();
    }

    private float m_102833_(float p_102834_) {
        return -65.0f * p_102834_ + p_102834_ * p_102834_;
    }
}

