/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class WerewolfEarsModel<T extends LivingEntity>
extends WerewolfBaseModel<T> {
    public static final String DUMMY_HEAD = "dummyHead";
    public static final String CLAWS_LEFT = "clawsLeft";
    public static final String CLAWS_RIGHT = "clawsRight";
    public static final String EAR_RIGHT = "earRight";
    public static final String EAR_LEFT = "earLeft";
    public final ModelPart dummyHead;
    public final ModelPart clawsLeft;
    public final ModelPart clawsRight;
    public final ModelPart earRight;
    public final ModelPart earLeft;

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = WerewolfBaseModel.createMesh(CubeDeformation.f_171458_);
        PartDefinition root = mesh.m_171576_();
        PartDefinition dummyHead = root.m_171599_(DUMMY_HEAD, CubeListBuilder.m_171558_().m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        PartDefinition earRight = dummyHead.m_171599_(EAR_RIGHT, CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(-4.5f, -8.0f, -2.5f, 1.0f, 6.0f, 3.0f), PartPose.m_171430_((float)-0.4886922f, (float)-0.2617994f, (float)0.0f));
        PartDefinition earLeft = dummyHead.m_171599_(EAR_LEFT, CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(3.5f, -8.0f, -2.5f, 1.0f, 6.0f, 3.0f), PartPose.m_171430_((float)-0.4886922f, (float)0.2617994f, (float)0.0f));
        PartDefinition clawsRight = root.m_171597_("right_arm").m_171599_(CLAWS_RIGHT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, 10.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.f_171404_);
        PartDefinition clawsLeft = root.m_171597_("left_arm").m_171599_(CLAWS_LEFT, CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-1.0f, 10.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public WerewolfEarsModel(ModelPart part) {
        super(part);
        this.dummyHead = part.m_171324_(DUMMY_HEAD);
        this.dummyHead.f_233556_ = true;
        this.earRight = this.dummyHead.m_171324_(EAR_RIGHT);
        this.earLeft = this.dummyHead.m_171324_(EAR_LEFT);
        this.clawsRight = this.f_102811_.m_171324_(CLAWS_RIGHT);
        this.clawsLeft = this.f_102812_.m_171324_(CLAWS_LEFT);
    }

    @Override
    @Nullable
    public ModelPart getModelRenderer() {
        return null;
    }

    @Override
    @Nullable
    public ModelPart getHeadModel() {
        return null;
    }

    @Override
    @Nullable
    public ModelPart getLeftArmModel() {
        return this.clawsLeft;
    }

    @Override
    @Nullable
    public ModelPart getRightArmModel() {
        return this.clawsRight;
    }

    @Nonnull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.dummyHead);
    }

    @Override
    @Nonnull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102811_, (Object)this.f_102812_);
    }

    @Override
    public void m_6973_(@Nonnull T p_225597_1_, float p_225597_2_, float p_225597_3_, float p_225597_4_, float p_225597_5_, float p_225597_6_) {
        this.dummyHead.m_104315_(this.playerModel.f_102808_);
        this.f_102811_.m_104315_(this.playerModel.f_102811_);
        this.f_102812_.m_104315_(this.playerModel.f_102812_);
    }

    public void m_7695_(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, float p_102038_, float p_102039_, float p_102040_, float p_102041_) {
        super.m_7695_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
    }
}

