/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.core.ModModelRender;
import de.teamlapen.werewolves.client.model.Werewolf4LModel;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.client.model.WerewolfBeastModel;
import de.teamlapen.werewolves.client.model.WerewolfEarsModel;
import de.teamlapen.werewolves.client.model.WerewolfSurvivalistModel;
import de.teamlapen.werewolves.client.render.WerewolfModelWrapper;
import de.teamlapen.werewolves.client.render.layer.WerewolfFormFaceOverlayLayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseWerewolfRenderer<T extends LivingEntity>
extends LivingEntityRenderer<T, WerewolfBaseModel<T>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<WerewolfForm, WerewolfModelWrapper<T>> models = new HashMap<WerewolfForm, WerewolfModelWrapper<T>>();
    protected final ResourceLocation[] eyeOverlays;
    protected List<ResourceLocation> textures;
    protected WerewolfForm form = WerewolfForm.NONE;

    public BaseWerewolfRenderer(EntityRendererProvider.Context context, float size) {
        super(context, null, 0.0f);
        this.eyeOverlays = new ResourceLocation[6];
        for (int i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = new ResourceLocation("werewolves:textures/entity/werewolf/eye/eye_" + i + ".png");
        }
        this.models.put(WerewolfForm.NONE, new WerewolfModelWrapper.Builder().shadow(0.0f).build());
        this.models.put(WerewolfForm.HUMAN, new WerewolfModelWrapper.Builder().model(new WerewolfEarsModel(context.m_174023_(ModModelRender.EARS_CLAWS))).layers(Collections.emptyList()).textures(BaseWerewolfRenderer.getHumanTextures()).shadow(size).build());
        this.models.put(WerewolfForm.BEAST, new WerewolfModelWrapper.Builder().model(new WerewolfBeastModel(context.m_174023_(ModModelRender.WEREWOLF_BEAST))).layers(Collections.singleton(new WerewolfFormFaceOverlayLayer(WerewolfForm.BEAST, this, this.eyeOverlays))).textures(BaseWerewolfRenderer.getBeastTextures()).shadow(2.6f * size).skipPlayerModel().build());
        this.models.put(WerewolfForm.SURVIVALIST, new WerewolfModelWrapper.Builder().model(new WerewolfSurvivalistModel(context.m_174023_(ModModelRender.WEREWOLF_SURVIVALIST))).layers(Collections.singleton(new WerewolfFormFaceOverlayLayer(WerewolfForm.SURVIVALIST, this, this.eyeOverlays))).textures(BaseWerewolfRenderer.getSurvivalTextures()).shadow(size).skipPlayerModel().build());
        this.models.put(WerewolfForm.BEAST4L, new WerewolfModelWrapper.Builder().model(new Werewolf4LModel(context.m_174023_(ModModelRender.WEREWOLF_4L))).layers(Collections.singleton(new WerewolfFormFaceOverlayLayer(WerewolfForm.BEAST4L, this, this.eyeOverlays))).textures(BaseWerewolfRenderer.getBeastTextures()).shadow(2.6f * size).skipPlayerModel().build());
    }

    public void switchModel(WerewolfForm type) {
        if (this.form == type) {
            return;
        }
        this.form = type;
        WerewolfModelWrapper<T> werewolfModelWrapper = this.getWrapper(type);
        this.f_115290_ = werewolfModelWrapper.model();
        this.f_114477_ = werewolfModelWrapper.shadow();
        this.textures = werewolfModelWrapper.textures();
        this.f_115291_.clear();
        this.f_115291_.addAll(werewolfModelWrapper.layers());
    }

    protected WerewolfModelWrapper<T> getWrapper(WerewolfForm type) {
        return this.models.get(type);
    }

    protected void m_7523_(@Nonnull T entityLiving, @Nonnull PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        if (entityLiving.m_20998_(partialTicks) > 0.0f && this.form.isHumanLike()) {
            float f3 = entityLiving.m_20069_() ? -90.0f - entityLiving.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)entityLiving.m_20998_(partialTicks), (float)0.0f, (float)f3);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(f4));
            if (entityLiving.m_6067_()) {
                matrixStackIn.m_85837_(0.0, -1.0, (double)0.3f);
            }
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull T entity) {
        return this.textures.get(Helper.asIWerewolf(entity).getSkinType(this.form) % this.form.getSkinTypes());
    }

    @Nonnull
    public static List<ResourceLocation> getBeastTextures() {
        List<ResourceLocation> locs = Minecraft.m_91087_().m_91098_().m_214159_("textures/entity/werewolf/beast", s -> s.m_135815_().endsWith(".png")).keySet().stream().filter(r -> "werewolves".equals(r.m_135827_())).collect(Collectors.toList());
        if (locs.size() < WerewolfForm.BEAST.getSkinTypes()) {
            LOGGER.error("Could not find all textures for the beast werewolf form");
            for (int i = 0; i < WerewolfForm.BEAST.getSkinTypes(); ++i) {
                ResourceLocation s2 = new ResourceLocation("werewolves", "textures/entity/werewolf/beast/beast_" + i + ".png");
                if (locs.contains(s2)) continue;
                locs.add(s2);
            }
        }
        return locs;
    }

    @Nonnull
    public static List<ResourceLocation> getSurvivalTextures() {
        List<ResourceLocation> locs = Minecraft.m_91087_().m_91098_().m_214159_("textures/entity/werewolf/survivalist", s -> s.m_135815_().endsWith(".png")).keySet().stream().filter(r -> "werewolves".equals(r.m_135827_())).collect(Collectors.toList());
        if (locs.size() < WerewolfForm.SURVIVALIST.getSkinTypes()) {
            LOGGER.error("Could not find all textures for the survivalist werewolf form");
            for (int i = 0; i < WerewolfForm.SURVIVALIST.getSkinTypes(); ++i) {
                ResourceLocation s2 = new ResourceLocation("werewolves", "textures/entity/werewolf/survivalist/survivalist_" + i + ".png");
                if (locs.contains(s2)) continue;
                locs.add(s2);
            }
        }
        return locs;
    }

    @Nonnull
    public static List<ResourceLocation> getHumanTextures() {
        List<ResourceLocation> locs = Minecraft.m_91087_().m_91098_().m_214159_("textures/entity/werewolf/human", s -> s.m_135815_().endsWith(".png")).keySet().stream().filter(r -> "werewolves".equals(r.m_135827_())).collect(Collectors.toList());
        if (locs.size() < WerewolfForm.HUMAN.getSkinTypes()) {
            LOGGER.error("Could not find all textures for the human werewolf form");
            for (int i = 0; i < WerewolfForm.HUMAN.getSkinTypes(); ++i) {
                ResourceLocation s2 = new ResourceLocation("werewolves", "textures/entity/werewolf/human/werewolf_ear_claws_" + i + ".png");
                if (locs.contains(s2)) continue;
                locs.add(s2);
            }
        }
        return locs;
    }
}

