/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.gui.WerewolfPlayerAppearanceScreen;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.client.render.BaseWerewolfRenderer;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WerewolfPlayerRenderer
extends BaseWerewolfRenderer<AbstractClientPlayer> {
    private boolean skipPlayerModel;

    public WerewolfPlayerRenderer(EntityRendererProvider.Context context) {
        super(context, 0.5f);
    }

    @Override
    public void switchModel(WerewolfForm type) {
        if (this.form == type) {
            return;
        }
        super.switchModel(type);
        this.skipPlayerModel = this.getWrapper(type).skipPlayerModel();
    }

    private void setModelVisible(@Nonnull AbstractClientPlayer clientPlayer) {
        WerewolfBaseModel playerModel = (WerewolfBaseModel)this.m_7200_();
        if (clientPlayer.m_5833_()) {
            playerModel.m_8009_(false);
            playerModel.f_102808_.f_104207_ = true;
        } else {
            playerModel.m_8009_(true);
            playerModel.f_102817_ = clientPlayer.m_6047_();
        }
    }

    public boolean renderRightArm(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn) {
        WerewolfForm form = WerewolfPlayer.get((Player)playerIn).getForm();
        if (!form.isHumanLike()) {
            form = WerewolfForm.BEAST;
        }
        this.switchModel(form);
        ModelPart arm = ((WerewolfBaseModel)this.m_7200_()).getRightArmModel();
        if (arm != null) {
            if (this.shouldRenderArm(HumanoidArm.RIGHT, playerIn)) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85841_(1.2f, 1.0f, 1.2f);
                matrixStackIn.m_85837_(0.0, 0.2, 0.4);
                this.renderItem(matrixStackIn, bufferIn, combinedLightIn, playerIn, arm);
                matrixStackIn.m_85849_();
            } else {
                return false;
            }
        }
        return !form.isHumanLike();
    }

    public boolean renderLeftArm(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn) {
        WerewolfForm form = WerewolfPlayer.get((Player)playerIn).getForm();
        if (!form.isHumanLike()) {
            form = WerewolfForm.BEAST;
        }
        this.switchModel(form);
        ModelPart arm = ((WerewolfBaseModel)this.m_7200_()).getLeftArmModel();
        if (arm != null) {
            if (this.shouldRenderArm(HumanoidArm.LEFT, playerIn)) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85841_(1.2f, 1.0f, 1.2f);
                matrixStackIn.m_85837_(0.0, 0.2, 0.4);
                this.renderItem(matrixStackIn, bufferIn, combinedLightIn, playerIn, arm);
                matrixStackIn.m_85849_();
            } else {
                return false;
            }
        }
        return !form.isHumanLike();
    }

    private boolean shouldRenderArm(HumanoidArm armSide, @Nonnull AbstractClientPlayer player) {
        HumanoidArm side = player.m_5737_();
        ItemStack mainStack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offStack = player.m_21120_(InteractionHand.OFF_HAND);
        if (armSide == side) {
            return mainStack.m_41720_() != Items.f_42573_;
        }
        return offStack.m_41720_() != Items.f_42573_ && (!offStack.m_41619_() || mainStack.m_41720_() != Items.f_42573_);
    }

    private void renderItem(PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, AbstractClientPlayer playerIn, @Nonnull ModelPart rendererArmIn) {
        WerewolfBaseModel model = (WerewolfBaseModel)this.m_7200_();
        this.setModelVisible(playerIn);
        model.f_102608_ = 0.0f;
        model.f_102817_ = false;
        model.f_102818_ = 0.0f;
        rendererArmIn.m_104301_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation(playerIn))), combinedLightIn, OverlayTexture.f_118083_);
    }

    public boolean render(@Nonnull WerewolfPlayer entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        WerewolfForm form = entity.getForm();
        if (Minecraft.m_91087_().f_91080_ instanceof WerewolfPlayerAppearanceScreen) {
            form = ((WerewolfPlayerAppearanceScreen)Minecraft.m_91087_().f_91080_).getActiveForm();
        }
        this.switchModel(form);
        if (this.f_115290_ != null && this.skipPlayerModel) {
            this.render((AbstractClientPlayer)entity.getRepresentingPlayer(), entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            return true;
        }
        return false;
    }

    public void renderPost(PlayerModel<AbstractClientPlayer> entityModel, WerewolfPlayer entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (this.f_115290_ != null && !this.skipPlayerModel) {
            ((WerewolfBaseModel)this.f_115290_).setPlayerModel(entityModel);
            this.render((AbstractClientPlayer)entity.getRepresentingPlayer(), entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    @Deprecated
    public void render(@Nonnull AbstractClientPlayer entity, float entityYaw, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn) {
        if (!entity.m_7578_() || this.f_114476_.f_114358_.m_90592_() == entity) {
            this.setModelVisible(entity);
            super.m_7392_((LivingEntity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    public WerewolfForm getForm() {
        return this.form;
    }
}

