/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class WerewolfEntityFaceOverlayLayer<T extends WerewolfBaseEntity, M extends WerewolfBaseModel<T>>
extends RenderLayer<T, M> {
    private final ResourceLocation[] eyeOverlays = new ResourceLocation[6];

    public WerewolfEntityFaceOverlayLayer(RenderLayerParent<T, M> entityRendererIn) {
        super(entityRendererIn);
        for (int i = 0; i < this.eyeOverlays.length; ++i) {
            this.eyeOverlays[i] = new ResourceLocation("werewolves:textures/entity/werewolf/eye/eye_" + i + ".png");
        }
    }

    public void render(@Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull WerewolfBaseEntity werewolf, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int s = werewolf.getEyeType();
        int eyeType = Math.max(0, s) % this.eyeOverlays.length;
        RenderType renderType = RenderType.m_110488_((ResourceLocation)this.eyeOverlays[eyeType]);
        VertexConsumer vertexBuilderEye = bufferIn.m_6299_(renderType);
        int packerOverlay = LivingEntityRenderer.m_115338_((LivingEntity)werewolf, (float)0.0f);
        ((WerewolfBaseModel)this.m_117386_()).getModelRenderer().m_104301_(matrixStack, vertexBuilderEye, packedLightIn, packerOverlay);
    }
}

