/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.client.model.WerewolfBaseModel;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class WerewolfFaceOverlayLayer<T extends LivingEntity>
extends RenderLayer<T, WerewolfBaseModel<T>> {
    private final ResourceLocation[] eyeOverlays;

    public WerewolfFaceOverlayLayer(LivingEntityRenderer<T, WerewolfBaseModel<T>> renderer, ResourceLocation[] overlays) {
        super(renderer);
        this.eyeOverlays = overlays;
    }

    public void render(@Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource bufferIn, int packedLightIn, @Nonnull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IWerewolf werewolf = entity instanceof IWerewolf ? (IWerewolf)entity : WerewolfPlayer.get((Player)entity);
        int eyeType = Math.max(0, Math.min(this.getEyeType(werewolf), this.eyeOverlays.length - 1));
        RenderType renderType = this.hasGlowingEyes(werewolf) ? RenderType.m_110488_((ResourceLocation)this.eyeOverlays[eyeType]) : RenderType.m_110458_((ResourceLocation)this.eyeOverlays[eyeType]);
        VertexConsumer vertexBuilderEye = bufferIn.m_6299_(renderType);
        int packerOverlay = LivingEntityRenderer.m_115338_(entity, (float)0.0f);
        ((WerewolfBaseModel)this.m_117386_()).getModelRenderer().m_104301_(matrixStack, vertexBuilderEye, packedLightIn, packerOverlay);
    }

    public int getEyeType(IWerewolf werewolf) {
        return werewolf.getEyeType();
    }

    public boolean hasGlowingEyes(IWerewolf werewolf) {
        return werewolf.hasGlowingEyes();
    }
}

