/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.entities.AggressiveWolfEntity;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.HumanWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfAlphaEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTaskMasterEntity;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"werewolves");
    public static final RegistryObject<EntityType<BasicWerewolfEntity.Beast>> WEREWOLF_BEAST = ModEntities.prepareEntityType("werewolf_beast", () -> EntityType.Builder.m_20704_(BasicWerewolfEntity.Beast::new, (MobCategory)WerewolvesMod.WEREWOLF_CREATURE_TYPE).m_20699_(0.8f, 2.0f), true);
    public static final RegistryObject<EntityType<BasicWerewolfEntity.Survivalist>> WEREWOLF_SURVIVALIST = ModEntities.prepareEntityType("werewolf_survivalist", () -> EntityType.Builder.m_20704_(BasicWerewolfEntity.Survivalist::new, (MobCategory)WerewolvesMod.WEREWOLF_CREATURE_TYPE).m_20699_(0.8f, 1.0f), true);
    public static final RegistryObject<EntityType<HumanWerewolfEntity>> HUMAN_WEREWOLF = ModEntities.prepareEntityType("human_werewolf", () -> EntityType.Builder.m_20704_(HumanWerewolfEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.9f), true);
    public static final RegistryObject<EntityType<WerewolfTaskMasterEntity>> TASK_MASTER_WEREWOLF = ModEntities.prepareEntityType("task_master_werewolf", () -> EntityType.Builder.m_20704_(WerewolfTaskMasterEntity::new, (MobCategory)WerewolvesMod.WEREWOLF_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<AggressiveWolfEntity>> WOLF = ModEntities.prepareEntityType("wolf", () -> EntityType.Builder.m_20704_(AggressiveWolfEntity::new, (MobCategory)MobCategory.AMBIENT).m_20699_(0.6f, 0.85f), false);
    public static final RegistryObject<EntityType<WerewolfMinionEntity>> WEREWOLF_MINION = ModEntities.prepareEntityType("werewolf_minion", () -> EntityType.Builder.m_20704_(WerewolfMinionEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f), false);
    public static final RegistryObject<EntityType<WerewolfAlphaEntity>> ALPHA_WEREWOLF = ModEntities.prepareEntityType("alpha_werewolf", () -> EntityType.Builder.m_20704_(WerewolfAlphaEntity::new, (MobCategory)WerewolvesMod.WEREWOLF_CREATURE_TYPE).m_20699_(0.8f, 2.0f), true);

    static void register(IEventBus bus) {
        ENTITY_TYPES.register(bus);
        WerewolfMinionEntity.registerMinionData();
    }

    static void registerSpawns() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)WEREWOLF_BEAST.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WerewolfBaseEntity::spawnPredicateWerewolf);
        SpawnPlacements.m_21754_((EntityType)((EntityType)WEREWOLF_SURVIVALIST.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WerewolfBaseEntity::spawnPredicateWerewolf);
        SpawnPlacements.m_21754_((EntityType)((EntityType)HUMAN_WEREWOLF.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HumanWerewolfEntity::spawnPredicateHumanWerewolf);
        SpawnPlacements.m_21754_((EntityType)((EntityType)WOLF.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, spawnReason, blockPos, random) -> true);
        SpawnPlacements.m_21754_((EntityType)((EntityType)ALPHA_WEREWOLF.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WerewolfAlphaEntity::spawnPredicateAlpha);
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> prepareEntityType(String id, Supplier<EntityType.Builder<T>> builder, boolean spawnable) {
        return ENTITY_TYPES.register(id, () -> {
            EntityType.Builder type = ((EntityType.Builder)builder.get()).setTrackingRange(10).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
            if (!spawnable) {
                type.m_20698_();
            }
            return type.m_20712_("werewolves:" + id);
        });
    }

    static void onRegisterEntityTypeAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HUMAN_WEREWOLF.get(), HumanWerewolfEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)WEREWOLF_BEAST.get(), BasicWerewolfEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)WEREWOLF_SURVIVALIST.get(), BasicWerewolfEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)WOLF.get(), AggressiveWolfEntity.m_30425_().m_22265_());
        event.put((EntityType)TASK_MASTER_WEREWOLF.get(), WerewolfTaskMasterEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)WEREWOLF_MINION.get(), WerewolfMinionEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)ALPHA_WEREWOLF.get(), WerewolfAlphaEntity.getAttributeBuilder().m_22265_());
    }

    static void onModifyEntityTypeAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)ModAttributes.BITE_DAMAGE.get());
        event.add(EntityType.f_20532_, (Attribute)ModAttributes.TIME_REGAIN.get());
    }

    public static Set<EntityType<?>> getAllEntities() {
        return ENTITY_TYPES.getEntries().stream().map(RegistryObject::get).collect(Collectors.toSet());
    }

    static {
        V.init();
    }

    public static class V {
        public static final RegistryObject<EntityType<BasicHunterEntity>> HUNTER = RegistryObject.create((ResourceLocation)new ResourceLocation("vampirism", "hunter"), (ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES, (String)"werewolves");
        public static final RegistryObject<EntityType<BasicHunterEntity.IMob>> HUNTER_IMOB = RegistryObject.create((ResourceLocation)new ResourceLocation("vampirism", "hunter_imob"), (ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES, (String)"werewolves");

        private static void init() {
        }
    }
}

