/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.vampirism.api.items.IEntityCrossbowArrow;
import de.teamlapen.vampirism.api.items.IRefinementItem;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.effects.SilverEffect;
import de.teamlapen.werewolves.items.CrossbowArrowItem;
import de.teamlapen.werewolves.items.LiverItem;
import de.teamlapen.werewolves.items.SilverSwordItem;
import de.teamlapen.werewolves.items.UnWerewolfInjectionItem;
import de.teamlapen.werewolves.items.WerewolfMinionUpgradeItem;
import de.teamlapen.werewolves.items.WerewolfRefinementItem;
import de.teamlapen.werewolves.items.WerewolfToothItem;
import de.teamlapen.werewolves.misc.WerewolvesCreativeTab;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"werewolves");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"werewolves");
    private static final Set<RegistryObject<? extends Item>> WEREWOLVES_TAB_ITEMS = new HashSet<RegistryObject<? extends Item>>();
    private static final Map<ResourceKey<CreativeModeTab>, Set<RegistryObject<? extends Item>>> CREATIVE_TAB_ITEMS = new HashMap<ResourceKey<CreativeModeTab>, Set<RegistryObject<? extends Item>>>();
    public static final ResourceKey<CreativeModeTab> CREATIVE_TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("werewolves", "default"));
    public static final RegistryObject<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register(CREATIVE_TAB_KEY.m_135782_().m_135815_(), () -> WerewolvesCreativeTab.builder(WEREWOLVES_TAB_ITEMS.stream().map(RegistryObject::get).collect(Collectors.toSet())).m_257652_());
    public static final RegistryObject<Item> SILVER_INGOT = ModItems.register("silver_ingot", () -> new Item(ModItems.props()));
    public static final RegistryObject<HoeItem> SILVER_HOE = ModItems.register("silver_hoe", () -> new HoeItem(WUtils.SILVER_ITEM_TIER, -1, -1.0f, ModItems.props()));
    public static final RegistryObject<ShovelItem> SILVER_SHOVEL = ModItems.register("silver_shovel", () -> new ShovelItem(WUtils.SILVER_ITEM_TIER, 1.5f, -3.0f, ModItems.props()));
    public static final RegistryObject<AxeItem> SILVER_AXE = ModItems.register("silver_axe", () -> new AxeItem(WUtils.SILVER_ITEM_TIER, 6.0f, -3.1f, ModItems.props()));
    public static final RegistryObject<PickaxeItem> SILVER_PICKAXE = ModItems.register("silver_pickaxe", () -> new PickaxeItem(WUtils.SILVER_ITEM_TIER, 1, -2.8f, ModItems.props()));
    public static final RegistryObject<SilverSwordItem> SILVER_SWORD = ModItems.register("silver_sword", () -> new SilverSwordItem(WUtils.SILVER_ITEM_TIER, 3, -2.4f, ModItems.props()));
    public static final RegistryObject<CrossbowArrowItem> CROSSBOW_ARROW_SILVER_BOLT = ModItems.register("crossbow_arrow_silver_bolt", () -> new CrossbowArrowItem(new CrossbowArrowItem.ArrowType("silver_bolt", 3, 0xC0C0C0, true, true){

        @Override
        public void onHitEntity(ItemStack arrow, LivingEntity entity, IEntityCrossbowArrow arrowEntity, Entity shootingEntity) {
            if (Helper.isWerewolf((Entity)entity)) {
                entity.m_7292_(SilverEffect.createEffect(entity, (Integer)WerewolvesConfig.BALANCE.UTIL.silverBoltEffectDuration.get() * 20));
            }
        }
    }));
    public static final RegistryObject<LiverItem> LIVER = ModItems.register("liver", LiverItem::new);
    public static final RegistryObject<Item> CRACKED_BONE = ModItems.register("cracked_bone", () -> new Item(ModItems.props()));
    public static final RegistryObject<UnWerewolfInjectionItem> INJECTION_UN_WEREWOLF = ModItems.register("injection_un_werewolf", UnWerewolfInjectionItem::new);
    public static final RegistryObject<WerewolfToothItem> WEREWOLF_TOOTH = ModItems.register("werewolf_tooth", WerewolfToothItem::new);
    public static final RegistryObject<Item> SILVER_NUGGET = ModItems.register("silver_nugget", () -> new Item(ModItems.props()));
    public static final RegistryObject<Item> RAW_SILVER = ModItems.register("raw_silver", () -> new Item(ModItems.props()));
    public static final RegistryObject<Item> WEREWOLF_MINION_CHARM = ModItems.register("werewolf_minion_charm", () -> new Item(ModItems.props()){

        public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flag) {
            super.m_7373_(stack, level, tooltips, flag);
            tooltips.add((Component)Component.m_237115_((String)"item.werewolves.moon_charm.desc").m_130940_(ChatFormatting.DARK_GRAY));
        }
    });
    public static final RegistryObject<WerewolfMinionUpgradeItem> WEREWOLF_MINION_UPGRADE_SIMPLE = ModItems.register("werewolf_minion_upgrade_simple", () -> new WerewolfMinionUpgradeItem(ModItems.props(), 1, 2));
    public static final RegistryObject<WerewolfMinionUpgradeItem> WEREWOLF_MINION_UPGRADE_ENHANCED = ModItems.register("werewolf_minion_upgrade_enhanced", () -> new WerewolfMinionUpgradeItem(ModItems.props(), 3, 4));
    public static final RegistryObject<WerewolfMinionUpgradeItem> WEREWOLF_MINION_UPGRADE_SPECIAL = ModItems.register("werewolf_minion_upgrade_special", () -> new WerewolfMinionUpgradeItem(ModItems.props(), 5, 6));
    public static final RegistryObject<SpawnEggItem> WEREWOLF_BEAST_SPAWN_EGG = ModItems.register("werewolf_beast_spawn_egg", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_, () -> new ForgeSpawnEggItem(ModEntities.WEREWOLF_BEAST, 16762880, 16427776, ModItems.props()));
    public static final RegistryObject<SpawnEggItem> WEREWOLF_SURVIVALIST_SPAWN_EGG = ModItems.register("werewolf_survivalist_spawn_egg", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_, () -> new ForgeSpawnEggItem(ModEntities.WEREWOLF_SURVIVALIST, 16762880, 16443136, ModItems.props()));
    public static final RegistryObject<SpawnEggItem> HUMAN_WEREWOLF_SPAWN_EGG = ModItems.register("human_werewolf_spawn_egg", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_, () -> new ForgeSpawnEggItem(ModEntities.HUMAN_WEREWOLF, 16762880, 0xA8A8A8, ModItems.props()));
    public static final RegistryObject<SpawnEggItem> ALPHA_WEREWOLF_SPAWN_EGG = ModItems.register("alpha_werewolf_spawn_egg", (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_, () -> new ForgeSpawnEggItem(ModEntities.ALPHA_WEREWOLF, 16762880, 13242112, ModItems.props()));
    public static final RegistryObject<WerewolfRefinementItem> BONE_NECKLACE = ModItems.register("bone_necklace", () -> new WerewolfRefinementItem(ModItems.props(), IRefinementItem.AccessorySlotType.AMULET));
    public static final RegistryObject<WerewolfRefinementItem> CHARM_BRACELET = ModItems.register("charm_bracelet", () -> new WerewolfRefinementItem(ModItems.props(), IRefinementItem.AccessorySlotType.RING));
    public static final RegistryObject<WerewolfRefinementItem> DREAM_CATCHER = ModItems.register("dream_catcher", () -> new WerewolfRefinementItem(ModItems.props(), IRefinementItem.AccessorySlotType.OBI_BELT));

    static <I extends Item> RegistryObject<I> register(String name, ResourceKey<CreativeModeTab> tab, Supplier<? extends I> sup) {
        RegistryObject item = ITEMS.register(name, sup);
        if (tab == CREATIVE_TAB_KEY) {
            WEREWOLVES_TAB_ITEMS.add((RegistryObject<? extends Item>)item);
        } else {
            CREATIVE_TAB_ITEMS.computeIfAbsent(tab, a -> new HashSet()).add(item);
        }
        return item;
    }

    static <I extends Item> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        return ModItems.register(name, CREATIVE_TAB_KEY, sup);
    }

    static void register(IEventBus bus) {
        ITEMS.register(bus);
        CREATIVE_TABS.register(bus);
    }

    public static void remapItems(MissingMappingsEvent event) {
        event.getAllMappings(ForgeRegistries.Keys.ITEMS).forEach(missingMapping -> {
            switch (missingMapping.getKey().toString()) {
                case "werewolves:bone": {
                    missingMapping.remap((Object)((Item)CRACKED_BONE.get()));
                    break;
                }
                case "werewolves:silver_oil": {
                    missingMapping.remap((Object)((Item)de.teamlapen.vampirism.core.ModItems.OIL_BOTTLE.get()));
                }
            }
        });
    }

    @ApiStatus.Internal
    public static void registerOtherCreativeTabItems(BuildCreativeModeTabContentsEvent event) {
        CREATIVE_TAB_ITEMS.forEach((tab, items) -> {
            if (event.getTabKey() == tab) {
                items.forEach(item -> event.m_246326_((ItemLike)item.get()));
            }
        });
    }

    private static Item.Properties props() {
        return new Item.Properties();
    }

    static {
        V.init();
    }

    public static class V {
        public static final RegistryObject<Item> HUMAN_HEART = V.item("human_heart");
        public static final RegistryObject<Item> INJECTION_EMPTY = V.item("injection_empty");
        public static final RegistryObject<Item> WEAK_HUMAN_HEART = V.item("weak_human_heart");
        public static final RegistryObject<Item> OBLIVION_POTION = V.item("oblivion_potion");
        public static final RegistryObject<Item> VAMPIRE_BOOK = V.item("vampire_book");
        public static final RegistryObject<Item> CROSSBOW_ARROW_NORMAL = V.item("crossbow_arrow_normal");

        private static RegistryObject<Item> item(String name) {
            return RegistryObject.create((ResourceLocation)new ResourceLocation("vampirism", name), (ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"werewolves");
        }

        private static void init() {
        }
    }
}

