/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import de.teamlapen.werewolves.world.loot.MobLootModifier;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModLootTables {
    private static final Map<ResourceLocation, ResourceLocation> INJECTION_TABLES = Maps.newHashMap();
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLOBAL_LOOT_MODIFIER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"werewolves");
    public static final RegistryObject<Codec<MobLootModifier>> MOB_MODIFIER = GLOBAL_LOOT_MODIFIER.register("mob_modifier", () -> MobLootModifier.CODEC);
    public static final ResourceLocation villager = ModLootTables.entity(EntityType.f_20492_);
    public static final ResourceLocation skeleton = ModLootTables.entity(EntityType.f_20524_);
    public static final ResourceLocation abandoned_mineshaft = ModLootTables.chest("abandoned_mineshaft");
    public static final ResourceLocation jungle_temple = ModLootTables.chest("jungle_temple");
    public static final ResourceLocation stronghold_corridor = ModLootTables.chest("stronghold_corridor");
    public static final ResourceLocation desert_pyramid = ModLootTables.chest("desert_pyramid");
    public static final ResourceLocation stronghold_library = ModLootTables.chest("stronghold_library");

    static void register(IEventBus bus) {
        GLOBAL_LOOT_MODIFIER.register(bus);
    }

    static ResourceLocation entity(EntityType<?> type) {
        ResourceLocation loc = type.m_20677_();
        ResourceLocation newLoc = new ResourceLocation("werewolves", "inject/entity/" + loc.m_135815_());
        INJECTION_TABLES.put(loc, newLoc);
        return newLoc;
    }

    static ResourceLocation chest(String chest) {
        ResourceLocation loc = new ResourceLocation("chests/" + chest);
        ResourceLocation newLoc = new ResourceLocation("werewolves", "inject/chest/" + chest);
        INJECTION_TABLES.put(loc, newLoc);
        return newLoc;
    }

    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent event) {
        if (INJECTION_TABLES.containsKey(event.getName())) {
            try {
                event.getTable().addPool(ModLootTables.getInjectPool(event.getName()));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private static LootPool getInjectPool(ResourceLocation loc) {
        LootTableReference.m_79776_((ResourceLocation)INJECTION_TABLES.get(loc)).m_79707_(1);
        return LootPool.m_79043_().name("werewolves_inject_pool").m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)INJECTION_TABLES.get(loc)).m_79707_(1)).m_79082_();
    }

    @NotNull
    public static Set<ResourceLocation> getLootTables() {
        return ImmutableSet.copyOf(INJECTION_TABLES.values());
    }
}

