/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModCommands;
import de.teamlapen.werewolves.core.ModContainer;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModEntityActions;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModLootTables;
import de.teamlapen.werewolves.core.ModMinionTasks;
import de.teamlapen.werewolves.core.ModOils;
import de.teamlapen.werewolves.core.ModRecipes;
import de.teamlapen.werewolves.core.ModRefinementSets;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.core.ModTasks;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.core.ModVillage;
import de.teamlapen.werewolves.world.gen.WerewolvesBiomeFeatures;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.MissingMappingsEvent;

public class RegistryManager
implements IInitListener {
    public static void setupRegistries(IEventBus bus) {
        ModBlocks.register(bus);
        ModItems.register(bus);
        ModAttributes.register(bus);
        ModContainer.register(bus);
        ModEffects.register(bus);
        ModEntities.register(bus);
        ModRecipes.register(bus);
        ModRefinements.register(bus);
        ModRefinementSets.register(bus);
        ModSounds.register(bus);
        ModTasks.register(bus);
        ModTiles.register(bus);
        ModVillage.register(bus);
        ModLootTables.register(bus);
        ModCommands.register(bus);
        ModActions.register(bus);
        ModSkills.register(bus);
        ModOils.register(bus);
        ModMinionTasks.register(bus);
        ModEntityActions.register(bus);
    }

    public RegistryManager() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register(ModContainer.class);
        bus.addListener(ModEntities::onRegisterEntityTypeAttributes);
        bus.addListener(ModEntities::onModifyEntityTypeAttributes);
        MinecraftForge.EVENT_BUS.addListener(this::onMissingMappings);
    }

    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        switch (step) {
            case COMMON_SETUP: {
                ModEntities.registerSpawns();
                WerewolvesBiomeFeatures.init();
                event.enqueueWork(ModVillage::villageTradeSetup);
                break;
            }
        }
    }

    public void onMissingMappings(MissingMappingsEvent event) {
        ModItems.remapItems(event);
    }
}

