/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(@NotNull PackOutput packOutput, @NotNull ExistingFileHelper existingFileHelper) {
        super(packOutput, "werewolves", existingFileHelper);
    }

    protected void registerModels() {
        HashSet<Supplier<? extends Block>> blockParent = new HashSet<Supplier<? extends Block>>(){
            {
                this.add(ModBlocks.SILVER_ORE);
                this.add(ModBlocks.DEEPSLATE_SILVER_ORE);
                this.add(ModBlocks.SILVER_BLOCK);
                this.add(ModBlocks.RAW_SILVER_BLOCK);
                this.add(ModBlocks.JACARANDA_LEAVES);
                this.add(ModBlocks.JACARANDA_LOG);
                this.add(ModBlocks.MAGIC_LEAVES);
                this.add(ModBlocks.MAGIC_LOG);
                this.add(ModBlocks.MAGIC_PLANKS);
                this.add(ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF);
                this.add(ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF_CRAFTED);
            }
        };
        HashSet<Supplier<? extends Item>> itemsLayer = new HashSet<Supplier<? extends Item>>(){
            {
                this.add(ModItems.SILVER_INGOT);
                this.add(ModItems.LIVER);
                this.add(ModItems.CRACKED_BONE);
                this.add(ModItems.INJECTION_UN_WEREWOLF);
                this.add(ModItems.WEREWOLF_TOOTH);
                this.add(ModItems.WEREWOLF_MINION_CHARM);
                this.add(ModItems.WEREWOLF_MINION_UPGRADE_SIMPLE);
                this.add(ModItems.WEREWOLF_MINION_UPGRADE_ENHANCED);
                this.add(ModItems.WEREWOLF_MINION_UPGRADE_SPECIAL);
                this.add(ModItems.SILVER_NUGGET);
            }
        };
        HashSet<Supplier<? extends Block>> blockLayer = new HashSet<Supplier<? extends Block>>(){
            {
                this.add(ModBlocks.JACARANDA_SAPLING);
                this.add(ModBlocks.MAGIC_SAPLING);
                this.add(ModBlocks.WOLFSBANE);
            }
        };
        HashSet<Supplier<? extends Item>> itemsHandHeld = new HashSet<Supplier<? extends Item>>(){
            {
                this.add(ModItems.SILVER_AXE);
                this.add(ModItems.SILVER_PICKAXE);
                this.add(ModItems.SILVER_SWORD);
                this.add(ModItems.SILVER_SHOVEL);
                this.add(ModItems.SILVER_HOE);
            }
        };
        blockParent.stream().map(Supplier::get).forEach(this::block);
        itemsLayer.stream().map(Supplier::get).forEach(x$0 -> this.item((Item)x$0, new ResourceLocation[0]));
        blockLayer.stream().map(Supplier::get).forEach(x$0 -> this.blockLayer((Block)x$0, new ResourceLocation[0]));
        itemsHandHeld.stream().map(Supplier::get).forEach(item -> this.item((Item)item, "item/handheld", new ResourceLocation[0]));
        this.withExistingParent((Item)ModItems.WEREWOLF_BEAST_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.WEREWOLF_SURVIVALIST_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.HUMAN_WEREWOLF_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.ALPHA_WEREWOLF_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.item((Item)ModItems.DREAM_CATCHER.get(), this.modLoc("item/dream_catcher_layer0"), this.modLoc("item/dream_catcher_layer1"));
        this.item((Item)ModItems.CHARM_BRACELET.get(), this.modLoc("item/charm_bracelet_layer0"), this.modLoc("item/charm_bracelet_layer1"));
        this.item((Item)ModItems.BONE_NECKLACE.get(), this.modLoc("item/bone_necklace_layer0"), this.modLoc("item/bone_necklace_layer1"));
        this.item((Item)ModItems.RAW_SILVER.get(), new ResourceLocation[0]);
    }

    @Nonnull
    public String m_6055_() {
        return "Werewolves item model generator";
    }

    public ItemModelBuilder item(String item, ResourceLocation ... texture) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated"));
        for (int i = 0; i < texture.length; ++i) {
            model.texture("layer" + i, texture[i]);
        }
        return model;
    }

    public ItemModelBuilder item(Item item, ResourceLocation ... texture) {
        return this.item(item, "item/generated", texture);
    }

    public ItemModelBuilder item(Item item, String parent, ResourceLocation ... texture) {
        if (texture.length == 0) {
            return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc(parent)).texture("layer0", "werewolves:item/" + RegUtil.id((Item)item).m_135815_());
        }
        return this.item(RegUtil.id((Item)item).m_135815_(), texture);
    }

    public ItemModelBuilder blockLayer(Block item, ResourceLocation ... texture) {
        if (texture.length == 0) {
            return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated")).texture("layer0", "werewolves:block/" + RegUtil.id((Block)item).m_135815_());
        }
        return this.item(RegUtil.id((Block)item).m_135815_(), texture);
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Item name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(RegUtil.id((Item)name).m_135815_(), parent);
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Item name, Item parent) {
        return this.withExistingParent(name, RegUtil.id((Item)parent));
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Block name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(RegUtil.id((Block)name).m_135815_(), parent);
    }

    public ItemModelBuilder block(Block name) {
        try {
            return (ItemModelBuilder)super.withExistingParent(RegUtil.id((Block)name).m_135815_(), "werewolves:block/" + RegUtil.id((Block)name).m_135815_());
        }
        catch (IllegalStateException e) {
            return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RegUtil.id((Block)name).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("werewolves:block/" + RegUtil.id((Block)name).m_135815_()));
        }
    }
}

