/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.util.TotemHelper;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModDamageTypes;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.effects.SilverEffect;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.mixin.GoalSelectorAccessor;
import de.teamlapen.werewolves.mixin.NearestAttackabletargetGoalAccessor;
import de.teamlapen.werewolves.mixin.TargetingConditionsAccessor;
import de.teamlapen.werewolves.network.ClientboundAttackTargetEventPacket;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModEntityEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Predicate<LivingEntity> nonWerewolfCheck = entity -> !Helper.isWerewolf((Entity)entity);
    private static final Object2BooleanMap<String> entityAIReplacementWarnMap = new Object2BooleanArrayMap();
    private static final UUID ARMOR_REDUCTION = UUID.fromString("5b7612e9-1847-435c-b4eb-a455af4ce8c7");

    @SubscribeEvent
    public void onEntityAttacked(AttackEntityEvent event) {
        if (event.getTarget() instanceof LivingEntity && Helper.isWerewolf(event.getTarget()) && event.getEntity().m_21205_().m_204117_(ModTags.Items.SILVER_TOOL)) {
            ((LivingEntity)event.getTarget()).m_7292_(SilverEffect.createEffect((LivingEntity)event.getTarget(), (Integer)WerewolvesConfig.BALANCE.UTIL.silverItemEffectDuration.get()));
        }
        if (event.getTarget() instanceof WerewolfTransformable && ((WerewolfTransformable)event.getTarget()).canTransform()) {
            ((WerewolfTransformable)event.getTarget()).transformToWerewolf(TransformType.TIME_LIMITED);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        AttributeInstance s = event.getEntity().m_21051_(Attributes.f_22284_);
        if (s != null) {
            s.m_22120_(ARMOR_REDUCTION);
            if (event.getSource().m_7639_() != null && Helper.isWerewolf(event.getSource().m_7639_())) {
                HashSet modifiers = new HashSet();
                int i = 0;
                for (ItemStack stack : event.getEntity().m_6168_()) {
                    modifiers.addAll(stack.m_41638_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i++)).get((Object)Attributes.f_22284_));
                }
                AttributeInstance tmp = new AttributeInstance(Attributes.f_22284_, a -> {});
                s.m_22122_().stream().filter(modifiers::contains).forEach(arg_0 -> ((AttributeInstance)tmp).m_22118_(arg_0));
                double value = s.m_22135_() - (s.m_22135_() - tmp.m_22135_());
                float levelModifier = WerewolfPlayer.getOptEx(event.getSource().m_7639_()).map(player -> Float.valueOf((float)player.getLevel() / (float)player.getMaxLevel())).orElse(Float.valueOf(1.0f)).floatValue();
                s.m_22118_(new AttributeModifier(ARMOR_REDUCTION, "werewolf_attack", -value * ((event.getSource().m_276093_(ModDamageTypes.BITE) ? 0.8 : 0.3) * (double)levelModifier), AttributeModifier.Operation.ADDITION));
            }
        }
        if (Helper.isWerewolf((Entity)event.getEntity()) && !event.getSource().m_269533_(DamageTypeTags.f_268731_)) {
            float damage = event.getAmount();
            float damageReduction = FormHelper.getForm(event.getEntity()).getDamageReduction();
            damageReduction *= event.getEntity() instanceof Player ? WerewolfPlayer.getOpt((Player)event.getEntity()).filter(a -> !a.getForm().isHumanLike()).filter(a -> a.getSkillHandler().isSkillEnabled((ISkill)ModSkills.THICK_FUR.get())).map(a -> (Double)WerewolvesConfig.BALANCE.SKILLS.thick_fur_multiplier.get()).orElse(1.0).floatValue() : 1.0f;
            if (event.getSource().m_7639_() != null && Helper.isVampire((Entity)event.getSource().m_7639_())) {
                damageReduction = (float)((double)damageReduction * 0.3);
            }
            event.setAmount(Mth.m_14036_((float)(damage -= event.getAmount() * damageReduction), (float)0.0f, (float)Float.MAX_VALUE));
        }
    }

    @SubscribeEvent
    public void onTargetChange(LivingChangeTargetEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getNewTarget();
        if (livingEntity instanceof ServerPlayer && Helper.isWerewolf((Player)(player = (ServerPlayer)livingEntity))) {
            WerewolfPlayer.getOpt((Player)player).filter(werewolf -> werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.SIXTH_SENSE.get())).ifPresent(werewolf -> WerewolvesMod.dispatcher.sendTo((IMessage.IClientBoundMessage)new ClientboundAttackTargetEventPacket(event.getEntity().m_19879_()), player));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (event.getEntity() instanceof Villager) {
            TotemHelper.getTotemNearPos((ServerLevel)((ServerLevel)event.getLevel()), (BlockPos)event.getEntity().m_20183_(), (boolean)true).ifPresent(totem -> {
                if (WReference.WEREWOLF_FACTION.equals((Object)totem.getControllingFaction()) && ((Villager)event.getEntity()).m_217043_().m_188503_(6) == 0) {
                    ((IVillagerTransformable)event.getEntity()).setWerewolfFaction(true);
                }
            });
        }
        if (((Boolean)WerewolvesConfig.BALANCE.UTIL.skeletonIgnoreWerewolves.get()).booleanValue() && (event.getEntity() instanceof Skeleton || event.getEntity() instanceof Stray)) {
            ModEntityEventHandler.makeWerewolfFriendly("skeleton", (AbstractSkeleton)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, (entity, predicate) -> new NearestAttackableTargetGoal((Mob)entity, Player.class, 10, true, false, predicate), type -> type == EntityType.f_20524_ || type == EntityType.f_20481_);
        }
    }

    public static <T extends Mob, S extends LivingEntity, Q extends NearestAttackableTargetGoal<S>> void makeWerewolfFriendly(String name, T entity, Class<Q> targetClass, Class<S> targetEntityClass, int attackPriority, BiFunction<T, Predicate<LivingEntity>, Q> replacement, Predicate<EntityType<? extends T>> typeCheck) {
        try {
            Goal target = null;
            for (WrappedGoal t : ((GoalSelectorAccessor)entity.f_21346_).getAvailableGoals()) {
                Goal g = t.m_26015_();
                if (!targetClass.equals(g.getClass()) || t.m_26012_() != attackPriority || !targetEntityClass.equals(((NearestAttackabletargetGoalAccessor)g).getTargetType())) continue;
                target = g;
                break;
            }
            if (target != null) {
                entity.f_21346_.m_25363_(target);
                EntityType type = entity.m_6095_();
                if (typeCheck.test(type)) {
                    Predicate<LivingEntity> newPredicate = nonWerewolfCheck;
                    if (((TargetingConditionsAccessor)((NearestAttackabletargetGoalAccessor)target).getTargetConditions()).getSelector() != null) {
                        newPredicate = newPredicate.and(((TargetingConditionsAccessor)((NearestAttackabletargetGoalAccessor)target).getTargetConditions()).getSelector());
                    }
                    entity.f_21346_.m_25352_(attackPriority, (Goal)replacement.apply(entity, newPredicate));
                }
            } else if (entityAIReplacementWarnMap.getOrDefault((Object)name, true)) {
                LOGGER.warn("Could not replace {} attack target task for {}", (Object)name, (Object)entity.m_6095_().m_20676_());
                entityAIReplacementWarnMap.put((Object)name, false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not replace " + name + " attack target task for " + entity.m_6095_().m_20676_(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        AttributeInstance s = event.getEntity().m_21051_(Attributes.f_22284_);
        if (s != null) {
            s.m_22120_(ARMOR_REDUCTION);
        }
        WerewolfPlayer.getOptEx(event.getSource().m_7639_()).filter(w -> w.getForm() == WerewolfForm.BEAST).filter(w -> w.getSkillHandler().isSkillEnabled((ISkill)ModSkills.THROAT_SEEKER.get()) && !UtilLib.canReallySee((LivingEntity)event.getEntity(), (LivingEntity)w.getRepresentingPlayer(), (boolean)true)).ifPresent(werewolf -> {
            if ((double)(event.getEntity().m_21223_() / event.getEntity().m_21233_()) < 0.25 && werewolf.getRepresentingPlayer().m_217043_().m_188503_(4) < 1) {
                event.setAmount(10000.0f);
            }
        });
    }
}

