/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.client.gui.WerewolfMinionAppearanceScreen;
import de.teamlapen.werewolves.client.gui.WerewolfMinionStatsScreen;
import de.teamlapen.werewolves.core.ModMinionTasks;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.items.WerewolfMinionUpgradeItem;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class WerewolfMinionEntity
extends MinionEntity<WerewolfMinionData>
implements IWerewolf {
    public static void registerMinionData() {
        MinionData.registerDataType((ResourceLocation)WerewolfMinionData.ID, WerewolfMinionData::new);
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return BasicWerewolfEntity.getAttributeBuilder();
    }

    public WerewolfMinionEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(WReference.WEREWOLF_FACTION, true, true, false, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof Enemy && !(e instanceof Creeper)));
    }

    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{(IMinionTask)ModMinionTasks.V.FOLLOW_LORD.get(), (IMinionTask)ModMinionTasks.V.DEFEND_AREA.get(), (IMinionTask)ModMinionTasks.V.STAY.get(), (IMinionTask)ModMinionTasks.V.PROTECT_LORD.get(), (IMinionTask)ModMinionTasks.COLLECT_WEREWOLF_ITEMS.get()});
    }

    public boolean shouldRenderLordSkin() {
        return false;
    }

    @Nonnull
    public IFaction<?> getFaction() {
        return WReference.WEREWOLF_FACTION;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new WerewolfMinionAppearanceScreen(this, Minecraft.m_91087_().f_91080_)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new WerewolfMinionStatsScreen(this, Minecraft.m_91087_().f_91080_)));
    }

    protected boolean canConsume(ItemStack stack) {
        if (!super.canConsume(stack)) {
            return false;
        }
        if (stack.m_41614_() && !Helper.canWerewolfEatItem((LivingEntity)this, stack)) {
            return false;
        }
        boolean fullHealth = this.m_21223_() == this.m_21233_();
        return !fullHealth || !stack.m_41614_();
    }

    @Nonnull
    public ItemStack m_5584_(@Nonnull Level world, @Nonnull ItemStack stack) {
        if (stack.m_41614_() && Helper.isRawMeat(stack)) {
            float healAmount = (float)stack.m_41720_().m_41473_().m_38744_() / 2.0f;
            this.m_5634_(healAmount);
        }
        return super.m_5584_(world, stack);
    }

    protected void onMinionDataReceived(@Nonnull WerewolfMinionData data) {
        super.onMinionDataReceived((MinionData)data);
        this.updateAttributes();
    }

    public Predicate<ItemStack> getEquipmentPredicate(EquipmentSlot slotType) {
        return itemStack -> itemStack.m_41720_() instanceof IFactionExclusiveItem && ((IFactionExclusiveItem)itemStack.m_41720_()).getExclusiveFaction(itemStack).equals(WReference.WEREWOLF_FACTION) || itemStack.m_41780_() == UseAnim.DRINK || itemStack.m_41780_() == UseAnim.EAT;
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack heldItem;
        if (!this.m_9236_().m_5776_() && this.isLord(player) && this.minionData != null && (heldItem = player.m_21120_(hand)).m_41720_() instanceof WerewolfMinionUpgradeItem && ((WerewolfMinionUpgradeItem)heldItem.m_41720_()).getFaction() == this.getFaction()) {
            if (((WerewolfMinionData)this.minionData).level + 1 >= ((WerewolfMinionUpgradeItem)heldItem.m_41720_()).getMinLevel() && ((WerewolfMinionData)this.minionData).level + 1 <= ((WerewolfMinionUpgradeItem)heldItem.m_41720_()).getMaxLevel()) {
                ++((WerewolfMinionData)this.minionData).level;
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.werewolf_minion.equipment_upgrade"), false);
                HelperLib.sync((Entity)this);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.werewolf_minion.equipment_wrong"), false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.minionData != null ? ((WerewolfMinionData)this.minionData).form : WerewolfForm.NONE;
    }

    @Override
    public int getSkinType(WerewolfForm form) {
        return this.minionData != null ? ((WerewolfMinionData)this.minionData).skinType : 0;
    }

    @Override
    public int getEyeType(WerewolfForm form) {
        return this.minionData != null ? ((WerewolfMinionData)this.minionData).eyeType : 0;
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return this.minionData != null && ((WerewolfMinionData)this.minionData).glowingEyes;
    }

    private void updateAttributes() {
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22276_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.m_22100_(45.0 + 5.0 * (double)this.getMinionData().map(WerewolfMinionData::getHealthLevel).orElse(0).intValue());
        AttributeInstance attributeInstance2 = this.m_21051_(Attributes.f_22281_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance2.m_22100_(3.0 + 1.0 * (double)this.getMinionData().map(WerewolfMinionData::getStrengthLevel).orElse(0).intValue());
        AttributeInstance attributeInstance3 = this.m_21051_(Attributes.f_22279_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance3.m_22100_(0.28);
    }

    public void setEyeType(int type) {
        this.getMinionData().ifPresent(d -> {
            d.eyeType = type;
        });
    }

    public void setSkinType(int type) {
        this.getMinionData().ifPresent(d -> {
            d.skinType = type;
        });
    }

    public void setGlowingEyes(boolean glowing) {
        this.getMinionData().ifPresent(d -> {
            d.glowingEyes = glowing;
        });
    }

    public static class WerewolfMinionData
    extends MinionData {
        public static final ResourceLocation ID = new ResourceLocation("werewolves", "werewolf");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_RESOURCES = 2;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int resourceEfficiencyLevel;
        private int skinType;
        private int eyeType;
        private boolean glowingEyes;
        private WerewolfForm form = WerewolfForm.BEAST;

        public WerewolfMinionData(String name, int skinType, int eyeType, boolean glowingEyes, WerewolfForm form) {
            super(name, 9);
            assert (!form.isHumanLike());
            this.level = 0;
            this.skinType = skinType;
            this.eyeType = eyeType;
            this.glowingEyes = glowingEyes;
            this.form = form;
        }

        private WerewolfMinionData() {
        }

        public MutableComponent getFormattedName() {
            return super.getFormattedName().m_130938_(style -> style.m_131148_(WReference.WEREWOLF_FACTION.getChatColor()));
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        public int getLevel() {
            return this.level;
        }

        public int getSkinType() {
            return this.skinType;
        }

        public int getEyeType() {
            return this.eyeType;
        }

        public boolean hasGlowingEyes() {
            return this.glowingEyes;
        }

        public int getResourceEfficiencyLevel() {
            return this.resourceEfficiencyLevel;
        }

        public WerewolfForm getForm() {
            return this.form;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.strengthLevel - this.resourceEfficiencyLevel);
        }

        public boolean hasUsedSkillPoints() {
            return this.inventoryLevel + this.healthLevel + this.strengthLevel + this.resourceEfficiencyLevel > 0;
        }

        public void resetStats(MinionEntity<?> entity) {
            this.inventoryLevel = 0;
            this.strengthLevel = 0;
            this.healthLevel = 0;
            this.resourceEfficiencyLevel = 0;
            this.shrinkInventory(entity);
            super.resetStats(entity);
        }

        public int getInventorySize() {
            int size = this.getDefaultInventorySize();
            return this.inventoryLevel == 1 ? size + 3 : (this.inventoryLevel == 2 ? size + 6 : size);
        }

        public void handleMinionAppearanceConfig(String name, int ... data) {
            this.setName(name);
            this.skinType = data[0];
            this.eyeType = data[1];
            this.glowingEyes = data[2] == 1;
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        public boolean upgradeStat(int statId, MinionEntity<?> entity) {
            if (super.upgradeStat(statId, entity)) {
                return true;
            }
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof WerewolfMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((WerewolfMinionEntity)entity).updateAttributes();
                    entity.m_21153_(entity.m_21233_());
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((WerewolfMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.resourceEfficiencyLevel >= 2) {
                        return false;
                    }
                    ++this.resourceEfficiencyLevel;
                    ((WerewolfMinionEntity)entity).updateAttributes();
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.level = nbt.m_128451_("level");
            this.inventoryLevel = nbt.m_128451_("l_inv");
            this.healthLevel = nbt.m_128451_("l_he");
            this.strengthLevel = nbt.m_128451_("l_str");
            this.resourceEfficiencyLevel = nbt.m_128451_("l_res");
            this.skinType = nbt.m_128451_("s_type");
            this.eyeType = nbt.m_128451_("e_type");
            this.glowingEyes = nbt.m_128471_("e_glow");
            this.form = WerewolfForm.getForm(nbt.m_128461_("form"));
        }

        public void serializeNBT(CompoundTag tag) {
            super.serializeNBT(tag);
            tag.m_128405_("level", this.level);
            tag.m_128405_("l_inv", this.inventoryLevel);
            tag.m_128405_("l_he", this.healthLevel);
            tag.m_128405_("l_str", this.strengthLevel);
            tag.m_128405_("l_res", this.resourceEfficiencyLevel);
            tag.m_128405_("s_type", this.skinType);
            tag.m_128405_("e_type", this.eyeType);
            tag.m_128379_("e_glow", this.glowingEyes);
            tag.m_128359_("form", this.form.getName());
        }

        protected ResourceLocation getDataType() {
            return ID;
        }
    }
}

