/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.items.VampirismItemBloodFoodItem;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.effects.inst.UnWerewolfEffectInstance;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.items.UnWerewolfInjectionItem;
import de.teamlapen.werewolves.mixin.LivingEntityAccessor;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.REFERENCE;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPlayerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final UUID CLAWS = UUID.fromString("70435284-afcd-4470-85c2-d9b36b3d94e8");

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            try {
                event.addCapability(REFERENCE.WEREWOLF_PLAYER_KEY, WerewolfPlayer.createNewCapability((Player)event.getObject()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to attach capabilities to player. Player: {}", event.getObject());
                throw e;
            }
        }
    }

    @SubscribeEvent
    public void onFootEatenStart(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity()) && !Helper.canWerewolfPlayerEatItem((Player)event.getEntity(), event.getItem())) {
            event.setCanceled(true);
            ((Player)event.getEntity()).m_5661_((Component)Component.m_237115_((String)"text.werewolves.no_meat"), true);
        }
    }

    @SubscribeEvent
    public void onFootEatenFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity())) {
            if (Helper.isRawMeat(event.getItem())) {
                ((Player)event.getEntity()).m_36324_().m_38712_(event.getItem().m_41720_(), event.getItem());
            }
            if (event.getItem().m_41720_() instanceof VampirismItemBloodFoodItem) {
                event.getEntity().m_21195_(MobEffects.f_19604_);
            }
        }
    }

    @SubscribeEvent
    public void onKilled(LivingDeathEvent event) {
        if (event.getSource().m_7639_() instanceof Player && Helper.isWerewolf((Player)event.getSource().m_7639_())) {
            WerewolfPlayer player = WerewolfPlayer.get((Player)event.getSource().m_7639_());
            if (player.getSkillHandler().isSkillEnabled((ISkill)ModSkills.HEALTH_AFTER_KILL.get())) {
                ((Player)event.getSource().m_7639_()).m_7292_(new MobEffectInstance(MobEffects.f_19605_, player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.HEALTH_AFTER_KILL.get()) ? 5 : 4, 10));
            }
            ((Player)event.getSource().m_7639_()).m_36324_().m_38717_(((Player)event.getSource().m_7639_()).m_36324_().m_38722_() + 0.5f);
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)event.getEntity());
            if (werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PAWN.get())) {
                event.setDistance(event.getDistance() * 0.8f);
                event.setDamageMultiplier(event.getDamageMultiplier() * 0.8f);
            }
            if (werewolf.getSpecialAttributes().leap) {
                werewolf.getActionHandler().toggleAction((IAction)ModActions.LEAP.get(), (IAction.ActivationContext)new ActionHandler.ActivationContext());
            }
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity()) && WerewolfPlayer.get((Player)event.getEntity()).getForm().isTransformed()) {
            if (event.getTo().m_41619_()) {
                if (((Player)event.getEntity()).m_21051_(Attributes.f_22281_).m_22111_(CLAWS) == null) {
                    // empty if block
                }
            } else {
                ((Player)event.getEntity()).m_21051_(Attributes.f_22281_).m_22120_(CLAWS);
            }
            WerewolfPlayer.getOpt((Player)event.getEntity()).filter(werewolf -> !werewolf.getForm().isHumanLike() || !werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WEAR_ARMOR.get())).ifPresent(WerewolfPlayer::requestArmorEvaluation);
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof Player && Helper.isWerewolf((Player)event.getEntity())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((Player)event.getEntity());
            if (werewolf.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PAWN.get())) {
                Vec3 motion = event.getEntity().m_20184_().m_82542_(1.1, 1.2, 1.1);
                event.getEntity().m_20256_(motion);
            }
            if (werewolf.getActionHandler().isActionActive((ILastingAction)ModActions.LEAP.get())) {
                if (werewolf.getSpecialAttributes().leap) {
                    werewolf.getActionHandler().toggleAction((IAction)ModActions.LEAP.get(), (IAction.ActivationContext)new ActionHandler.ActivationContext());
                } else {
                    werewolf.getSpecialAttributes().leap = true;
                    Vec3 vector3d = event.getEntity().m_20184_();
                    event.getEntity().m_20334_(vector3d.f_82479_, vector3d.f_82480_ + (double)((LivingEntityAccessor)event.getEntity()).invokeGetJumpPower_werewolves() * 0.3, vector3d.f_82481_);
                }
            } else {
                werewolf.getSpecialAttributes().leap = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWakeUp(PlayerWakeUpEvent event) {
        if (!event.getEntity().m_9236_().f_46443_ && event.getEntity().m_21124_((MobEffect)ModEffects.LUPUS_SANGUINEM.get()) != null) {
            event.getEntity().m_21124_((MobEffect)ModEffects.LUPUS_SANGUINEM.get()).m_19550_((LivingEntity)event.getEntity());
            event.getEntity().m_21195_((MobEffect)ModEffects.LUPUS_SANGUINEM.get());
        }
    }

    @SubscribeEvent
    public void onItemUseEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().m_21120_(event.getHand()).m_41720_() == ModItems.V.INJECTION_EMPTY.get() && event.getTarget() instanceof WerewolfBaseEntity) {
            event.getEntity().m_21120_(event.getHand()).m_41774_(1);
            event.getEntity().m_36356_(((UnWerewolfInjectionItem)((Object)ModItems.INJECTION_UN_WEREWOLF.get())).m_7968_());
        }
    }

    @SubscribeEvent
    public void onItemUseBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player.m_21120_(event.getHand()).m_41720_() == ModItems.INJECTION_UN_WEREWOLF.get()) {
            if (event.getLevel().m_8055_(event.getPos()).m_60734_() == ModBlocks.V.MED_CHAIR.get()) {
                ItemStack stack = player.m_21120_(event.getHand());
                if (player.m_6084_()) {
                    FactionPlayerHandler handler = FactionPlayerHandler.get((Player)event.getEntity());
                    IPlayableFaction faction = handler.getCurrentFaction();
                    boolean used = false;
                    if (WReference.WEREWOLF_FACTION.equals((Object)faction)) {
                        if (player.m_21124_((MobEffect)ModEffects.UN_WEREWOLF.get()) == null) {
                            player.m_7292_((MobEffectInstance)new UnWerewolfEffectInstance(2000));
                            used = true;
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.injection.in_use"), true);
                        }
                    } else if (faction != null) {
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.injection.not_use"), true);
                    }
                    if (used) {
                        stack.m_41774_(1);
                        if (stack.m_41619_()) {
                            player.m_150109_().m_36057_(stack);
                        }
                    }
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerSize(EntityEvent.Size event) {
        LazyOptional<WerewolfPlayer> werewolf;
        Optional size;
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).m_150109_() != null && event.getEntity().m_6084_() && (size = (werewolf = WerewolfPlayer.getOpt((Player)event.getEntity())).map(WerewolfPlayer::getForm).flatMap(form -> form.getSize(event.getPose()))).isPresent()) {
            event.setNewSize((EntityDimensions)size.get());
            event.setNewEyeHeight(((EntityDimensions)size.get()).f_20378_ * 0.85f);
        }
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isWerewolf(player = (Player)livingEntity)) {
            if (player.m_20142_() && event.getSource().m_7639_() != null) {
                WerewolfPlayer.getOpt(player).filter(w -> w.getForm() == WerewolfForm.SURVIVALIST).map(WerewolfPlayer::getSkillHandler).ifPresent(skillHandler -> {
                    if (skillHandler.isSkillEnabled((ISkill)ModSkills.MOVEMENT_TACTICS.get())) {
                        float limit = ((Double)WerewolvesConfig.BALANCE.SKILLS.movement_tactics_doge_chance.get()).floatValue();
                        if (skillHandler.isRefinementEquipped((IRefinement)ModRefinements.GREATER_DOGE_CHANCE.get())) {
                            limit += ((Double)WerewolvesConfig.BALANCE.REFINEMENTS.greater_doge_chance.get()).floatValue();
                        }
                        if (player.m_217043_().m_188501_() < limit) {
                            event.setCanceled(true);
                        }
                    }
                });
            } else if (event.getSource().m_269533_(ModTags.DamageTypes.WEREWOLF_FUR_IMMUNE) && WerewolfPlayer.getOpt(player).filter(w -> w.getForm().isTransformed()).map(w -> w.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PAWN.get())).orElse(false).booleanValue()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onMountEvent(EntityMountEvent event) {
        if (event.isMounting() && WerewolfPlayer.getOptEx(event.getEntityMounting()).map(p -> !p.getForm().isHumanLike()).orElse(false).booleanValue()) {
            event.setCanceled(true);
            ((Player)event.getEntityMounting()).m_5661_((Component)Component.m_237115_((String)"text.werewolves.nomount.transformed"), true);
        }
    }
}

