/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.entity.player.FactionBasePlayer;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.effects.inst.WerewolfNightVisionEffectInstance;
import de.teamlapen.werewolves.entities.player.werewolf.LevelHandler;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayerSpecialAttributes;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.mixin.ArmorItemAccessor;
import de.teamlapen.werewolves.mixin.FoodStatsAccessor;
import de.teamlapen.werewolves.util.DamageHandler;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.NBTHelper;
import de.teamlapen.werewolves.util.Permissions;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WerewolfPlayer
extends FactionBasePlayer<IWerewolfPlayer>
implements IWerewolfPlayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final UUID ARMOR_TOUGHNESS = UUID.fromString("f3979aec-b8ef-4e95-84a7-2c6dab8ea46e");
    public static final Capability<IWerewolfPlayer> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IWerewolfPlayer>(){});
    @Nonnull
    private final ActionHandler<IWerewolfPlayer> actionHandler;
    @Nonnull
    private final SkillHandler<IWerewolfPlayer> skillHandler;
    @Nonnull
    private final WerewolfPlayerSpecialAttributes specialAttributes = new WerewolfPlayerSpecialAttributes();
    @Nonnull
    private WerewolfForm form = WerewolfForm.NONE;
    @Nullable
    private WerewolfFormAction lastFormAction;
    @Nonnull
    private final LevelHandler levelHandler = new LevelHandler(this);
    private boolean checkArmorModifer;
    private final Map<WerewolfForm, Integer> eyeType = new HashMap<WerewolfForm, Integer>();
    private final Map<WerewolfForm, Integer> skinType = new HashMap<WerewolfForm, Integer>();
    private final Map<WerewolfForm, Boolean> glowingEyes = new HashMap<WerewolfForm, Boolean>();

    private void applyEntityAttributes() {
        try {
            this.player.m_21051_((Attribute)ModAttributes.BITE_DAMAGE.get());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public static WerewolfPlayer get(@Nonnull Player playerEntity) {
        return (WerewolfPlayer)playerEntity.getCapability(CAP).orElseThrow(() -> new IllegalStateException("Cannot get werewolf player capability from player" + playerEntity));
    }

    public static LazyOptional<WerewolfPlayer> getOpt(@Nonnull Player playerEntity) {
        LazyOptional opt = playerEntity.getCapability(CAP).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Werewolf player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static LazyOptional<WerewolfPlayer> getOptEx(@Nullable Entity entity) {
        if (!(entity instanceof Player) || !Helper.isWerewolf((Player)entity)) {
            return LazyOptional.empty();
        }
        return WerewolfPlayer.getOpt((Player)entity);
    }

    public WerewolfPlayer(@Nonnull Player player) {
        super(player);
        this.actionHandler = new ActionHandler((IFactionPlayer)this);
        this.skillHandler = new SkillHandler((IFactionPlayer)this, WReference.WEREWOLF_FACTION);
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    public void setForm(WerewolfFormAction action, WerewolfForm form) {
        this.switchForm(form);
        this.lastFormAction = action;
        if (!this.player.m_9236_().f_46443_) {
            this.sync(NBTHelper.nbtWith(nbt -> nbt.m_128359_("form", this.form.getName())), true);
        }
    }

    public void switchForm(WerewolfForm form) {
        this.form = form;
        this.player.m_6210_();
    }

    protected FactionBasePlayer<IWerewolfPlayer> copyFromPlayer(Player playerEntity) {
        WerewolfPlayer oldWerewolf = WerewolfPlayer.get(playerEntity);
        CompoundTag nbt = new CompoundTag();
        oldWerewolf.saveData(nbt);
        this.loadData(nbt);
        return oldWerewolf;
    }

    public void requestArmorEvaluation() {
        this.checkArmorModifer = true;
    }

    public void removeArmorModifier() {
        for (UUID uuid : ArmorItemAccessor.getARMOR_MODIFIERS().values()) {
            this.player.m_21051_(Attributes.f_22285_).m_22120_(uuid);
            this.player.m_21051_(Attributes.f_22284_).m_22120_(uuid);
        }
    }

    public void addArmorModifier() {
        HashSet uuids = Sets.newHashSet(ArmorItemAccessor.getARMOR_MODIFIERS().values());
        int i = 0;
        for (ItemStack stack : this.player.m_6168_()) {
            EquipmentSlot slotType = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i);
            ++i;
            Multimap map = stack.m_41638_(slotType);
            for (Map.Entry entry : map.asMap().entrySet()) {
                for (AttributeModifier modifier : (Collection)entry.getValue()) {
                    AttributeInstance attribute;
                    if (!uuids.contains(modifier.m_22209_()) || (attribute = this.player.m_21051_((Attribute)entry.getKey())).m_22109_(modifier)) continue;
                    attribute.m_22125_(modifier);
                }
            }
        }
    }

    public void onChangedDimension(ResourceKey<Level> registryKey, ResourceKey<Level> registryKey1) {
    }

    @Nonnull
    public WerewolfPlayerSpecialAttributes getSpecialAttributes() {
        return this.specialAttributes;
    }

    public void onUpdate() {
        this.player.m_20193_().m_46473_().m_6180_("werewolves_werewolfplayer");
        if (this.getLevel() > 0) {
            if (!this.isRemote()) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundTag syncPacket = new CompoundTag();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    syncToAll = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (this.player.m_9236_().m_46467_() % 10L == 0L) {
                    if (this.specialAttributes.transformationTime > 0.0 && FormHelper.getActiveFormAction(this).map(action -> !action.consumesWerewolfTime()).orElse(true).booleanValue()) {
                        this.specialAttributes.transformationTime = Mth.m_14008_((double)(this.specialAttributes.transformationTime - this.player.m_21051_((Attribute)ModAttributes.TIME_REGAIN.get()).m_22135_()), (double)0.0, (double)1.0);
                        syncPacket.m_128347_("transformationTime", this.specialAttributes.transformationTime);
                    }
                    if (this.player.m_9236_().m_46467_() % 20L == 0L) {
                        if (Helper.isFullMoon(this.getRepresentingPlayer().m_20193_()) && !FormHelper.isFormActionActive(this) && !this.skillHandler.isSkillEnabled((ISkill)ModSkills.FREE_WILL.get())) {
                            Optional<WerewolfFormAction> action2 = this.lastFormAction != null ? Optional.of(this.lastFormAction) : WerewolfFormAction.getAllAction().stream().filter(arg_0 -> this.actionHandler.isActionUnlocked(arg_0)).findAny();
                            action2.ifPresent(a -> this.actionHandler.toggleAction(a, (IAction.ActivationContext)new ActionHandler.ActivationContext()));
                        }
                        if (this.player.m_20069_() && this.player.m_204029_(FluidTags.f_13131_) && !this.skillHandler.isSkillEnabled((ISkill)ModSkills.WATER_LOVER.get())) {
                            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 50, 0, true, true));
                        }
                    }
                }
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.HEALTH_REG.get())) {
                    this.tickFoodStats();
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
                MobEffectInstance effect = this.player.m_21124_(MobEffects.f_19611_);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision) {
                    if (!(effect instanceof WerewolfNightVisionEffectInstance)) {
                        if (effect != null) {
                            this.player.m_6234_(effect.m_19544_());
                        }
                        this.player.m_7292_((MobEffectInstance)new WerewolfNightVisionEffectInstance(effect));
                    }
                } else if (effect instanceof WerewolfNightVisionEffectInstance) {
                    this.player.m_21195_(effect.m_19544_());
                    effect = ((EffectInstanceWithSource)effect).getHiddenEffect();
                    if (effect != null) {
                        this.player.m_7292_(effect);
                    }
                }
            } else {
                this.actionHandler.updateActions();
                if (this.player.m_9236_().m_46467_() % 10L == 0L && this.specialAttributes.transformationTime > 0.0 && FormHelper.getActiveFormAction(this).map(action -> !action.consumesWerewolfTime()).orElse(true).booleanValue()) {
                    this.specialAttributes.transformationTime = Mth.m_14008_((double)(this.specialAttributes.transformationTime - (double)((float)this.player.m_21051_((Attribute)ModAttributes.TIME_REGAIN.get()).m_22135_())), (double)0.0, (double)1.0);
                }
                MobEffectInstance effect = this.player.m_21124_(MobEffects.f_19611_);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision && !(effect instanceof WerewolfNightVisionEffectInstance)) {
                    this.player.m_6234_(MobEffects.f_19611_);
                    this.player.m_7292_((MobEffectInstance)new WerewolfNightVisionEffectInstance());
                }
            }
            if (this.checkArmorModifer && this.form.isTransformed()) {
                if (!this.form.isHumanLike() || !this.skillHandler.isSkillEnabled((ISkill)ModSkills.WEAR_ARMOR.get())) {
                    this.removeArmorModifier();
                }
                this.checkArmorModifer = false;
            }
            this.specialAttributes.biteTicks = Math.max(0, this.specialAttributes.biteTicks - 1);
        }
        this.player.m_20193_().m_46473_().m_7238_();
    }

    private void tickFoodStats() {
        Difficulty difficulty = this.player.m_9236_().m_46791_();
        boolean flag = this.player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_);
        FoodData stats = this.player.m_36324_();
        if (flag && stats.m_38722_() > 0.0f && this.player.m_36325_() && stats.m_38702_() >= 20) {
            if (((FoodStatsAccessor)stats).getFoodTimer() >= 9) {
                float f = Math.min(stats.m_38722_(), 6.0f);
                this.player.m_5634_(f / 6.0f);
                stats.m_38703_(f);
            }
        } else if (flag && stats.m_38702_() >= 18 && this.player.m_36325_()) {
            if (((FoodStatsAccessor)stats).getFoodTimer() >= 79) {
                this.player.m_5634_(1.0f);
                stats.m_38703_(6.0f);
            }
        } else if (stats.m_38702_() <= 0 && ((FoodStatsAccessor)stats).getFoodTimer() >= 79 && (this.player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || this.player.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL)) {
            DamageHandler.hurtVanilla((Entity)this.player, DamageSources::m_269064_, (float)1.0f);
        }
    }

    public boolean setGlowingEyes(WerewolfForm form, boolean on) {
        if (on != this.glowingEyes.getOrDefault(form, false)) {
            this.glowingEyes.put(form, on);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag glowingEyes = new CompoundTag();
                this.glowingEyes.forEach((key, value) -> glowingEyes.m_128379_(key.getName(), value.booleanValue()));
                nbt.m_128365_("glowingEyes", (Tag)glowingEyes);
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setEyeType(WerewolfForm form, int type) {
        if (type != this.eyeType.getOrDefault(form, -1)) {
            this.eyeType.put(form, type);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag eye = new CompoundTag();
                this.eyeType.forEach((key, value) -> eye.m_128405_(key.getName(), value.intValue()));
                nbt.m_128365_("eyeTypes", (Tag)eye);
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setSkinType(WerewolfForm form, int type) {
        if (type != this.skinType.getOrDefault(form, -1)) {
            this.skinType.put(form, type);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag skin = new CompoundTag();
                this.skinType.forEach((key, value) -> skin.m_128405_(key.getName(), value.intValue()));
                nbt.m_128365_("skinTypes", (Tag)skin);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void setSkinData(WerewolfForm form, int[] data) {
        this.setEyeType(form, data[0]);
        this.setSkinType(form, data[1]);
        this.setGlowingEyes(form, data[2] == 1);
    }

    public void onDeath(DamageSource damageSource) {
        super.onDeath(damageSource);
        this.actionHandler.deactivateAllActions();
    }

    @Nonnull
    public LevelHandler getLevelHandler() {
        return this.levelHandler;
    }

    public boolean onEntityAttacked(DamageSource damageSource, float v) {
        return false;
    }

    public void onEntityKilled(LivingEntity victim, DamageSource src) {
        if (this.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.RAGE_FURY.get())) {
            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 40, 1));
            this.actionHandler.extendActionTimer((ILastingAction)ModActions.RAGE.get(), ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.rage_fury_timer_extend.get()).intValue());
        }
        this.levelHandler.increaseProgress((int)((double)victim.m_21233_() * 0.2));
        this.syncLevelHandler();
    }

    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    public void syncLevelHandler() {
        CompoundTag sync = new CompoundTag();
        this.levelHandler.saveToNbt(sync);
        this.sync(sync, false);
    }

    public void onPlayerLoggedIn() {
    }

    public void onPlayerLoggedOut() {
    }

    public void onUpdatePlayer(TickEvent.Phase phase) {
    }

    public boolean canBiteEntity(LivingEntity entity) {
        return (double)entity.m_20270_((Entity)this.player) <= this.player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() + 1.0 && (!(entity instanceof ServerPlayer) || (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.BITE_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false);
    }

    public boolean canBite() {
        return this.form.isTransformed() && !this.player.m_5833_() && this.getLevel() > 0 && this.specialAttributes.biteTicks <= 0 && (!(this.player instanceof ServerPlayer) || (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.BITE, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false);
    }

    public boolean bite(int entityId) {
        Entity entity = this.player.m_9236_().m_6815_(entityId);
        if (entity instanceof LivingEntity) {
            return this.bite((LivingEntity)entity);
        }
        return false;
    }

    private boolean bite(LivingEntity entity) {
        if (this.specialAttributes.biteTicks > 0) {
            return false;
        }
        if (!this.form.isTransformed()) {
            return false;
        }
        if (!this.canBite()) {
            return false;
        }
        if (!this.canBiteEntity(entity)) {
            return false;
        }
        double damage = this.player.m_21051_((Attribute)ModAttributes.BITE_DAMAGE.get()).m_22135_();
        boolean flag = DamageHandler.hurtModded((Entity)entity, sources -> sources.bite((LivingEntity)this.player), (float)damage);
        if (flag) {
            this.getRepresentingPlayer().m_5496_((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), 1.0f, 1.0f);
            this.getRepresentingPlayer().m_6330_((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.eatEntity(entity);
            this.specialAttributes.biteTicks = (Integer)WerewolvesConfig.BALANCE.PLAYER.bite_cooldown.get();
            if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.STUN_BITE.get())) {
                int duration = (Integer)WerewolvesConfig.BALANCE.SKILLS.stun_bite_duration.get();
                if (this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.STUN_BITE.get())) {
                    duration += ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.stun_bite_duration_extend.get()).intValue();
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.V.FREEZE.get(), duration));
            } else if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.BLEEDING_BITE.get())) {
                entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), ((Integer)WerewolvesConfig.BALANCE.SKILLS.bleeding_bite_duration.get()).intValue(), this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.BLEEDING_BITE.get()) ? 3 : 0));
            }
            this.sync(NBTHelper.nbtWith(nbt -> nbt.m_128405_("biteTicks", this.specialAttributes.biteTicks)), false);
            if (!(entity instanceof ServerPlayer) || ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.INFECT_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue()) {
                LupusSanguinemEffect.infectRandomByPlayer(entity);
            }
        }
        return flag;
    }

    private void eatEntity(LivingEntity entity) {
        if (entity.m_21222_()) {
            return;
        }
        if (!entity.m_6084_() && entity.m_6095_().m_20674_().m_21610_()) {
            this.player.m_36324_().m_38707_(1, 1.0f);
        }
    }

    public void onLevelChanged(int newLevel, int oldLevel) {
        this.applyEntityAttributes();
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard((Player)this.player, (ObjectiveCriteria)WUtils.WEREWOLF_LEVEL_CRITERIA, (int)newLevel);
            LevelAttributeModifier.applyModifier((Player)this.player, (Attribute)Attributes.f_22279_, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.3, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((Player)this.player, (Attribute)Attributes.f_22285_, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((Player)this.player, (Attribute)Attributes.f_22281_, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_damage.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION, (boolean)false);
            if (newLevel > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill((ISkillType)SkillType.LEVEL);
                }
            } else {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
            }
        } else if (newLevel == 0) {
            this.actionHandler.resetTimers();
        }
    }

    private void eatFleshFrom(LivingEntity entity) {
        this.player.m_36324_().m_38707_(1, 1.0f);
    }

    public ResourceLocation getCapKey() {
        return REFERENCE.WEREWOLF_PLAYER_KEY;
    }

    public boolean canLeaveFaction() {
        return true;
    }

    @Nullable
    public IFaction<?> getDisguisedAs() {
        if (this.getForm().isTransformed()) {
            return WReference.WEREWOLF_FACTION;
        }
        return null;
    }

    @Nonnull
    public IPlayableFaction<IWerewolfPlayer> getFaction() {
        return WReference.WEREWOLF_FACTION;
    }

    public int getMaxLevel() {
        return 14;
    }

    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    public boolean isDisguised() {
        return !this.getForm().isTransformed();
    }

    @Nullable
    public WerewolfFormAction getLastFormAction() {
        return this.lastFormAction;
    }

    public ISkillHandler<IWerewolfPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    public IActionHandler<IWerewolfPlayer> getActionHandler() {
        return this.actionHandler;
    }

    public void saveData(CompoundTag compound) {
        super.saveData(compound);
        this.actionHandler.saveToNbt(compound);
        this.skillHandler.saveToNbt(compound);
        this.levelHandler.saveToNbt(compound);
        compound.m_128359_("form", this.form.getName());
        if (this.lastFormAction != null) {
            compound.m_128359_("lastFormAction", RegUtil.id((IAction)this.lastFormAction).toString());
        }
        compound.m_128405_("biteTicks", this.specialAttributes.biteTicks);
        CompoundTag eye = new CompoundTag();
        this.eyeType.forEach((key, value) -> eye.m_128405_(key.getName(), value.intValue()));
        compound.m_128365_("eyeTypes", (Tag)eye);
        CompoundTag skin = new CompoundTag();
        this.skinType.forEach((key, value) -> skin.m_128405_(key.getName(), value.intValue()));
        compound.m_128365_("skinTypes", (Tag)skin);
        CompoundTag glowingEye = new CompoundTag();
        this.glowingEyes.forEach((key, value) -> glowingEye.m_128379_(key.getName(), value.booleanValue()));
        compound.m_128365_("glowingEyes", (Tag)glowingEye);
        compound.m_128347_("transformationTime", this.specialAttributes.transformationTime);
    }

    public void loadData(CompoundTag compound) {
        super.loadData(compound);
        this.actionHandler.loadFromNbt(compound);
        this.skillHandler.loadFromNbt(compound);
        this.levelHandler.loadFromNbt(compound);
        CompoundTag armor = compound.m_128469_("armor");
        for (int i = 0; i < armor.m_128440_(); ++i) {
            try {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)armor.m_128469_("" + i));
                this.player.m_8061_(EquipmentSlot.values()[i], stack);
                continue;
            }
            catch (Exception stack) {
                // empty catch block
            }
        }
        if (NBTHelper.containsString(compound, "form")) {
            this.switchForm(WerewolfForm.getForm(compound.m_128461_("form")));
        }
        if (NBTHelper.containsString(compound, "lastFormAction")) {
            this.lastFormAction = (WerewolfFormAction)RegUtil.getAction((ResourceLocation)new ResourceLocation(compound.m_128461_("lastFormAction")));
        }
        this.specialAttributes.biteTicks = compound.m_128451_("biteTicks");
        CompoundTag eye = compound.m_128469_("eyeTypes");
        eye.m_128431_().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.m_128451_(string)));
        CompoundTag skin = compound.m_128469_("skinTypes");
        skin.m_128431_().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.m_128451_(string)));
        CompoundTag glowingEyes = compound.m_128469_("glowingEyes");
        glowingEyes.m_128431_().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.m_128471_(string)));
        if (compound.m_128441_("transformationTime")) {
            this.specialAttributes.transformationTime = compound.m_128457_("transformationTime");
        }
    }

    protected void writeFullUpdate(CompoundTag nbt) {
        super.writeFullUpdate(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
        this.levelHandler.saveToNbt(nbt);
        nbt.m_128359_("form", this.form.getName());
        nbt.m_128405_("biteTicks", this.specialAttributes.biteTicks);
        CompoundTag eye = new CompoundTag();
        this.eyeType.forEach((key, value) -> eye.m_128405_(key.getName(), value.intValue()));
        nbt.m_128365_("eyeTypes", (Tag)eye);
        CompoundTag skin = new CompoundTag();
        this.skinType.forEach((key, value) -> skin.m_128405_(key.getName(), value.intValue()));
        nbt.m_128365_("skinTypes", (Tag)skin);
        CompoundTag glowingEye = new CompoundTag();
        this.glowingEyes.forEach((key, value) -> glowingEye.m_128379_(key.getName(), value.booleanValue()));
        nbt.m_128365_("glowingEyes", (Tag)glowingEye);
        nbt.m_128347_("transformationTime", this.specialAttributes.transformationTime);
    }

    protected void loadUpdate(CompoundTag nbt) {
        super.loadUpdate(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
        this.levelHandler.loadFromNbt(nbt);
        if (NBTHelper.containsString(nbt, "form")) {
            this.switchForm(WerewolfForm.getForm(nbt.m_128461_("form")));
        }
        if (nbt.m_128441_("biteTicks")) {
            this.specialAttributes.biteTicks = nbt.m_128451_("biteTicks");
        }
        if (nbt.m_128441_("eyeTypes")) {
            CompoundTag eye = nbt.m_128469_("eyeTypes");
            eye.m_128431_().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.m_128451_(string)));
        }
        if (nbt.m_128441_("skinTypes")) {
            CompoundTag skin = nbt.m_128469_("skinTypes");
            skin.m_128431_().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.m_128451_(string)));
        }
        if (nbt.m_128441_("glowingEyes")) {
            CompoundTag glowingEyes = nbt.m_128469_("glowingEyes");
            glowingEyes.m_128431_().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.m_128471_(string)));
        }
        if (nbt.m_128441_("transformationTime")) {
            this.specialAttributes.transformationTime = nbt.m_128457_("transformationTime");
        }
    }

    public static ICapabilityProvider createNewCapability(final Player player) {
        return new ICapabilitySerializable<CompoundTag>(){
            final WerewolfPlayer inst;
            final LazyOptional<IWerewolfPlayer> opt;
            {
                this.inst = new WerewolfPlayer(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CAP.orEmpty(cap, this.opt);
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveData(tag);
                return tag;
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadData(nbt);
            }
        };
    }

    @Override
    public int getEyeType(WerewolfForm form) {
        return this.eyeType.getOrDefault(form, 0);
    }

    @Override
    public int getSkinType(WerewolfForm form) {
        return this.skinType.getOrDefault(form, 0);
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return this.glowingEyes.getOrDefault(form, false);
    }

    static {
        LevelAttributeModifier.registerModdedAttributeModifier((Attribute)Attributes.f_22285_, (UUID)ARMOR_TOUGHNESS);
    }
}

