/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class BeastWerewolfFormAction
extends WerewolfFormAction {
    public BeastWerewolfFormAction() {
        super(WerewolfForm.BEAST);
        this.attributes.add(new WerewolfFormAction.Modifier((Attribute)ModAttributes.BITE_DAMAGE.get(), UUID.fromString("128d73ba-f99a-452a-96fc-494c317ee7e3"), UUID.fromString("4e32baca-7752-4323-8942-76891822e836"), 1.0, "beast_form_claw_damage", (Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_bite_damage, AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(Attributes.f_22276_, UUID.fromString("5b99db11-01cf-4430-bf41-ff6adc11ccb0"), UUID.fromString("d41d9079-15a0-414d-847e-8708b9226be5"), 0.5, "beast_form_health", (Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_health, AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(Attributes.f_22284_, UUID.fromString("0b281a87-829f-4d98-9a3b-116549cfdd57"), UUID.fromString("faebe9f8-d133-44a7-b872-83560ca4d927"), 0.7, "beast_form_armor", () -> (Double)WerewolvesConfig.BALANCE.SKILLS.beast_form_armor.get() * 0.8, (Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_armor, (Supplier<ISkill<IWerewolfPlayer>>)ModSkills.RESISTANCE, AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(Attributes.f_22285_, UUID.fromString("f47e2130-39c4-496f-8d47-572abdc03920"), UUID.fromString("b8eb47be-1e10-41ce-8ff6-2a5c4aa4f408"), 0.7, "beast_form_armor_toughness", (Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_armor_toughness, AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(Attributes.f_22279_, UUID.fromString("e9748d20-a9a5-470c-99a4-44167df71aa5"), UUID.fromString("cf0d3fce-6fb3-4274-842b-bced59637eaf"), 0.5, "beast_form_speed_amount", () -> (Double)WerewolvesConfig.BALANCE.SKILLS.beast_form_speed_amount.get() * 0.8, (Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_speed_amount, (Supplier<ISkill<IWerewolfPlayer>>)ModSkills.SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.attributes.add(new WerewolfFormAction.Modifier(Attributes.f_22281_, UUID.fromString("2792aac3-5ae1-47d9-8ba6-0b473b6b666a"), UUID.fromString("07a8e8e1-ff43-41f9-8053-c947482ef6c2"), 0.5, "beast_form_attack_damage", () -> (Double)WerewolvesConfig.BALANCE.SKILLS.beast_form_attack_damage.get() * 0.5, (Supplier<Double>)WerewolvesConfig.BALANCE.SKILLS.beast_form_attack_damage, (Supplier<ISkill<IWerewolfPlayer>>)ModSkills.DAMAGE, AttributeModifier.Operation.ADDITION));
    }

    public boolean isEnabled() {
        return (Boolean)WerewolvesConfig.BALANCE.SKILLS.beast_form_enabled.get();
    }

    public int getCooldown(IWerewolfPlayer werewolf) {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.beast_form_cooldown.get() * 20;
    }

    @Override
    public int getTimeModifier(IWerewolfPlayer werewolf) {
        int limit = super.getTimeModifier(werewolf);
        boolean duration1 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_BEAST_1.get());
        boolean duration2 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_BEAST_2.get());
        if (duration1 || duration2) {
            limit = duration2 ? (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_beast_2.get() * 20) : (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_beast_1.get() * 20);
        }
        return limit;
    }
}

