/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.player.action.IActionCooldownMenu;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.entities.AggressiveWolfEntity;
import de.teamlapen.werewolves.entities.player.werewolf.actions.DefaultWerewolfAction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class HowlingAction
extends DefaultWerewolfAction
implements IActionCooldownMenu {
    public boolean isEnabled() {
        return (Boolean)WerewolvesConfig.BALANCE.SKILLS.howling_enabled.get();
    }

    protected boolean activate(IWerewolfPlayer werewolfPlayer, IAction.ActivationContext context) {
        Player player = werewolfPlayer.getRepresentingPlayer();
        if (player.m_21124_((MobEffect)ModEffects.HOWLING.get()) != null) {
            return false;
        }
        AABB bb = new AABB(player.m_20183_());
        bb.m_82400_(10.0);
        List entities = player.m_20193_().m_45976_(LivingEntity.class, bb);
        entities.forEach(entity -> entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.HOWLING.get(), ((Integer)WerewolvesConfig.BALANCE.SKILLS.howling_duration.get() + (Integer)WerewolvesConfig.BALANCE.SKILLS.howling_disabled_duration.get()) * 20, 0, true, false, true)));
        werewolfPlayer.getRepresentingPlayer().m_5496_((SoundEvent)ModSounds.ENTITY_WEREWOLF_HOWL.get(), 1.0f, 1.0f);
        werewolfPlayer.getRepresentingPlayer().m_6330_((SoundEvent)ModSounds.ENTITY_WEREWOLF_HOWL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (werewolfPlayer.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WOLF_PACK.get())) {
            Level world = player.m_20193_();
            int wolfAmount = (Integer)WerewolvesConfig.BALANCE.SKILLS.wolf_pack_wolf_amount.get();
            if (werewolfPlayer.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.MORE_WOLVES.get())) {
                wolfAmount += ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.more_wolves.get()).intValue();
            }
            for (int i = 0; i < wolfAmount; ++i) {
                AggressiveWolfEntity wolf = (AggressiveWolfEntity)((EntityType)ModEntities.WOLF.get()).m_20615_(world);
                wolf.m_21828_(player);
                wolf.restrictLiveSpan((Integer)WerewolvesConfig.BALANCE.SKILLS.wolf_pack_wolf_duration.get() * 20);
                UtilLib.spawnEntityInWorld((ServerLevel)((ServerLevel)world), (AABB)new AABB(player.m_20183_()).m_82400_(1.0), (Entity)wolf, (int)10, new ArrayList(), (MobSpawnType)MobSpawnType.EVENT);
            }
        }
        return true;
    }

    public boolean canBeUsedBy(IWerewolfPlayer player) {
        return player.getRepresentingPlayer().m_21124_((MobEffect)ModEffects.HOWLING.get()) == null;
    }

    public int getCooldown(IWerewolfPlayer werewolf) {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.howling_cooldown.get() * 20;
    }
}

