/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.player.action.IActionCooldownMenu;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.entities.player.werewolf.actions.DefaultWerewolfAction;
import java.util.UUID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class RageWerewolfAction
extends DefaultWerewolfAction
implements ILastingAction<IWerewolfPlayer>,
IActionCooldownMenu {
    private static final UUID BITE_MODIFIER = UUID.fromString("0ae51804-eaf4-456e-b4ff-24ed326557f4");

    public boolean isEnabled() {
        return (Boolean)WerewolvesConfig.BALANCE.SKILLS.rage_enabled.get();
    }

    protected boolean activate(IWerewolfPlayer werewolf, IAction.ActivationContext context) {
        this.addEffectInstance(werewolf, new MobEffectInstance(MobEffects.f_19596_, this.getDuration(werewolf), 1, false, false));
        this.addEffectInstance(werewolf, new MobEffectInstance(MobEffects.f_19600_, this.getDuration(werewolf), 0, false, false));
        werewolf.getRepresentingPlayer().m_21051_((Attribute)ModAttributes.BITE_DAMAGE.get()).m_22125_(new AttributeModifier(BITE_MODIFIER, "rage_bite_modifier", ((Double)WerewolvesConfig.BALANCE.SKILLS.rage_bite_damage.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        return true;
    }

    public int getDuration(IWerewolfPlayer werewolf) {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.rage_duration.get() * 20;
    }

    public void onActivatedClient(IWerewolfPlayer iWerewolfPlayer) {
    }

    public void onDeactivated(IWerewolfPlayer werewolf) {
        this.removePotionEffect(werewolf, MobEffects.f_19600_);
        this.removePotionEffect(werewolf, MobEffects.f_19596_);
        werewolf.getRepresentingPlayer().m_21051_((Attribute)ModAttributes.BITE_DAMAGE.get()).m_22120_(BITE_MODIFIER);
    }

    public void onReActivated(IWerewolfPlayer iWerewolfPlayer) {
    }

    public boolean onUpdate(IWerewolfPlayer iWerewolfPlayer) {
        return false;
    }

    public int getCooldown(IWerewolfPlayer werewolf) {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.rage_cooldown.get() * 20;
    }
}

