/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.DefaultWerewolfAction;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;

public abstract class WerewolfFormAction
extends DefaultWerewolfAction
implements ILastingAction<IWerewolfPlayer> {
    private static final Set<WerewolfFormAction> ALL_ACTION = new HashSet<WerewolfFormAction>();
    protected final List<Modifier> attributes = new ArrayList<Modifier>();
    @Nonnull
    private final WerewolfForm form;

    public static boolean isWerewolfFormActionActive(IActionHandler<IWerewolfPlayer> handler) {
        return ALL_ACTION.stream().anyMatch(arg_0 -> handler.isActionActive(arg_0));
    }

    public static Set<WerewolfFormAction> getAllAction() {
        return Collections.unmodifiableSet(ALL_ACTION);
    }

    public WerewolfFormAction(@Nonnull WerewolfForm form) {
        ALL_ACTION.add(this);
        this.form = form;
    }

    protected boolean activate(IWerewolfPlayer werewolf, IAction.ActivationContext context) {
        float healthPerc = werewolf.getRepresentingPlayer().m_21223_() / werewolf.getRepresentingPlayer().m_21233_();
        if (WerewolfFormAction.isWerewolfFormActionActive((IActionHandler<IWerewolfPlayer>)werewolf.getActionHandler())) {
            FormHelper.deactivateWerewolfActions(werewolf);
        }
        ((WerewolfPlayer)werewolf).setForm(this, this.form);
        this.removeArmorModifier(werewolf);
        this.applyModifier(werewolf);
        werewolf.getRepresentingPlayer().m_21153_(werewolf.getRepresentingPlayer().m_21233_() * healthPerc);
        werewolf.getRepresentingPlayer().refreshDisplayName();
        return true;
    }

    protected void removeArmorModifier(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).removeArmorModifier();
    }

    protected void addArmorModifier(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).addArmorModifier();
    }

    public void onActivatedClient(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).switchForm(this.form);
        werewolfPlayer.getRepresentingPlayer().refreshDisplayName();
    }

    public void onDeactivated(IWerewolfPlayer werewolf) {
        float healthPerc = werewolf.getRepresentingPlayer().m_21223_() / werewolf.getRepresentingPlayer().m_21233_();
        ((WerewolfPlayer)werewolf).setForm(this, WerewolfForm.NONE);
        this.addArmorModifier(werewolf);
        this.removeModifier(werewolf);
        werewolf.getRepresentingPlayer().m_21153_(werewolf.getRepresentingPlayer().m_21233_() * healthPerc);
        werewolf.getRepresentingPlayer().refreshDisplayName();
    }

    public void onReActivated(IWerewolfPlayer werewolf) {
        this.removeArmorModifier(werewolf);
        werewolf.getRepresentingPlayer().refreshDisplayName();
    }

    public boolean onUpdate(IWerewolfPlayer werewolfPlayer) {
        if (werewolfPlayer.getRepresentingPlayer().m_9236_().m_46467_() % 20L == 0L) {
            this.checkDayNightModifier(werewolfPlayer);
        }
        if (!this.usesTransformationTime((LivingEntity)werewolfPlayer.getRepresentingPlayer())) {
            return false;
        }
        return this.increaseWerewolfTime(werewolfPlayer) || werewolfPlayer.getRepresentingPlayer() instanceof ServerPlayer && (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)werewolfPlayer.getRepresentingPlayer()), Permissions.FORM, (PermissionDynamicContext[])new PermissionDynamicContext[0]) == false;
    }

    protected boolean usesTransformationTime(LivingEntity player) {
        return !Helper.isNight(player.m_9236_()) && !FormHelper.isInWerewolfBiome((LevelAccessor)player.m_9236_(), player.m_20183_());
    }

    protected boolean increaseWerewolfTime(IWerewolfPlayer werewolfPlayer) {
        if (!this.consumesWerewolfTime()) {
            return false;
        }
        ((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().transformationTime = Mth.m_14008_((double)(((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().transformationTime + 1.0 / (double)this.getTimeModifier(werewolfPlayer)), (double)0.0, (double)1.0);
        return ((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().transformationTime == 1.0;
    }

    public void checkDayNightModifier(IWerewolfPlayer werewolfPlayer) {
        Player player = werewolfPlayer.getRepresentingPlayer();
        boolean night = Helper.isNight(player.m_20193_());
        for (Modifier attribute : this.attributes) {
            if (player.m_21051_(attribute.attribute).m_22111_(!night ? attribute.nightUuid : attribute.dayUuid) == null) continue;
            this.removeModifier(werewolfPlayer);
            this.applyModifier(werewolfPlayer);
        }
    }

    public void applyModifier(IWerewolfPlayer werewolf) {
        Player player = werewolf.getRepresentingPlayer();
        boolean night = Helper.isNight(player.m_20193_());
        for (Modifier attribute : this.attributes) {
            AttributeInstance ins = player.m_21051_(attribute.attribute);
            if (ins == null || ins.m_22111_(attribute.dayUuid) != null) continue;
            ins.m_22125_(attribute.create(werewolf, night));
        }
    }

    public void removeModifier(IWerewolfPlayer werewolf) {
        Player player = werewolf.getRepresentingPlayer();
        for (Modifier attribute : this.attributes) {
            AttributeInstance ins = player.m_21051_(attribute.attribute);
            if (ins == null) continue;
            ins.m_22120_(attribute.dayUuid);
            ins.m_22120_(attribute.nightUuid);
        }
    }

    public int getDuration(IWerewolfPlayer werewolf) {
        return 10000;
    }

    public boolean canBeUsedBy(IWerewolfPlayer player) {
        if (!(!(player.getRepresentingPlayer() instanceof ServerPlayer) || ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player.getRepresentingPlayer()), Permissions.TRANSFORMATION, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue() && ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player.getRepresentingPlayer()), Permissions.FORM, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue())) {
            return false;
        }
        if (player.getRepresentingPlayer().m_20159_() && !this.form.isHumanLike()) {
            return false;
        }
        boolean active = player.getActionHandler().isActionActive((ILastingAction)this);
        if (Helper.isFullMoon(player.getRepresentingPlayer().m_20193_()) && active && !player.getSkillHandler().isSkillEnabled((ISkill)ModSkills.FREE_WILL.get())) {
            return false;
        }
        return this.consumesWerewolfTime() || active || ((WerewolfPlayer)player).getSpecialAttributes().transformationTime < 0.7 || player.getRepresentingPlayer().m_9236_().m_204166_(player.getRepresentingEntity().m_20183_()).m_203565_(ModBiomes.WEREWOLF_HEAVEN);
    }

    public boolean consumesWerewolfTime() {
        return true;
    }

    public int getTimeModifier(IWerewolfPlayer werewolf) {
        int limit = (Integer)WerewolvesConfig.BALANCE.SKILLS.werewolf_form_time_limit.get() * 20;
        boolean duration1 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_GENERAL_1.get());
        boolean duration2 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_GENERAL_2.get());
        if (duration1 || duration2) {
            limit = duration2 ? (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_general_2.get() * 20) : (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_general_1.get() * 20);
        }
        return limit;
    }

    protected static class Modifier {
        public final Attribute attribute;
        public final UUID dayUuid;
        public final UUID nightUuid;
        public final String name;
        public final Function<IWerewolfPlayer, Double> value;
        public final AttributeModifier.Operation operation;
        public final double dayModifier;

        public Modifier(Attribute attribute, UUID dayUuid, UUID nightUuid, double dayModifier, String name, Supplier<Double> valueFunction, AttributeModifier.Operation operation) {
            this(attribute, dayUuid, nightUuid, dayModifier, name, (IWerewolfPlayer player) -> (Double)valueFunction.get(), operation);
        }

        public Modifier(Attribute attribute, UUID dayUuid, UUID nightUuid, double dayModifier, String name, Supplier<Double> valueFunction, Supplier<Double> extendedValueFunction, Supplier<ISkill<IWerewolfPlayer>> extendedSkill, AttributeModifier.Operation operation) {
            this(attribute, dayUuid, nightUuid, dayModifier, name, (IWerewolfPlayer player) -> player.getSkillHandler().isSkillEnabled((ISkill)extendedSkill.get()) ? (Double)extendedValueFunction.get() : (Double)valueFunction.get(), operation);
        }

        public Modifier(Attribute attribute, UUID dayUuid, UUID nightUuid, double dayModifier, String name, Function<IWerewolfPlayer, Double> valueFunction, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.dayUuid = dayUuid;
            this.nightUuid = nightUuid;
            this.name = name;
            this.value = valueFunction;
            this.operation = operation;
            this.dayModifier = dayModifier;
        }

        public AttributeModifier create(IWerewolfPlayer player, boolean night) {
            return new AttributeModifier(night ? this.nightUuid : this.dayUuid, this.name, night ? this.value.apply(player) : this.value.apply(player) * this.dayModifier, this.operation);
        }
    }
}

