/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.skill;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.entity.player.skills.VampirismSkill;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public class SimpleWerewolfSkill
extends VampirismSkill<IWerewolfPlayer> {
    public SimpleWerewolfSkill() {
        this(false);
    }

    public SimpleWerewolfSkill(boolean desc) {
        if (desc) {
            this.setHasDefaultDescription();
        }
    }

    @Nonnull
    public Optional<IPlayableFaction<?>> getFaction() {
        return Optional.of(WReference.WEREWOLF_FACTION);
    }

    public SimpleWerewolfSkill defaultDescWithExtra(Supplier<Component> text) {
        this.setDescription(() -> Component.m_237115_((String)(this.getTranslationKey() + ".desc")).m_130946_("\n").m_7220_((Component)text.get()));
        return this;
    }

    @SafeVarargs
    public final SimpleWerewolfSkill defaultDescWithExtra(MutableComponent prefix, Supplier<ISkill<?>> ... skills) {
        this.setDescription(() -> {
            MutableComponent text = Component.m_237115_((String)(this.getTranslationKey() + ".desc")).m_130946_("\n").m_7220_((Component)prefix.m_130940_(ChatFormatting.AQUA)).m_130946_(" ");
            text.m_7220_((Component)Helper.joinComponents(", ", (MutableComponent[])Arrays.stream(skills).map(skill -> Component.m_237115_((String)((ISkill)skill.get()).getTranslationKey())).toArray(MutableComponent[]::new)).m_130940_(ChatFormatting.AQUA));
            return text;
        });
        return this;
    }

    @SafeVarargs
    public final SimpleWerewolfSkill defaultDescWithFormRequirement(Supplier<ISkill<?>> ... skills) {
        return this.defaultDescWithExtra(Component.m_237115_((String)"text.werewolves.skills.only_applies"), skills);
    }

    @SafeVarargs
    public final SimpleWerewolfSkill defaultDescWithEnhancement(Supplier<ISkill<?>> ... skill) {
        return this.defaultDescWithExtra(Component.m_237115_((String)"text.werewolves.skills.upgrade"), skill);
    }

    public static class AttributeSkill
    extends SimpleWerewolfSkill {
        private final UUID attribute;
        private final Attribute attributeType;
        private final AttributeModifier.Operation operation;
        private final Function<IWerewolfPlayer, Double> attribute_value;

        public AttributeSkill(String id, boolean desc, UUID attributeUUID, Attribute attributeType, AttributeModifier.Operation operation, Function<IWerewolfPlayer, Double> attribute_value) {
            super(desc);
            this.attribute = attributeUUID;
            this.attributeType = attributeType;
            this.operation = operation;
            this.attribute_value = attribute_value;
        }

        protected void onDisabled(IWerewolfPlayer player) {
            AttributeInstance attributes = player.getRepresentingPlayer().m_21051_(this.attributeType);
            attributes.m_22120_(this.attribute);
        }

        protected void onEnabled(IWerewolfPlayer player) {
            AttributeInstance attributes = player.getRepresentingPlayer().m_21051_(this.attributeType);
            if (attributes.m_22111_(this.attribute) == null) {
                attributes.m_22125_(new AttributeModifier(this.attribute, RegUtil.id((ISkill)this).toString() + "_skill", this.attribute_value.apply(player).doubleValue(), this.operation));
            }
        }
    }

    public static class LordWerewolfSkill
    extends SimpleWerewolfSkill {
        public LordWerewolfSkill(boolean desc) {
            super(desc);
        }

        @NotNull
        public ISkillType getType() {
            return SkillType.LORD;
        }
    }
}

