/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.FactionBasePlayer;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.werewolves.api.entities.IEntityFollower;
import de.teamlapen.werewolves.api.entities.werewolf.TransformType;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.entities.goals.DefendLeaderGoal;
import de.teamlapen.werewolves.entities.goals.FollowAlphaWerewolfGoal;
import de.teamlapen.werewolves.entities.goals.WerewolfAttackVillageGoal;
import de.teamlapen.werewolves.entities.goals.WerewolfDefendVillageGoal;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WerewolfVillageData;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class BasicWerewolfEntity
extends WerewolfBaseEntity
implements WerewolfTransformable,
IVillageCaptureEntity,
IEntityFollower,
IAdjustableLevel,
IFactionEntity {
    protected static final EntityDataAccessor<Integer> SKINTYPE = SynchedEntityData.m_135353_(BasicWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> EYETYPE = SynchedEntityData.m_135353_(BasicWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(BasicWerewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int MAX_LEVEL = 2;
    private static final Logger LOGGER = LogManager.getLogger();
    private final WerewolfForm werewolfForm;
    private WerewolfTransformable transformed;
    private int transformedDuration;
    private TransformType transformType;
    private EntityClassType entityClass;
    private EntityActionTier entityTier;
    private IEntityLeader entityLeader;
    @Nullable
    protected ICaptureAttributes villageAttributes;
    protected boolean attack;

    public BasicWerewolfEntity(EntityType<? extends BasicWerewolfEntity> type, Level world, WerewolfForm werewolfForm) {
        super(type, world, true);
        this.werewolfForm = werewolfForm;
        this.entityClass = EntityClassType.getRandomClass((RandomSource)world.f_46441_);
        this.entityTier = EntityActionTier.Low;
        this.f_21364_ = 3;
    }

    @Nonnull
    public EntityDimensions m_6972_(@Nonnull Pose poseIn) {
        return this.werewolfForm.getSize(poseIn).map(p -> p.m_20388_(this.m_6134_())).orElse(super.m_6972_(poseIn));
    }

    public boolean m_21532_() {
        return super.m_21532_() || this.transformed != null;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.werewolfForm;
    }

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        return this;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        if (this.transformed == null) {
            return this;
        }
        ((Mob)this.transformed).m_20359_((Entity)this);
        ((Mob)this.transformed).revive();
        this.m_9236_().m_7967_((Entity)((Mob)this.transformed));
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        ((Mob)this.transformed).m_21153_(this.m_21223_() / this.m_21233_() * ((Mob)this.transformed).m_21233_());
        return this.transformed;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityClass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entityTier;
    }

    @Override
    public int getSkinType(@Nullable WerewolfForm form) {
        return Math.max(0, (Integer)this.m_20088_().m_135370_(SKINTYPE));
    }

    @Override
    public int getEyeType(@Nullable WerewolfForm form) {
        return Math.max(0, (Integer)this.m_20088_().m_135370_(EYETYPE));
    }

    @Override
    public void start(TransformType type) {
        this.transformType = type;
        if (type == TransformType.TIME_LIMITED) {
            this.transformedDuration = (Integer)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_transform_duration.get();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.transformed != null && this.m_9236_().m_46467_() % 20L == 0L) {
            switch (this.transformType) {
                case TIME_LIMITED: {
                    if (--this.transformedDuration > 0) break;
                    this.transformBack();
                    break;
                }
                case FULL_MOON: {
                    if (Helper.isFullMoon(this.m_9236_())) break;
                    this.transformBack();
                }
            }
        }
    }

    public void m_7378_(@Nonnull CompoundTag nbt) {
        Entity entity;
        ResourceLocation id;
        EntityType type;
        int t;
        super.m_7378_(nbt);
        if (nbt.m_128441_("level")) {
            this.setEntityLevel(nbt.m_128451_("level"));
        }
        if (nbt.m_128441_("type")) {
            t = nbt.m_128451_("type");
            this.m_20088_().m_135381_(SKINTYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.m_128441_("eyeType")) {
            t = nbt.m_128451_("eyeType");
            this.m_20088_().m_135381_(EYETYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.m_128441_("transformedDuration")) {
            this.transformedDuration = nbt.m_128451_("transformedDuration");
        }
        if (nbt.m_128441_("attack")) {
            this.attack = nbt.m_128471_("attack");
        }
        if (nbt.m_128441_("transformType")) {
            this.transformType = TransformType.valueOf(nbt.m_128461_("transformType"));
        }
        if (nbt.m_128441_("transformed") && (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id = new ResourceLocation(nbt.m_128461_("transformed_id")))) != null && (entity = type.m_20615_(this.m_9236_())) instanceof LivingEntity && entity instanceof WerewolfTransformable) {
            ((LivingEntity)entity).m_7378_(nbt.m_128469_("transformed"));
            this.transformed = (WerewolfTransformable)entity;
        }
    }

    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("transformedDuration", this.transformedDuration);
        if (this.transformType != null) {
            nbt.m_128359_("transformType", this.transformType.name());
        }
        nbt.m_128405_("level", this.getEntityLevel());
        nbt.m_128405_("type", this.getSkinType());
        nbt.m_128405_("eyeType", this.getEyeType());
        nbt.m_128379_("attack", this.attack);
        if (this.transformed != null) {
            CompoundTag transformed = new CompoundTag();
            ((LivingEntity)this.transformed).m_20240_(transformed);
            nbt.m_128365_("transformed", (Tag)transformed);
            nbt.m_128359_("transformed_id", RegUtil.id((EntityType)((LivingEntity)this.transformed).m_6095_()).toString());
        }
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (this.transformType == TransformType.TIME_LIMITED) {
            this.transformedDuration = (Integer)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_transform_duration.get() * 20;
        }
        return super.m_6469_(source, amount);
    }

    public int getEntityLevel() {
        return (Integer)this.m_20088_().m_135370_(LEVEL);
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return true;
    }

    public void setEntityLevel(int level) {
        if (level >= 0) {
            this.m_20088_().m_135381_(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 1000000, 1));
            }
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        int werewolfLevel = WerewolfPlayer.getOpt(player).map(FactionBasePlayer::getLevel).orElse(0);
        if (werewolfLevel > 0) {
            FactionPlayerHandler.getOpt((Player)player).ifPresent(fph -> {
                if (fph.getMaxMinions() > 0) {
                    ItemStack heldItem = player.m_21120_(hand);
                    if (this.getEntityLevel() > 0) {
                        if (heldItem.m_41720_() == ModItems.WEREWOLF_MINION_CHARM.get()) {
                            player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.basic_werewolf.minion.unavailable"), true);
                        }
                    } else {
                        boolean freeSlot = MinionWorldData.getData((Level)player.m_9236_()).map(data -> data.getOrCreateController(fph)).map(PlayerMinionController::hasFreeMinionSlot).orElse(false);
                        player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.basic_werewolf.minion.available"), false);
                        if (heldItem.m_41720_() == ModItems.WEREWOLF_MINION_CHARM.get()) {
                            if (!freeSlot) {
                                player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.basic_werewolf.minion.no_free_slot"), false);
                            } else {
                                player.m_5661_((Component)Component.m_237115_((String)"text.werewolves.basic_werewolf.minion.start_serving"), false);
                                this.convertToMinion(player);
                                if (!player.m_150110_().f_35937_) {
                                    heldItem.m_41774_(1);
                                }
                            }
                        } else if (freeSlot) {
                            player.m_5661_((Component)Component.m_237110_((String)"text.werewolves.basic_werewolf.minion.require_equipment", (Object[])new Object[]{UtilLib.translate((String)((Item)ModItems.WEREWOLF_MINION_CHARM.get()).m_5524_(), (Object[])new Object[0])}), false);
                        }
                    }
                }
            });
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void convertToMinion(Player lord) {
        FactionPlayerHandler.getOpt((Player)lord).ifPresent(fph -> {
            if (fph.getMaxMinions() > 0) {
                MinionWorldData.getData((Level)lord.m_9236_()).map(w -> w.getOrCreateController(fph)).ifPresent(controller -> {
                    if (controller.hasFreeMinionSlot()) {
                        if (fph.getCurrentFaction() == this.getFaction()) {
                            WerewolfMinionEntity.WerewolfMinionData data = new WerewolfMinionEntity.WerewolfMinionData("Minion", this.getSkinType(), this.getEyeType(), this.hasGlowingEyes(), this.getForm());
                            int id = controller.createNewMinionSlot((MinionData)data, (EntityType)ModEntities.WEREWOLF_MINION.get());
                            if (id < 0) {
                                LOGGER.error("Failed to get minion slot");
                                return;
                            }
                            WerewolfMinionEntity minion = (WerewolfMinionEntity)((EntityType)ModEntities.WEREWOLF_MINION.get()).m_20615_(this.m_9236_());
                            minion.claimMinionSlot(id, (PlayerMinionController)controller);
                            minion.m_20359_((Entity)this);
                            minion.markAsConverted();
                            controller.activateTask(0, (IMinionTask)MinionTasks.STAY.get());
                            UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)minion);
                        } else {
                            LOGGER.warn("Wrong faction for minion");
                        }
                    } else {
                        LOGGER.warn("No free slot");
                    }
                });
            } else {
                LOGGER.error("Can't have minions");
            }
        });
    }

    public int getMaxEntityLevel() {
        return 2;
    }

    @Override
    public boolean canTransform() {
        return this.transformed != null;
    }

    public int suggestEntityLevel(de.teamlapen.vampirism.api.difficulty.Difficulty difficulty) {
        return switch (this.f_19796_.m_188503_(5)) {
            case 0 -> (int)((float)difficulty.minPercLevel / 100.0f * 2.0f);
            case 1 -> (int)((float)difficulty.avgPercLevel / 100.0f * 2.0f);
            case 2 -> (int)((float)difficulty.maxPercLevel / 100.0f * 2.0f);
            default -> this.f_19796_.m_188503_(3);
        };
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getEntityLevel(), 0);
        this.m_21051_(Attributes.f_22276_).m_22100_((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health.get() + (Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health_pl.get() * (double)l);
        this.m_21051_(Attributes.f_22281_).m_22100_((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage.get() + (Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage_pl.get() * (double)l);
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_speed.get()).doubleValue());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.m_20088_().m_135370_(SKINTYPE) == -1) {
            this.m_20088_().m_135381_(SKINTYPE, (Object)this.m_217043_().m_188503_(126));
        }
        if ((Integer)this.m_20088_().m_135370_(EYETYPE) == -1) {
            this.m_20088_().m_135381_(EYETYPE, (Object)this.m_217043_().m_188503_(126));
        }
    }

    public void setSourceEntity(WerewolfTransformable entity) {
        this.entityClass = entity.getEntityClass();
        this.entityTier = entity.getEntityTier();
        this.transformed = entity;
    }

    public void attackVillage(ICaptureAttributes iCaptureAttributes) {
        this.villageAttributes = iCaptureAttributes;
        this.attack = true;
    }

    public void defendVillage(ICaptureAttributes iCaptureAttributes) {
        this.villageAttributes = iCaptureAttributes;
        this.attack = false;
    }

    @Nullable
    public AABB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    public int m_8100_() {
        return 240;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENTITY_WEREWOLF_GROWL.get();
    }

    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    public void stopVillageAttackDefense() {
        this.villageAttributes = null;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreakDoorGoal((Mob)this, difficulty -> difficulty == Difficulty.HARD));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, new FollowAlphaWerewolfGoal<BasicWerewolfEntity>(this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, new WerewolfAttackVillageGoal<BasicWerewolfEntity>(this));
        this.f_21346_.m_25352_(4, new WerewolfDefendVillageGoal<BasicWerewolfEntity>(this));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, true, null)));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, PatrollingMonster.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (TagKey)StructureTags.f_215889_)));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, new DefendLeaderGoal<BasicWerewolfEntity>(this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LEVEL, (Object)-1);
        this.m_20088_().m_135372_(SKINTYPE, (Object)-1);
        this.m_20088_().m_135372_(EYETYPE, (Object)-1);
    }

    @Override
    @Nonnull
    public Optional<IEntityLeader> getLeader() {
        return Optional.ofNullable(this.entityLeader);
    }

    @Override
    public void setLeader(@Nullable IEntityLeader leader) {
        this.entityLeader = leader;
    }

    public boolean m_7327_(@NotNull Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                LupusSanguinemEffect.infectRandomByMob(living);
            }
            return true;
        }
        return false;
    }

    public static class Survivalist
    extends BasicWerewolfEntity {
        public Survivalist(EntityType<? extends Survivalist> type, Level world) {
            super(type, world, WerewolfForm.SURVIVALIST);
        }
    }

    public static class Beast
    extends BasicWerewolfEntity {
        public Beast(EntityType<? extends Beast> type, Level world) {
            super(type, world, WerewolfForm.BEAST);
        }

        public void m_6667_(@Nonnull DamageSource cause) {
            if (this.villageAttributes == null) {
                BadOmenEffect.handlePotentialBannerKill((Entity)cause.m_7639_(), (IFactionEntity)this);
            }
            super.m_6667_(cause);
        }

        @Nullable
        public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor world, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag nbt) {
            if (reason != MobSpawnType.SPAWN_EGG && reason != MobSpawnType.BUCKET && reason != MobSpawnType.CONVERSION && reason != MobSpawnType.COMMAND && this.m_217043_().m_188503_(50) == 0) {
                this.m_8061_(EquipmentSlot.HEAD, WerewolfVillageData.createBanner());
            }
            return super.m_6518_(world, difficulty, reason, spawnData, nbt);
        }
    }
}

