/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.werewolves.api.entities.werewolf.IWerewolfAlpha;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class WerewolfAlphaEntity
extends WerewolfBaseEntity
implements IWerewolfAlpha {
    public static final int MAX_LEVEL = 4;
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(WerewolfAlphaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int followingEntities = 0;

    public static boolean spawnPredicateAlpha(EntityType<? extends WerewolfAlphaEntity> entityType, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return world.m_204166_(blockPos).m_203565_(ModBiomes.WEREWOLF_HEAVEN) && world.m_46791_() != net.minecraft.world.Difficulty.PEACEFUL && WerewolfAlphaEntity.spawnPredicateWerewolf(entityType, world, spawnReason, blockPos, random);
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        AttributeSupplier.Builder builder = VampireBaseEntity.getAttributeBuilder();
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder2 = builder.m_22268_(Attributes.f_22276_, 140.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        AttributeSupplier.Builder builder3 = builder2.m_22268_(Attributes.f_22281_, 6.0);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return builder3.m_22268_(Attributes.f_22279_, 0.34).m_22268_(Attributes.f_22277_, 5.0);
    }

    public WerewolfAlphaEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world, true);
    }

    public void m_7380_(@Nonnull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("level", this.getEntityLevel());
    }

    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    public int getFollowingCount() {
        return this.followingEntities;
    }

    public void setEntityLevel(int level) {
        if ((level = Mth.m_14045_((int)level, (int)0, (int)4)) >= 0) {
            this.m_20088_().m_135381_(LEVEL, (Object)level);
            this.updateEntityAttributes();
            this.m_6593_((Component)this.m_5677_().m_6879_().m_7220_((Component)Component.m_237110_((String)"entity.werewolves.alpha_werewolf.level", (Object[])new Object[]{level + 1})));
        } else {
            this.m_6593_(null);
        }
    }

    public int getEntityLevel() {
        return (Integer)this.m_20088_().m_135370_(LEVEL);
    }

    public int getMaxEntityLevel() {
        return 4;
    }

    public int m_8132_() {
        return 5;
    }

    public int m_8085_() {
        return 5;
    }

    public int getMaxFollowerCount() {
        Objects.requireNonNull(BalanceMobProps.mobProps);
        return (int)(5.0f * ((float)(this.getEntityLevel() + 1) / (float)(this.getMaxEntityLevel() + 1)));
    }

    public int m_6078_() {
        return 500;
    }

    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    public boolean m_214076_(ServerLevel level, LivingEntity entity) {
        super.m_214076_(level, entity);
        if (entity instanceof WerewolfAlphaEntity) {
            this.m_21153_(this.m_21233_());
        }
        return true;
    }

    public void m_7378_(@Nonnull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setEntityLevel(nbt.m_128451_("level"));
    }

    public boolean m_6052_() {
        return true;
    }

    public int m_8100_() {
        return 240;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ENTITY_WEREWOLF_GROWL.get();
    }

    public int suggestEntityLevel(Difficulty d) {
        int avg = Math.round(((float)d.avgPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int max = Math.round(((float)d.maxPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int min = Math.round(((float)d.minPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        return switch (this.f_19796_.m_188503_(7)) {
            case 0 -> min;
            case 1 -> max + 1;
            case 2 -> avg;
            case 3 -> avg + 1;
            case 4, 5 -> this.f_19796_.m_188503_(5);
            default -> this.f_19796_.m_188503_(max + 2 - min) + min;
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LEVEL, (Object)-1);
    }

    public int m_213860_() {
        return 20 + 5 * this.getEntityLevel();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 0.6, (double)0.7f, input -> input != null && !this.isLowerLevel((LivingEntity)input)));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.2));
        this.f_21345_.m_25352_(9, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::isLowerLevel));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, WerewolfAlphaEntity.class, true, false));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
    }

    private boolean isLowerLevel(LivingEntity player) {
        if (player instanceof Player) {
            int playerLevel = FactionPlayerHandler.getOpt((Player)((Player)player)).map(FactionPlayerHandler::getCurrentLevel).orElse(0);
            return (float)(playerLevel - 8) / 2.0f - (float)this.getEntityLevel() <= 0.0f;
        }
        return false;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return WerewolfForm.BEAST4L;
    }

    @Override
    public int getSkinType(@Nullable WerewolfForm form) {
        return 0;
    }

    @Override
    public int getEyeType(@Nullable WerewolfForm form) {
        return 0;
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return true;
    }

    protected void updateEntityAttributes() {
        this.m_21051_(Attributes.f_22277_).m_22100_(20.0);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.m_22100_(0.34 * Math.pow((1.2 - 1.0) / 5.0 + 1.0, this.getEntityLevel()));
        AttributeInstance attributeInstance2 = this.m_21051_(Attributes.f_22276_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance2.m_22100_(140.0 * Math.pow(1.2, this.getEntityLevel()));
        AttributeInstance attributeInstance3 = this.m_21051_(Attributes.f_22281_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance3.m_22100_(6.0 * Math.pow(1.2, this.getEntityLevel()));
    }
}

