/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.entity.IDefaultTaskMasterEntity;
import de.teamlapen.vampirism.entity.ai.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.ai.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.inventory.TaskBoardMenu;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.util.Helper;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WerewolfTaskMasterEntity
extends WerewolfBaseEntity
implements IDefaultTaskMasterEntity {
    private static final EntityDataAccessor<String> BIOME_TYPE = SynchedEntityData.m_135353_(WerewolfTaskMasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    @Nullable
    private Player interactor;

    public WerewolfTaskMasterEntity(EntityType<? extends WerewolfTaskMasterEntity> type, Level world) {
        super(type, world, false);
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return WerewolfBaseEntity.getAttributeBuilder();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!(this.interactor == null || this.interactor.m_6084_() && this.interactor.f_36096_ instanceof TaskBoardMenu)) {
            this.interactor = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6052_() {
        return Helper.isWerewolf((Player)Minecraft.m_91087_().f_91074_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, PathfinderMob.class, 10.0f, 1.0, 1.1, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.f_21345_.m_25352_(2, (Goal)new ForceLookEntityGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.6, true, 600, () -> false));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(10, (Goal)new LookAtClosestVisibleGoal((Mob)this, Player.class, 20.0f, 0.6f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, HunterBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIOME_TYPE, (Object)BuiltInRegistries.f_256934_.m_122315_().toString());
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor worldIn, @Nonnull DifficultyInstance difficultyIn, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setBiomeType(VillagerType.m_204073_((Holder)worldIn.m_204166_(this.m_20183_())));
        return data;
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player playerEntity, @Nonnull InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && Helper.isWerewolf(playerEntity) && this.interactor == null && this.processInteraction(playerEntity, (Entity)this)) {
            this.m_21573_().m_26573_();
            this.interactor = playerEntity;
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.interactor);
    }

    public VillagerType getBiomeType() {
        String key = (String)this.f_19804_.m_135370_(BIOME_TYPE);
        ResourceLocation id = new ResourceLocation(key);
        return (VillagerType)BuiltInRegistries.f_256934_.m_7745_(id);
    }

    protected void setBiomeType(VillagerType type) {
        this.f_19804_.m_135381_(BIOME_TYPE, (Object)BuiltInRegistries.f_256934_.m_7981_((Object)type).toString());
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return WerewolfForm.NONE;
    }

    @Override
    public int getSkinType(WerewolfForm form) {
        return 0;
    }

    @Override
    public int getEyeType(WerewolfForm form) {
        return 0;
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return false;
    }
}

