/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.proxy;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.werewolves.client.core.ClientEventHandler;
import de.teamlapen.werewolves.client.core.ModHUDOverlay;
import de.teamlapen.werewolves.client.core.ModItemRenderer;
import de.teamlapen.werewolves.client.core.ModKeys;
import de.teamlapen.werewolves.client.core.ModScreens;
import de.teamlapen.werewolves.client.core.RenderHandler;
import de.teamlapen.werewolves.network.ClientboundAttackTargetEventPacket;
import de.teamlapen.werewolves.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private ModHUDOverlay hudOverlay;
    private RenderHandler renderHandler;

    public ClientProxy() {
        if (Minecraft.m_91087_() != null) {
            this.renderHandler = new RenderHandler(Minecraft.m_91087_());
            MinecraftForge.EVENT_BUS.register((Object)this.renderHandler);
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)this.renderHandler);
        }
    }

    @Override
    public void onInitStep(@NotNull IInitListener.Step step, @NotNull ParallelDispatchEvent event) {
        super.onInitStep(step, event);
        switch (step) {
            case CLIENT_SETUP: {
                ClientEventHandler clientHandler = new ClientEventHandler();
                MinecraftForge.EVENT_BUS.register((Object)clientHandler);
                this.hudOverlay = new ModHUDOverlay();
                MinecraftForge.EVENT_BUS.register((Object)this.hudOverlay);
                ModKeys.register(clientHandler);
                break;
            }
            case LOAD_COMPLETE: {
                event.enqueueWork(ModItemRenderer::registerColorsUnsafe);
                event.enqueueWork(ModScreens::registerScreensUnsafe);
                break;
            }
        }
    }

    @Override
    public void handleAttackTargetEventPacket(ClientboundAttackTargetEventPacket packet) {
        this.hudOverlay.attackTriggered(packet.entityId());
    }

    @Override
    public void endVisionBatch() {
        this.renderHandler.endVisionBatch();
    }
}

